/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.tree;

import jams.workspace.dsproc.AbstractDataStoreProcessor;
import java.io.File;

public class FileObject {
    private File file;
    private boolean isValid = false;
    private String[] validExtensions = new String[]{"csv", "dat", "txt", "jmp"};
    AbstractDataStoreProcessor processor;

    public FileObject(File file) {
        this.file = file;
        if (file.isFile()) {
            boolean validExt = false;
            for (String ext : this.validExtensions) {
                if (!file.getName().endsWith(ext)) continue;
                validExt = true;
            }
            if (validExt) {
                this.processor = AbstractDataStoreProcessor.getProcessor((File)file);
            }
        }
        if (this.processor != null) {
            this.isValid = true;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    private FileObject(File file, AbstractDataStoreProcessor processor) {
        this.file = file;
        this.processor = processor;
    }

    public FileObject[] getSubDataStores() {
        if (this.processor == null) {
            return new FileObject[0];
        }
        AbstractDataStoreProcessor[] processors = this.processor.getSubDataStores();
        FileObject[] fileObjects = new FileObject[processors.length];
        int i = 0;
        for (AbstractDataStoreProcessor p : processors) {
            fileObjects[i++] = new FileObject(this.file, p);
        }
        return fileObjects;
    }

    public String toString() {
        if (this.processor == null) {
            return this.file.getName();
        }
        return this.processor.toString();
    }

    public File getFile() {
        return this.file;
    }
}

