/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.spreadsheet;

import jams.JAMS;
import jams.JAMSFileFilter;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.explorer.JAMSExplorer;
import jams.explorer.spreadsheet.GraphProperties;
import jams.explorer.spreadsheet.JAMSSpreadSheet;
import jams.explorer.spreadsheet.JAMSStackedPlot;
import jams.explorer.spreadsheet.JAMSTimePlot;
import jams.explorer.spreadsheet.SpreadsheetConstants;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIHelper;
import jams.workspace.DataValue;
import jams.workspace.DefaultDataSet;
import jams.workspace.JAMSWorkspace;
import jams.workspace.datatypes.DoubleValue;
import jams.workspace.stores.InputDataStore;
import jams.workspace.stores.TSDataStore;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;

public class STPConfigurator
extends JFrame {
    JPanel plotpanel;
    JPanel optionpanel;
    JPanel chooserpanel;
    GridBagLayout ogbl;
    JComboBox[] templateBox;
    JRadioButton[] timeButton;
    JLabel[] titleLabel;
    JTextField[] weightField;
    JTextField titleField;
    ButtonGroup axisGroup;
    JButton plotbutton;
    JButton settitleButton;
    JButton epsButton;
    JButton addbutton;
    JButton removebutton;
    JLabel edTitleLabel;
    JPanel chartpanel;
    JAMSSpreadSheet sheet;
    JAMSStackedPlot stackedplot;
    JFrame parent;
    JFileChooser templateChooser;
    File templateFile;
    private JAMSWorkspace workspace;
    HashMap<String, File> template_hashmap = new HashMap();
    int rows;
    int columns;
    int graphCount;
    int selectedTimeAxis;
    double[] weights;
    String[] headers;
    Vector<double[]> arrayVector;
    Vector<GraphProperties> propVector;
    Vector<Attribute.Calendar> timeVector;
    static String[] DATASET = new String[]{"tmax", "tmean"};
    String[] dataset;
    String[] output;
    String datasetID;
    static final int INPUT = 0;
    static final int OUTPUT = 1;
    private JAMSTimePlot[] jts;
    TSDataStore store;
    int rLeft;
    int rRight = 0;
    boolean invLeft;
    boolean invRight = false;
    boolean timeFormat_yy;
    boolean timeFormat_mm;
    boolean timeFormat_dd;
    boolean timeFormat_hm = true;
    String title;
    String tLeft;
    String tRight;
    String xAxisTitle = "";
    JPanel plotPanel;
    File[] templateFiles;
    int numberOfPlots;
    ActionListener plotaction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            STPConfigurator.this.repaintPlotPanel();
            STPConfigurator.this.setVisible(true);
        }
    };
    ActionListener titleListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            STPConfigurator.this.title = STPConfigurator.this.titleField.getText();
            STPConfigurator.this.stackedplot.setTitle(STPConfigurator.this.title);
        }
    };
    ActionListener saveImageAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                final JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showSaveDialog(STPConfigurator.this.parent);
                if (returnVal == 0) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            File file = chooser.getSelectedFile();
                            STPConfigurator.this.stackedplot.saveAsEPS(file);
                        }
                    };
                    WorkerDlg dlg = new WorkerDlg((Window)STPConfigurator.this.parent, JAMS.i18n((String)"EPS_EXPORT"));
                    dlg.setTask(r);
                    dlg.execute();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    ActionListener addAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            STPConfigurator.this.addPlot();
        }
    };
    ActionListener removeAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            STPConfigurator.this.removePlot();
        }
    };

    public STPConfigurator(JAMSExplorer explorer) {
        this.workspace = explorer.getWorkspace();
        this.parent = explorer.getExplorerFrame();
        this.setIconImage(this.parent.getIconImage());
        this.setTitle("StackedTimePlot Configurator");
        this.setDefaultCloseOperation(2);
        explorer.registerChild(this);
        Container cp = this.getContentPane();
        JPanel bgPanel = new JPanel();
        cp.setBackground(Color.WHITE);
        cp.add(bgPanel);
        bgPanel.setBackground(Color.WHITE);
        this.setLayout(new FlowLayout());
        Point parentloc = this.parent.getLocation();
        this.setLocation(parentloc.x + 30, parentloc.y + 30);
        this.dataset = this.createHashMap(this.getAccessibleTemplates());
        if (this.dataset.length <= 2) {
            this.numberOfPlots = this.dataset.length;
        }
        if (this.dataset.length == 0) {
            GUIHelper.showErrorDlg((Component)this, (String)SpreadsheetConstants.STP_ERR_NOTEMPFOUND, (String)"Error");
        }
        if (this.dataset.length > 2) {
            this.numberOfPlots = 2;
        }
        if (this.numberOfPlots > 0) {
            this.createPanel();
            this.pack();
            this.setVisible(true);
        }
    }

    public STPConfigurator(JAMSExplorer explorer, JAMSSpreadSheet output_sheet) {
        this.workspace = explorer.getWorkspace();
        this.parent = explorer.getExplorerFrame();
        this.setIconImage(this.parent.getIconImage());
        this.setTitle("StackedTimePlot Configurator");
        this.setDefaultCloseOperation(2);
        explorer.registerChild(this);
        this.sheet = output_sheet;
        Container cp = this.getContentPane();
        JPanel bgPanel = new JPanel();
        cp.setBackground(Color.WHITE);
        cp.add(bgPanel);
        bgPanel.setBackground(Color.WHITE);
        this.setLayout(new FlowLayout());
        Point parentloc = this.parent.getLocation();
        this.setLocation(parentloc.x + 30, parentloc.y + 30);
        this.dataset = this.createHashMap(this.getAccessibleTemplates());
        Logger.getLogger(STPConfigurator.class.getName()).log(Level.INFO, "dataset.length = {0}", this.dataset.length);
        if (this.dataset.length <= 2) {
            this.numberOfPlots = this.dataset.length;
        }
        if (this.dataset.length == 0) {
            GUIHelper.showErrorDlg((Component)this, (String)SpreadsheetConstants.STP_ERR_NOTEMPFOUND, (String)"Error");
        }
        if (this.dataset.length > 2) {
            this.numberOfPlots = 2;
        }
        if (this.numberOfPlots > 0) {
            this.createPanel();
            this.pack();
            this.setVisible(true);
        }
    }

    private void createPanel() {
        this.setLayout(new BorderLayout());
        this.plotpanel = new JPanel();
        this.plotpanel.setBackground(Color.WHITE);
        this.optionpanel = new JPanel();
        this.chooserpanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        this.chooserpanel.setLayout(gbl);
        this.ogbl = new GridBagLayout();
        this.optionpanel.setLayout(this.ogbl);
        this.plotbutton = new JButton(JAMS.i18n((String)"PLOT"));
        this.epsButton = new JButton(JAMS.i18n((String)"EPS_EXPORT"));
        this.settitleButton = new JButton(JAMS.i18n((String)"SET_TITLE"));
        this.addbutton = new JButton(JAMS.i18n((String)"ADD_PLOT"));
        this.removebutton = new JButton(JAMS.i18n((String)"REMOVE_PLOT"));
        this.titleField = new JTextField();
        this.titleField.setSize(50, 10);
        this.titleField.setText(JAMS.i18n((String)"STACKED_TIME_PLOT"));
        this.edTitleLabel = new JLabel(JAMS.i18n((String)"SET_TITLE:_"));
        this.buildOptionPanel();
        XYPlot[] xyplots = new XYPlot[this.numberOfPlots];
        DateAxis dateAxis = new DateAxis();
        this.jts = new JAMSTimePlot[this.numberOfPlots];
        this.weights = new double[this.numberOfPlots];
        for (int i = 0; i < this.numberOfPlots; ++i) {
            String datasetFileKey = (String)this.templateBox[i].getSelectedItem();
            this.propVector = new Vector();
            this.templateFiles[i] = this.template_hashmap.get(datasetFileKey);
            String[] datasetID = this.loadDatasetID(this.templateFiles[i]);
            if (datasetID[1].compareTo("false") == 0) {
                this.loadInputDSData(datasetID[0]);
                this.loadTemplate(this.templateFiles[i], 0);
                this.jts[i] = new JAMSTimePlot();
                this.jts[i].setPropVector(this.propVector);
                this.jts[i].createPlot();
                this.jts[i].setTitle(this.title);
                try {
                    this.weights[i] = new Double(this.weightField[i].getText());
                }
                catch (NumberFormatException nfe) {
                    this.weights[i] = 1.0;
                    this.weightField[i].setText("1");
                }
                this.titleLabel[i].setText(this.title);
                this.plot(i, 0);
            } else {
                StringTokenizer name_tokenizer = new StringTokenizer(this.templateFiles[i].getPath(), ".");
                String filename = "";
                filename = name_tokenizer.nextToken() + ".sdat";
                File ttpdatfile = new File(filename);
                this.loadOutputTTPData(ttpdatfile);
                this.loadTemplate(this.templateFiles[i], 1);
                this.jts[i] = new JAMSTimePlot();
                this.jts[i].setPropVector(this.propVector);
                this.jts[i].createPlot();
                this.jts[i].setTitle(this.title);
                try {
                    this.weights[i] = new Double(this.weightField[i].getText());
                }
                catch (NumberFormatException nfe) {
                    this.weights[i] = 1.0;
                    this.weightField[i].setText("1");
                }
                this.titleLabel[i].setText(this.title);
                this.plot(i, 1);
            }
            xyplots[i] = this.jts[i].getXYPlot();
            if (!this.timeButton[i].isSelected()) continue;
            dateAxis = this.jts[i].getDateAxis();
        }
        this.title = this.titleField.getText();
        this.stackedplot = new JAMSStackedPlot(xyplots, this.calc_weights(this.weights), dateAxis, this.title);
        this.chartpanel = this.stackedplot.getChartPanel();
        this.add((Component)this.chartpanel, "Center");
        this.add((Component)this.optionpanel, "South");
        this.repaint();
    }

    private void buildOptionPanel() {
        this.templateFiles = new File[this.numberOfPlots];
        this.templateBox = new JComboBox[this.numberOfPlots];
        this.timeButton = new JRadioButton[this.numberOfPlots];
        this.titleLabel = new JLabel[this.numberOfPlots];
        this.weightField = new JTextField[this.numberOfPlots];
        this.axisGroup = new ButtonGroup();
        this.plotbutton.addActionListener(this.plotaction);
        this.titleField.addActionListener(this.titleListener);
        this.settitleButton.addActionListener(this.titleListener);
        this.epsButton.addActionListener(this.saveImageAction);
        this.addbutton.addActionListener(this.addAction);
        this.removebutton.addActionListener(this.removeAction);
        GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)new JLabel(JAMS.i18n((String)"WEIGHT")), (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)new JLabel(JAMS.i18n((String)"TEMPLATE")), (int)1, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)new JLabel(JAMS.i18n((String)"TIME_AXIS")), (int)3, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.addbutton, (int)0, (int)(this.numberOfPlots + 1), (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.removebutton, (int)1, (int)(this.numberOfPlots + 1), (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.edTitleLabel, (int)0, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.titleField, (int)1, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.settitleButton, (int)2, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.plotbutton, (int)4, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.epsButton, (int)6, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
        for (int c = 0; c < this.numberOfPlots; ++c) {
            this.templateBox[c] = new JComboBox<String>(this.dataset);
            this.timeButton[c] = new JRadioButton();
            this.weightField[c] = new JTextField("1");
            this.axisGroup.add(this.timeButton[c]);
            this.timeButton[c].setSelected(true);
            this.selectedTimeAxis = c;
            this.titleLabel[c] = new JLabel("");
            this.templateBox[c].setSelectedIndex(c);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.weightField[c], (int)0, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.templateBox[c], (int)1, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.titleLabel[c], (int)2, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.timeButton[c], (int)3, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
        }
    }

    private void addPlot() {
        this.dataset = this.createHashMap(this.getAccessibleTemplates());
        if (this.numberOfPlots < this.dataset.length) {
            int[] selectedTemplates = new int[this.numberOfPlots];
            for (int k = 0; k < this.numberOfPlots; ++k) {
                selectedTemplates[k] = this.templateBox[k].getSelectedIndex();
            }
            ++this.numberOfPlots;
            this.remove(this.optionpanel);
            this.optionpanel = new JPanel();
            this.ogbl = new GridBagLayout();
            this.optionpanel.setLayout(this.ogbl);
            this.templateFiles = new File[this.numberOfPlots];
            this.templateBox = new JComboBox[this.numberOfPlots];
            this.timeButton = new JRadioButton[this.numberOfPlots];
            this.weightField = new JTextField[this.numberOfPlots];
            this.titleLabel = new JLabel[this.numberOfPlots];
            this.axisGroup = new ButtonGroup();
            this.plotbutton.addActionListener(this.plotaction);
            this.titleField.addActionListener(this.titleListener);
            this.settitleButton.addActionListener(this.titleListener);
            this.epsButton.addActionListener(this.saveImageAction);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)new JLabel(JAMS.i18n((String)"TEMPLATE")), (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)new JLabel(JAMS.i18n((String)"TIME_AXIS")), (int)2, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.addbutton, (int)0, (int)(this.numberOfPlots + 1), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.removebutton, (int)1, (int)(this.numberOfPlots + 1), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.edTitleLabel, (int)0, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.titleField, (int)1, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.settitleButton, (int)2, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.plotbutton, (int)4, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.epsButton, (int)6, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
            for (int c = 0; c < this.numberOfPlots; ++c) {
                this.templateBox[c] = new JComboBox<String>(this.dataset);
                this.timeButton[c] = new JRadioButton();
                this.weightField[c] = new JTextField("1");
                this.axisGroup.add(this.timeButton[c]);
                if (c == this.selectedTimeAxis) {
                    this.timeButton[c].setSelected(true);
                }
                this.titleLabel[c] = new JLabel("");
                if (c < selectedTemplates.length) {
                    this.templateBox[c].setSelectedIndex(selectedTemplates[c]);
                }
                GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.weightField[c], (int)0, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
                GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.templateBox[c], (int)1, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
                GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.titleLabel[c], (int)2, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
                GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.timeButton[c], (int)3, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
            }
            this.repaintPlotPanel();
        }
    }

    private void removePlot() {
        this.dataset = this.createHashMap(this.getAccessibleTemplates());
        if (this.numberOfPlots < this.dataset.length && this.numberOfPlots > 1) {
            int[] selectedTemplates = new int[this.numberOfPlots];
            for (int k = 0; k < this.numberOfPlots; ++k) {
                selectedTemplates[k] = this.templateBox[k].getSelectedIndex();
            }
            --this.numberOfPlots;
            this.remove(this.optionpanel);
            this.optionpanel = new JPanel();
            this.ogbl = new GridBagLayout();
            this.optionpanel.setLayout(this.ogbl);
            this.templateFiles = new File[this.numberOfPlots];
            this.templateBox = new JComboBox[this.numberOfPlots];
            this.timeButton = new JRadioButton[this.numberOfPlots];
            this.weightField = new JTextField[this.numberOfPlots];
            this.titleLabel = new JLabel[this.numberOfPlots];
            this.axisGroup = new ButtonGroup();
            this.plotbutton.addActionListener(this.plotaction);
            this.titleField.addActionListener(this.titleListener);
            this.settitleButton.addActionListener(this.titleListener);
            this.epsButton.addActionListener(this.saveImageAction);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)new JLabel(JAMS.i18n((String)"TEMPLATE")), (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)new JLabel(JAMS.i18n((String)"TIME_AXIS")), (int)2, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.addbutton, (int)0, (int)(this.numberOfPlots + 1), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.removebutton, (int)1, (int)(this.numberOfPlots + 1), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.edTitleLabel, (int)0, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.titleField, (int)1, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.settitleButton, (int)2, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.plotbutton, (int)4, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.epsButton, (int)6, (int)(this.numberOfPlots + 2), (int)1, (int)1, (double)0.0, (double)0.0);
            for (int c = 0; c < this.numberOfPlots; ++c) {
                this.templateBox[c] = new JComboBox<String>(this.dataset);
                this.timeButton[c] = new JRadioButton();
                this.weightField[c] = new JTextField("1");
                this.axisGroup.add(this.timeButton[c]);
                if (c == this.selectedTimeAxis) {
                    this.timeButton[c].setSelected(true);
                }
                this.titleLabel[c] = new JLabel("");
                if (c < selectedTemplates.length) {
                    this.templateBox[c].setSelectedIndex(selectedTemplates[c]);
                }
                GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.weightField[c], (int)0, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
                GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.templateBox[c], (int)1, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
                GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.titleLabel[c], (int)2, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
                GUIHelper.addGBComponent((Container)this.optionpanel, (GridBagLayout)this.ogbl, (Component)this.timeButton[c], (int)3, (int)(c + 1), (int)1, (int)1, (double)0.0, (double)0.0);
            }
            this.repaintPlotPanel();
        }
    }

    private void repaintPlotPanel() {
        this.remove(this.chartpanel);
        XYPlot[] xyplots = new XYPlot[this.numberOfPlots];
        DateAxis dateAxis = new DateAxis();
        this.jts = new JAMSTimePlot[this.numberOfPlots];
        this.weights = new double[this.numberOfPlots];
        for (int i = 0; i < this.numberOfPlots; ++i) {
            String datasetFileKey = (String)this.templateBox[i].getSelectedItem();
            this.propVector = new Vector();
            this.templateFiles[i] = this.template_hashmap.get(datasetFileKey);
            String[] datasetID = this.loadDatasetID(this.templateFiles[i]);
            if (datasetID[1].compareTo("false") == 0) {
                this.loadInputDSData(datasetID[0]);
                this.loadTemplate(this.templateFiles[i], 0);
                this.jts[i] = new JAMSTimePlot();
                this.jts[i].setPropVector(this.propVector);
                this.jts[i].createPlot();
                this.jts[i].setTitle(this.title);
                try {
                    this.weights[i] = new Double(this.weightField[i].getText());
                }
                catch (NumberFormatException nfe) {
                    this.weights[i] = 1.0;
                    this.weightField[i].setText("1");
                }
                this.titleLabel[i].setText(this.title);
                this.plot(i, 0);
            } else {
                StringTokenizer name_tokenizer = new StringTokenizer(this.templateFiles[i].getPath(), ".");
                String filename = "";
                filename = name_tokenizer.nextToken() + ".sdat";
                File ttpdatfile = new File(filename);
                this.loadOutputTTPData(ttpdatfile);
                this.loadTemplate(this.templateFiles[i], 1);
                this.jts[i] = new JAMSTimePlot();
                this.jts[i].setPropVector(this.propVector);
                this.jts[i].createPlot();
                this.jts[i].setTitle(this.title);
                try {
                    this.weights[i] = new Double(this.weightField[i].getText());
                }
                catch (NumberFormatException nfe) {
                    this.weights[i] = 1.0;
                    this.weightField[i].setText("1");
                }
                this.titleLabel[i].setText(this.title);
                this.plot(i, 1);
            }
            xyplots[i] = this.jts[i].getXYPlot();
            if (!this.timeButton[i].isSelected()) continue;
            dateAxis = this.jts[i].getDateAxis();
        }
        this.title = this.titleField.getText();
        this.stackedplot = new JAMSStackedPlot(xyplots, this.calc_weights(this.weights), dateAxis, this.title);
        this.chartpanel = this.stackedplot.getChartPanel();
        this.add((Component)this.chartpanel, "Center");
        this.add((Component)this.optionpanel, "South");
        this.pack();
    }

    private int[] calc_weights(double[] array) {
        int DEC = 1000;
        int size = array.length;
        int[] internal_weights = new int[size];
        for (int i = 0; i < size; ++i) {
            internal_weights[i] = new Integer("" + Math.round(array[i] * 1000.0));
        }
        return internal_weights;
    }

    private InputDataStore getInputDataStore(String datasetID) {
        InputDataStore store = this.workspace.getInputDataStore(datasetID);
        return store;
    }

    private File[] getAccessibleTemplates() {
        File[] temps_in_dir;
        ArrayList<File> tempList = new ArrayList<File>();
        File[] outputDirs = this.workspace.getOutputDataDirectories();
        File inputDir = new File(this.workspace.getDirectory().toString() + "/explorer");
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                boolean result;
                block7: {
                    Properties properties = new Properties();
                    result = false;
                    if (pathname.isFile() && pathname.getName().endsWith(".ttp")) {
                        try {
                            FileInputStream fin = new FileInputStream(pathname);
                            properties.load(fin);
                            fin.close();
                        }
                        catch (Exception fin) {
                            // empty catch block
                        }
                        try {
                            String typetest = properties.getProperty("template_type");
                            if (typetest.compareTo("TIME") == 0) {
                                result = true;
                                break block7;
                            }
                            result = false;
                        }
                        catch (NullPointerException npe) {
                            result = false;
                        }
                    } else {
                        result = false;
                    }
                }
                return result;
            }
        };
        for (File temp : temps_in_dir = inputDir.listFiles(filter)) {
            tempList.add(temp);
        }
        for (File odir : outputDirs) {
            for (File temp : temps_in_dir = odir.listFiles(filter)) {
                tempList.add(temp);
            }
        }
        File[] templateFiles = new File[tempList.size()];
        templateFiles = tempList.toArray(templateFiles);
        return templateFiles;
    }

    private String[] createHashMap(File[] tempFiles) {
        this.template_hashmap = new HashMap();
        String[] hashKeys = new String[tempFiles.length];
        for (int i = 0; i < tempFiles.length; ++i) {
            File file = tempFiles[i];
            hashKeys[i] = file.getName() + " " + file.getParentFile().getName();
            this.template_hashmap.put(hashKeys[i], file);
        }
        return hashKeys;
    }

    private String[] getAccessibleIDs() {
        int accessibleIDs = 0;
        boolean failedIDs = false;
        ArrayList<String> accIDList = new ArrayList<String>();
        int counter = 0;
        File testfile = new File(this.workspace.getDirectory().toString() + "/explorer");
        File[] filelist = testfile.listFiles();
        for (int i = 0; i < filelist.length; ++i) {
            String name = filelist[i].getName();
            if (name.indexOf(".ttp") == -1 || name.indexOf(".sdat") != -1) continue;
            accIDList.add(name);
            counter = i;
        }
        accessibleIDs = accIDList.size();
        String[] accIDArray = new String[accessibleIDs];
        accIDArray = accIDList.toArray(accIDArray);
        return accIDArray;
    }

    private String[] loadDatasetID(File templateFile) {
        Properties properties = new Properties();
        String[] id = new String[2];
        try {
            FileInputStream fin = new FileInputStream(templateFile);
            properties.load(fin);
            fin.close();
            String typetest = properties.getProperty("template_type");
            if (typetest.compareTo("TIME") == 0) {
                id[0] = properties.getProperty("store");
                id[1] = properties.getProperty("output");
            }
        }
        catch (Exception e) {
            id[0] = "---";
            id[1] = "false";
        }
        return id;
    }

    private void loadOutputTTPData(File file) {
        this.arrayVector = new Vector();
        this.timeVector = new Vector();
        StringTokenizer st = new StringTokenizer("\t");
        ArrayList<String> headerList = new ArrayList<String>();
        boolean b_headers = false;
        boolean b_data = false;
        boolean time_set = false;
        boolean stop = false;
        int file_columns = 0;
        String ST_DATA = "#data";
        String ST_HEADERS = "#headers";
        String ST_END = "#end";
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            while (in.ready()) {
                String s = in.readLine();
                st = new StringTokenizer(s, "\t");
                String actual_string = "";
                if (b_data) {
                    int i = 0;
                    Attribute.Calendar timeval = DefaultDataFactory.getDataFactory().createCalendar();
                    double[] rowBuffer = new double[file_columns];
                    while (st.hasMoreTokens()) {
                        actual_string = st.nextToken();
                        if (actual_string.compareTo("#end") != 0) {
                            if (!time_set) {
                                try {
                                    timeval.setValue(actual_string, "yyyy-MM-dd HH:mm");
                                }
                                catch (ParseException pe) {
                                    Logger.getLogger(STPConfigurator.class.getName()).log(Level.SEVERE, null, pe);
                                }
                                this.timeVector.add(timeval);
                                time_set = true;
                                continue;
                            }
                            try {
                                Double val = new Double(actual_string);
                                rowBuffer[i++] = val;
                            }
                            catch (Exception pe2) {
                                Logger.getLogger(STPConfigurator.class.getName()).log(Level.SEVERE, null, pe2);
                            }
                            continue;
                        }
                        stop = true;
                    }
                    if (stop) continue;
                    this.arrayVector.add(rowBuffer);
                    time_set = false;
                    continue;
                }
                while (st.hasMoreTokens()) {
                    String test = st.nextToken();
                    if (test.compareTo("#data") == 0) {
                        b_data = true;
                        b_headers = false;
                        file_columns = headerList.size();
                    }
                    if (b_headers) {
                        headerList.add(test);
                    }
                    if (test.compareTo("#headers") != 0) continue;
                    b_headers = true;
                }
            }
            this.headers = new String[file_columns];
            this.headers = headerList.toArray(this.headers);
            this.headers[0] = "";
            this.columns = file_columns - 1;
            this.rows = this.arrayVector.size();
        }
        catch (Exception eee) {
            GUIHelper.showErrorDlg((Component)this, (String)(JAMS.i18n((String)"FILE_NOT_FOUND:_") + file.getName()), (String)JAMS.i18n((String)"ERROR!"));
        }
    }

    private void loadInputDSData(String datasetID) {
        this.arrayVector = new Vector();
        this.timeVector = new Vector();
        InputDataStore inputDS = this.getInputDataStore(datasetID);
        if (!(inputDS instanceof TSDataStore)) {
            return;
        }
        this.store = (TSDataStore)inputDS;
        String dumpTimeFormat = this.store.getTimeFormat();
        ArrayList names = this.store.getDataSetDefinition().getAttributeValues("NAME");
        this.columns = this.store.getDataSetDefinition().getColumnCount();
        this.headers = new String[this.columns + 1];
        this.headers[0] = "";
        int i = 1;
        for (Object o : names) {
            this.headers[i++] = (String)o;
        }
        while (this.store.hasNext()) {
            DefaultDataSet ds = this.store.getNext();
            DataValue[] rowData = ds.getData();
            Attribute.Calendar timeval = DefaultDataFactory.getDataFactory().createCalendar();
            timeval.setValue(rowData[0].getString());
            timeval.setDateFormat(dumpTimeFormat);
            this.timeVector.add(timeval);
            double[] rowBuffer = new double[this.columns];
            for (i = 1; i < rowData.length; ++i) {
                rowBuffer[i - 1] = ((DoubleValue)rowData[i]).getDouble();
            }
            this.arrayVector.add(rowBuffer);
        }
        this.rows = this.arrayVector.size();
    }

    private void loadTimeIntervals(File[] templateFiles) {
        String timeSTART = "";
        String timeEND = "";
        String names = "";
        String name = "";
        boolean loadProp = false;
        Properties properties = new Properties();
        for (int i = 0; i < this.numberOfPlots; ++i) {
            try {
                FileInputStream fin = new FileInputStream(templateFiles[i]);
                properties.load(fin);
                fin.close();
            }
            catch (Exception fin) {
                // empty catch block
            }
            names = properties.getProperty("names");
            int no_of_props = new Integer(properties.getProperty("number"));
            StringTokenizer nameTokenizer = new StringTokenizer(names, ",");
            for (int c = 0; c < no_of_props; ++c) {
                String read_tEnd;
                if (!nameTokenizer.hasMoreTokens()) continue;
                name = nameTokenizer.nextToken();
                for (int k = 0; k < this.columns; ++k) {
                    if (this.headers[k].compareTo(name) != 0) continue;
                    loadProp = true;
                    break;
                }
                if (!loadProp) continue;
                if (i == 0) {
                    timeSTART = properties.getProperty(name + ".timeSTART");
                    timeEND = properties.getProperty(name + ".timeEND");
                    continue;
                }
                String read_tStart = properties.getProperty(name + ".timeSTART");
                if (read_tStart.compareTo(timeSTART) < 0) {
                    timeSTART = read_tStart;
                }
                if ((read_tEnd = properties.getProperty(name + ".timeEND")).compareTo(timeEND) <= 0) continue;
                timeEND = read_tEnd;
            }
        }
    }

    private void loadTemplate(File templateFile, int type) {
        int no_of_props;
        Properties properties = new Properties();
        boolean load_prop = false;
        int returnVal = -1;
        try {
            FileInputStream fin = new FileInputStream(templateFile);
            properties.load(fin);
            fin.close();
        }
        catch (Exception fin) {
            // empty catch block
        }
        this.datasetID = properties.getProperty("store");
        String names = properties.getProperty("names");
        this.graphCount = no_of_props = new Integer(properties.getProperty("number")).intValue();
        StringTokenizer nameTokenizer = new StringTokenizer(names, ",");
        for (int i = 0; i < no_of_props; ++i) {
            load_prop = false;
            GraphProperties gprop = new GraphProperties(this);
            if (!nameTokenizer.hasMoreTokens()) continue;
            String name = nameTokenizer.nextToken();
            for (int k = 0; k < this.columns; ++k) {
                if (this.headers[k + 1].compareTo(name) != 0) continue;
                gprop.setSelectedColumn(k);
                load_prop = true;
                break;
            }
            boolean readStart = false;
            boolean readEnd = false;
            gprop.setTimeSTART(0);
            gprop.setTimeEND(this.rows - 1);
            if (!load_prop) continue;
            gprop.setLegendName(properties.getProperty(name + ".legendname", "legend name"));
            int pos = new Integer(properties.getProperty(name + ".position"));
            gprop.setPosition(pos);
            String timeSTART = properties.getProperty(name + ".timeSTART");
            String timeEND = properties.getProperty(name + ".timeEND");
            String read = null;
            for (int tc = 0; !(tc >= this.rows || readStart && readEnd); ++tc) {
                read = gprop.getTimeIntervals()[tc];
                if (!readStart) {
                    if (!read.equals(timeSTART)) continue;
                    gprop.setTimeSTART(tc);
                    readStart = true;
                    continue;
                }
                if (!read.equals(timeEND)) continue;
                gprop.setTimeEND(tc);
                readEnd = true;
            }
            gprop.setName(name);
            gprop.setStroke(new Integer(properties.getProperty(name + ".linestroke", "2")));
            String stroke_color = properties.getProperty(name + ".linecolor", "255,0,0");
            StringTokenizer colorTokenizer = new StringTokenizer(stroke_color, ",");
            gprop.setSeriesPaint(new Color(new Integer(colorTokenizer.nextToken()), new Integer(colorTokenizer.nextToken()), new Integer(colorTokenizer.nextToken())));
            boolean lv = new Boolean(properties.getProperty(name + ".linesvisible"));
            gprop.setLinesVisible(lv);
            boolean sv = new Boolean(properties.getProperty(name + ".shapesvisible"));
            gprop.setShapesVisible(sv);
            int stype = new Integer(properties.getProperty(name + ".shapetype", "0"));
            int ssize = new Integer(properties.getProperty(name + ".shapesize"));
            gprop.setShape(stype, ssize);
            String shape_color = properties.getProperty(name + ".shapecolor", "255,0,0");
            StringTokenizer shapeTokenizer = new StringTokenizer(shape_color, ",");
            gprop.setSeriesFillPaint(new Color(new Integer(shapeTokenizer.nextToken()), new Integer(shapeTokenizer.nextToken()), new Integer(shapeTokenizer.nextToken())));
            int os = new Integer(properties.getProperty(name + ".outlinestroke"));
            gprop.setOutlineStroke(os);
            String outline_color = properties.getProperty(name + ".outlinecolor", "255,0,0");
            StringTokenizer outTokenizer = new StringTokenizer(outline_color, ",");
            gprop.setSeriesOutlinePaint(new Color(new Integer(outTokenizer.nextToken()), new Integer(outTokenizer.nextToken()), new Integer(outTokenizer.nextToken())));
            this.propVector.add(gprop);
        }
        this.title = properties.getProperty("title");
        this.tLeft = properties.getProperty("axisLTitle");
        this.tRight = properties.getProperty("axisRTitle");
        this.xAxisTitle = properties.getProperty("xAxisTitle");
        this.rLeft = new Integer(properties.getProperty("renderer_left"));
        this.rRight = new Integer(properties.getProperty("renderer_right"));
        this.invLeft = new Boolean(properties.getProperty("inv_left"));
        this.invRight = new Boolean(properties.getProperty("inv_right"));
        this.timeFormat_yy = new Boolean(properties.getProperty("timeFormat_yy"));
        this.timeFormat_mm = new Boolean(properties.getProperty("timeFormat_mmy"));
        this.timeFormat_dd = new Boolean(properties.getProperty("timeFormat_dd"));
        this.timeFormat_hm = new Boolean(properties.getProperty("timeFormat_hm"));
    }

    private void updatePropVector(int type) {
        for (int i = 0; i < this.propVector.size(); ++i) {
            this.propVector.get(i).applySTPProperties(this.arrayVector, this.timeVector);
        }
    }

    public void plot(int plot_index, int type) {
        final int index = plot_index;
        final int p_type = type;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                STPConfigurator.this.updatePropVector(p_type);
                int l = 0;
                int r = 0;
                XYLineAndShapeRenderer rendererLeft = new XYLineAndShapeRenderer();
                XYLineAndShapeRenderer rendererRight = new XYLineAndShapeRenderer();
                XYLineAndShapeRenderer lsr_R = new XYLineAndShapeRenderer();
                XYBarRenderer brr_R = new XYBarRenderer();
                XYDifferenceRenderer dfr_R = new XYDifferenceRenderer();
                XYAreaRenderer ar_R = new XYAreaRenderer();
                XYStepRenderer str_R = new XYStepRenderer();
                XYStepAreaRenderer sar_R = new XYStepAreaRenderer();
                XYLineAndShapeRenderer lsr_L = new XYLineAndShapeRenderer();
                XYBarRenderer brr_L = new XYBarRenderer();
                XYDifferenceRenderer dfr_L = new XYDifferenceRenderer();
                XYAreaRenderer ar_L = new XYAreaRenderer();
                XYStepRenderer str_L = new XYStepRenderer();
                XYStepAreaRenderer sar_L = new XYStepAreaRenderer();
                block16: for (int i = 0; i < STPConfigurator.this.propVector.size(); ++i) {
                    GraphProperties prop = STPConfigurator.this.propVector.get(i);
                    if (prop.getPosition() == 0) {
                        ++l;
                        switch (STPConfigurator.this.rLeft) {
                            case 0: {
                                lsr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                lsr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                lsr_L.setSeriesShape(i - r, prop.getSeriesShape());
                                lsr_L.setSeriesShapesVisible(i - r, prop.getShapesVisible());
                                lsr_L.setSeriesLinesVisible(i - r, prop.getLinesVisible());
                                lsr_L.setUseOutlinePaint(true);
                                lsr_L.setSeriesFillPaint(i - r, (Paint)prop.getSeriesFillPaint());
                                lsr_L.setUseFillPaint(true);
                                lsr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                lsr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                rendererLeft = lsr_L;
                                break;
                            }
                            case 1: {
                                brr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                brr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                brr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                brr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                rendererLeft = brr_L;
                                break;
                            }
                            case 2: {
                                ar_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                ar_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                ar_L.setSeriesShape(i - r, prop.getSeriesShape());
                                ar_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                ar_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                ar_L.setOutline(prop.getOutlineVisible());
                                rendererLeft = ar_L;
                                break;
                            }
                            case 3: {
                                str_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                str_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                str_L.setSeriesShape(i - r, prop.getSeriesShape());
                                rendererLeft = str_L;
                                break;
                            }
                            case 4: {
                                sar_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                sar_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                sar_L.setSeriesShape(i - r, prop.getSeriesShape());
                                sar_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                sar_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                sar_L.setOutline(prop.getOutlineVisible());
                                rendererLeft = sar_L;
                                break;
                            }
                            case 5: {
                                dfr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                dfr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                dfr_L.setSeriesShape(i - r, prop.getSeriesShape());
                                dfr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                dfr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                dfr_L.setShapesVisible(prop.getShapesVisible());
                                rendererLeft = dfr_L;
                                break;
                            }
                            default: {
                                lsr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                lsr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                lsr_L.setSeriesShape(i - r, prop.getSeriesShape());
                                lsr_L.setSeriesShapesVisible(i - r, prop.getShapesVisible());
                                lsr_L.setSeriesLinesVisible(i - r, prop.getLinesVisible());
                                lsr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                lsr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                rendererLeft = lsr_L;
                            }
                        }
                    }
                    if (prop.getPosition() != 1) continue;
                    ++r;
                    switch (STPConfigurator.this.rRight) {
                        case 0: {
                            lsr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            lsr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            lsr_R.setSeriesShape(i - l, prop.getSeriesShape());
                            lsr_R.setSeriesShapesVisible(i - l, prop.getShapesVisible());
                            lsr_R.setSeriesLinesVisible(i - l, prop.getLinesVisible());
                            lsr_R.setUseOutlinePaint(true);
                            lsr_R.setSeriesFillPaint(i - l, (Paint)prop.getSeriesFillPaint());
                            lsr_R.setUseFillPaint(true);
                            lsr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            lsr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = lsr_R;
                            continue block16;
                        }
                        case 1: {
                            brr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            brr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            brr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            brr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = brr_R;
                            continue block16;
                        }
                        case 2: {
                            ar_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            ar_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            ar_R.setSeriesShape(i - l, prop.getSeriesShape());
                            ar_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            ar_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = ar_R;
                            continue block16;
                        }
                        case 3: {
                            str_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            str_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            str_R.setSeriesShape(i - l, prop.getSeriesShape());
                            str_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            str_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = str_R;
                            continue block16;
                        }
                        case 4: {
                            sar_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            sar_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            sar_R.setSeriesShape(i - l, prop.getSeriesShape());
                            sar_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            sar_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = sar_R;
                            continue block16;
                        }
                        case 5: {
                            dfr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            dfr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            dfr_R.setSeriesShape(i - l, prop.getSeriesShape());
                            dfr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            dfr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            dfr_R.setShapesVisible(prop.getShapesVisible());
                            rendererRight = dfr_R;
                            continue block16;
                        }
                        default: {
                            lsr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            lsr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            lsr_R.setSeriesShape(i - l, prop.getSeriesShape());
                            lsr_R.setSeriesShapesVisible(i - l, prop.getShapesVisible());
                            lsr_R.setSeriesLinesVisible(i - l, prop.getLinesVisible());
                            lsr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            lsr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = lsr_R;
                        }
                    }
                }
                if (l > 0) {
                    STPConfigurator.this.jts[index].plotLeft((XYItemRenderer)rendererLeft, STPConfigurator.this.tLeft, STPConfigurator.this.xAxisTitle, STPConfigurator.this.invLeft);
                }
                if (r > 0) {
                    STPConfigurator.this.jts[index].plotRight((XYItemRenderer)rendererRight, STPConfigurator.this.tRight, STPConfigurator.this.xAxisTitle, STPConfigurator.this.invRight);
                }
                if (r == 0 && l == 0) {
                    STPConfigurator.this.jts[index].plotEmpty();
                }
                STPConfigurator.this.jts[index].setTitle(STPConfigurator.this.title);
                STPConfigurator.this.jts[index].setDateFormat(STPConfigurator.this.timeFormat_yy, STPConfigurator.this.timeFormat_mm, STPConfigurator.this.timeFormat_dd, STPConfigurator.this.timeFormat_hm);
            }
        };
        WorkerDlg dlg = new WorkerDlg((Window)this.parent, JAMS.i18n((String)"CREATING_PLOT..."));
        dlg.setTask(r);
        dlg.execute();
    }

    public JFileChooser getTemplateChooser() {
        File dir = new File(this.workspace.getDirectory().toString());
        if (this.templateChooser == null) {
            this.templateChooser = new JFileChooser();
            this.templateChooser.setFileFilter(JAMSFileFilter.getTtpFilter());
            dir = new File(this.workspace.getDirectory().toString() + "/explorer");
            this.templateChooser.setCurrentDirectory(dir);
        }
        this.templateChooser.setCurrentDirectory(dir);
        this.templateChooser.setFileFilter(JAMSFileFilter.getTtpFilter());
        this.templateChooser.setSelectedFile(new File(""));
        return this.templateChooser;
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public Vector<double[]> getArrayVector() {
        return this.arrayVector;
    }
}

