/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.spreadsheet;

import jams.JAMSFileFilter;
import jams.explorer.JAMSExplorer;
import jams.explorer.spreadsheet.CTSPlot;
import jams.explorer.spreadsheet.GraphProperties;
import jams.explorer.spreadsheet.JAMSSpreadSheet;
import jams.explorer.spreadsheet.JAMSXYPlot;
import jams.explorer.spreadsheet.PropertyPanel;
import jams.explorer.spreadsheet.SpreadsheetConstants;
import jams.explorer.spreadsheet.XYRow;
import jams.gui.tools.GUIHelper;
import jams.workspace.JAMSWorkspace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;

public class JXYConfigurator
extends JFrame {
    private JAMSWorkspace workspace;
    GroupLayout gLayout;
    GroupLayout.SequentialGroup hGroup;
    GroupLayout.SequentialGroup vGroup;
    GroupLayout.Group group1;
    GroupLayout.Group group2;
    GroupLayout.Group group3;
    GroupLayout.Group group4;
    GroupLayout.Group group5;
    GroupLayout.Group group6;
    GroupLayout.Group group7;
    GroupLayout.Group group8;
    GroupLayout.Group group9;
    GroupLayout.Group group10;
    GroupLayout.Group group11;
    GroupLayout.Group group12;
    GroupLayout.Group group13;
    GroupLayout.Group group14;
    GroupLayout.Group group15;
    private JFrame parent;
    private JFrame thisDlg;
    private JXYConfigurator thisJXY = this;
    private JPanel frame;
    private JPanel mainpanel;
    private JPanel plotpanel;
    private JPanel optionpanel;
    private JPanel graphpanel;
    private JPanel southpanel;
    private JPanel edTitlePanel;
    private JPanel edLeftAxisPanel;
    private JPanel edRightAxisPanel;
    private JPanel edTimeAxisPanel;
    private JSplitPane split_hor = new JSplitPane(1);
    private JSplitPane split_vert = new JSplitPane(0);
    private JPanel[] datapanels;
    private JScrollPane graphScPane;
    private JScrollPane plotScPane;
    private JScrollPane mainScPane;
    private JScrollPane optScPane;
    private JPanel savePanel;
    private String[] headers;
    private File templateFile;
    private boolean output_ttp = false;
    private JButton saveTempButton = new JButton("Save Template");
    private JButton loadTempButton = new JButton("Load Template");
    private JLabel edTitle = new JLabel("Plot Title: ");
    private JLabel edLeft = new JLabel("Left axis title: ");
    private JLabel edXAxis = new JLabel("X axis title");
    private JLabel edRight = new JLabel("Right axis title: ");
    private JLabel rLeftLabel = new JLabel("Renderer left");
    private JLabel rRightLabel = new JLabel("Renderer right");
    private JLabel invLeftLabel = new JLabel("Invert left axis");
    private JLabel invRightLabel = new JLabel("Invert right axis");
    private JTextField edTitleField = new JTextField(14);
    private JTextField edLeftField = new JTextField(14);
    private JTextField edRightField = new JTextField(14);
    private JTextField edXAxisField = new JTextField(14);
    private String[] types = new String[]{"Line and Shape", "Bar", "Area", "Step", "StepArea", "Difference"};
    private JComboBox rLeftBox = new JComboBox<String>(this.types);
    private JComboBox rRightBox = new JComboBox<String>(this.types);
    private JCheckBox invLeftBox = new JCheckBox("Invert left Axis");
    private JCheckBox invRightBox = new JCheckBox("Invert right Axis");
    private ButtonGroup isXAxisGroup = new ButtonGroup();
    private JButton applyButton = new JButton("PLOT");
    private JButton addButton = new JButton("Add Graph");
    private JButton saveButton = new JButton("EPS export");
    private Vector<GraphProperties> propVector = new Vector();
    private Vector<PropertyPanel> panelVector = new Vector();
    private JAMSXYPlot jxys = new JAMSXYPlot();
    public XYRow[] sorted_Row;
    private boolean tempLoaded = true;
    private int x_series_index;
    private int colour_cnt;
    double row_start;
    double row_end;
    private boolean d_start_changed;
    private boolean d_end_changed;
    int[] range = new int[2];
    HashMap<String, Color> colorTable = new HashMap();
    int[] rows;
    int[] columns;
    JTable table;
    CTSPlot ctsplot;
    int graphCount = 0;
    JCheckBox[] activate;
    JComboBox[] datachoice;
    JComboBox[] poschoice;
    JComboBox[] typechoice;
    JComboBox[] colorchoice;
    ActionListener[] activationChange;
    JAMSSpreadSheet sheet;
    ActionListener saveTempListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String fileID = JXYConfigurator.this.saveTemplate();
            StringTokenizer name_tokenizer = new StringTokenizer(fileID, ".");
            String filename = "";
            filename = name_tokenizer.hasMoreTokens() ? name_tokenizer.nextToken() + ".sdat" : fileID + ".sdat";
            if (JXYConfigurator.this.sheet.isOutputSheet()) {
                JXYConfigurator.this.sheet.saveAll(filename);
            }
        }
    };
    ActionListener loadTempListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal = -1;
            try {
                returnVal = JXYConfigurator.this.sheet.getTemplateChooser().showOpenDialog(JXYConfigurator.this.thisDlg);
                File file = JXYConfigurator.this.sheet.getTemplateChooser().getSelectedFile();
                if (returnVal == 0) {
                    JXYConfigurator.this.loadTemplate(file);
                    JXYConfigurator.this.plotAllGraphs();
                }
            }
            catch (Exception fnfexc) {
                returnVal = -1;
            }
        }
    };
    ActionListener titleListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            JXYConfigurator.this.ctsplot.getChart().setTitle(JXYConfigurator.this.edTitleField.getText());
        }
    };
    ActionListener rendererColorListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            for (int i = 0; i < JXYConfigurator.this.panelVector.size(); ++i) {
                ((PropertyPanel)JXYConfigurator.this.panelVector.get(i)).setColorLabelColor();
            }
        }
    };
    ActionListener propbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JXYConfigurator.this.ctsplot.getChartPanel().doEditChartProperties();
        }
    };
    ActionListener addbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JXYConfigurator.this.addGraph((GraphProperties)JXYConfigurator.this.propVector.get(0));
        }
    };
    ActionListener plotbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] range = JXYConfigurator.this.setPossibleDataIntervals();
            for (int i = 0; i < JXYConfigurator.this.propVector.size(); ++i) {
                GraphProperties prop = (GraphProperties)JXYConfigurator.this.propVector.get(i);
                prop.setXIntervals(range);
            }
            JXYConfigurator.this.plotAllGraphs();
            JXYConfigurator.this.dStartChanged(false);
            JXYConfigurator.this.dEndChanged(false);
            JXYConfigurator.this.setVisible(true);
        }
    };
    ActionListener actChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    ActionListener saveImageAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(JAMSFileFilter.getEpsFilter());
            int returnVal = chooser.showSaveDialog(JXYConfigurator.this.thisDlg);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                try {
                    JXYConfigurator.this.jxys.saveAsEPS(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };

    public JXYConfigurator(JFrame parent, JAMSSpreadSheet sheet, File templateFile, JAMSExplorer explorer) {
        this.setParent(parent);
        this.setIconImage(parent.getIconImage());
        this.setTitle("XYPlot Viewer");
        this.workspace = explorer.getWorkspace();
        this.setDefaultCloseOperation(2);
        explorer.registerChild(this);
        this.setLayout(new FlowLayout());
        Point parentloc = explorer.getExplorerFrame().getLocation();
        this.setLocation(parentloc.x + 30, parentloc.y + 30);
        this.sheet = sheet;
        this.table = sheet.table;
        if (this.table.getSelectedColumn() == -1) {
            this.table.selectAll();
        }
        this.templateFile = templateFile;
        this.rows = this.table.getSelectedRows();
        this.columns = this.table.getSelectedColumns();
        this.graphCount = this.columns.length;
        this.headers = new String[this.graphCount];
        for (int k = 0; k < this.graphCount; ++k) {
            this.headers[k] = this.table.getColumnName(this.columns[k]);
        }
        this.d_start_changed = false;
        this.d_end_changed = false;
        if (templateFile == null) {
            this.tempLoaded = false;
        }
        if (this.isDataTemplate(templateFile) && this.table.getColumnCount() > 1 || !this.tempLoaded) {
            try {
                this.writeSortedData(this.columns[0]);
            }
            catch (ArrayIndexOutOfBoundsException aiofb) {
                this.writeSortedData(0);
            }
            this.createPanel();
            this.pack();
            this.setVisible(true);
        } else {
            GUIHelper.showErrorDlg((Component)sheet, (String)SpreadsheetConstants.JXY_ERR_NODATATEMPLATE, (String)"Error");
        }
    }

    private boolean isDataTemplate(File templateFile) {
        Properties properties = new Properties();
        boolean result = false;
        try {
            FileInputStream fin = new FileInputStream(templateFile);
            properties.load(fin);
            fin.close();
        }
        catch (Exception ex) {
            result = false;
        }
        try {
            String typetest = properties.getProperty("template_type");
            result = typetest.compareTo("DATA") == 0;
        }
        catch (NullPointerException npe) {
            result = false;
        }
        return result;
    }

    public void createPanel() {
        block5: {
            this.thisDlg = this;
            this.colour_cnt = 0;
            this.colorTable.put("yellow", Color.yellow);
            this.colorTable.put("orange", Color.orange);
            this.colorTable.put("red", Color.red);
            this.colorTable.put("pink", Color.pink);
            this.colorTable.put("magenta", Color.magenta);
            this.colorTable.put("cyan", Color.cyan);
            this.colorTable.put("blue", Color.blue);
            this.colorTable.put("green", Color.green);
            this.colorTable.put("gray", Color.gray);
            this.colorTable.put("lightgray", Color.lightGray);
            this.colorTable.put("black", Color.black);
            JLabel nameLabel = new JLabel("Name");
            JLabel posLabel = new JLabel("Position");
            JLabel typeLabel = new JLabel("Renderer");
            JLabel colorLabel = new JLabel("Colour");
            JLabel dataLabel = new JLabel("Select Data / Legend Entry");
            JLabel timeLabel = new JLabel("Data Range");
            JLabel emptyTimeLabel = new JLabel("    ");
            JLabel legendLabel = new JLabel("Legend Entry");
            nameLabel.setBackground(Color.DARK_GRAY);
            posLabel.setBackground(Color.DARK_GRAY);
            typeLabel.setBackground(Color.DARK_GRAY);
            colorLabel.setBackground(Color.DARK_GRAY);
            dataLabel.setBackground(Color.DARK_GRAY);
            timeLabel.setBackground(Color.DARK_GRAY);
            this.savePanel = new JPanel();
            GridBagLayout sgbl = new GridBagLayout();
            this.savePanel.setLayout(sgbl);
            GUIHelper.addGBComponent((Container)this.savePanel, (GridBagLayout)sgbl, (Component)this.saveButton, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.savePanel, (GridBagLayout)sgbl, (Component)this.saveTempButton, (int)0, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.savePanel, (GridBagLayout)sgbl, (Component)this.loadTempButton, (int)0, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
            this.saveButton.addActionListener(this.saveImageAction);
            this.saveTempButton.addActionListener(this.saveTempListener);
            this.loadTempButton.addActionListener(this.loadTempListener);
            this.plotpanel = new JPanel();
            this.plotpanel.setLayout(new BorderLayout());
            this.setLayout(new BorderLayout());
            this.graphScPane = new JScrollPane();
            this.optionpanel = new JPanel();
            this.graphpanel = new JPanel();
            this.initGroupUI();
            this.southpanel = new JPanel();
            this.southpanel.setLayout(new FlowLayout());
            this.edTitlePanel = new JPanel();
            this.edTitlePanel.setLayout(new FlowLayout());
            this.edLeftAxisPanel = new JPanel();
            this.edLeftAxisPanel.setLayout(new FlowLayout());
            this.edRightAxisPanel = new JPanel();
            this.edRightAxisPanel.setLayout(new FlowLayout());
            this.edTitleField.setText(this.sheet.getID());
            this.edTitleField.setSize(40, 10);
            this.edTitleField.addActionListener(this.plotbuttonclick);
            this.edLeftField.setText("Left Axis Title");
            this.edLeftField.addActionListener(this.plotbuttonclick);
            this.edLeftField.setSize(40, 10);
            this.edRightField.setText("Right Axis Title");
            this.edRightField.addActionListener(this.plotbuttonclick);
            this.edRightField.setSize(40, 10);
            this.edXAxisField.setText("x axis title");
            this.edXAxisField.addActionListener(this.plotbuttonclick);
            this.applyButton.addActionListener(this.plotbuttonclick);
            this.optionpanel.add(this.edTitle);
            this.optionpanel.add(this.edTitleField);
            this.optionpanel.add(this.edLeft);
            this.optionpanel.add(this.edLeftField);
            this.optionpanel.add(this.edRight);
            this.optionpanel.add(this.edRightField);
            this.optionpanel.add(this.applyButton);
            this.rLeftBox.setSelectedIndex(0);
            this.rLeftBox.addActionListener(this.rendererColorListener);
            this.rRightBox.setSelectedIndex(0);
            this.rRightBox.addActionListener(this.rendererColorListener);
            if (this.templateFile != null && this.templateFile.exists()) {
                try {
                    if (!this.output_ttp) {
                        this.loadTemplate(this.templateFile);
                        break block5;
                    }
                    this.loadTemplate(this.templateFile);
                }
                catch (Exception fnfe) {
                    Logger.getLogger(JXYConfigurator.class.getName()).log(Level.SEVERE, null, fnfe);
                    this.initGraphLoad();
                }
            } else {
                this.initGraphLoad();
            }
        }
        this.createOptionPanel();
        this.handleRenderer();
        this.jxys.setPropVector(this.propVector);
        this.jxys.createPlot();
        JPanel graphPanel = new JPanel();
        JPanel optPanel = new JPanel();
        graphPanel.add(this.graphpanel);
        optPanel.add(this.optionpanel);
        this.graphScPane = new JScrollPane(graphPanel);
        this.graphScPane.setSize(new Dimension(512, 300));
        this.graphScPane.setVerticalScrollBarPolicy(22);
        this.jxys.getPanel().add((Component)this.savePanel, "East");
        this.optionpanel.setBorder(new EtchedBorder());
        this.plotScPane = new JScrollPane(this.jxys.getPanel());
        this.optScPane = new JScrollPane(optPanel);
        this.split_hor.add((Component)this.optScPane, 0);
        this.split_hor.add((Component)this.graphScPane, 1);
        this.split_vert.add((Component)this.split_hor, 0);
        this.split_vert.add((Component)this.plotScPane, 1);
        this.add(this.split_vert);
        this.plotAllGraphs();
    }

    private void initGraphLoad() {
        GraphProperties prop;
        int k;
        for (k = 0; k < this.graphCount; ++k) {
            prop = new GraphProperties(this.thisJXY);
            prop.setIndex(k);
            prop.setSelectedColumn(this.columns[k]);
            prop.setXSeries(this.columns[0]);
            prop.setSelectedRows(this.rows);
            if (k == 0) {
                prop.setIsXSeries(true);
            } else {
                prop.setIsXSeries(false);
            }
            int color_cnt = k < 9 ? k : 0;
            String[] colors = this.getColorScheme(color_cnt);
            prop.setSeriesPaint(this.colorTable.get(colors[0]));
            prop.setSeriesFillPaint(this.colorTable.get(colors[1]));
            prop.setSeriesOutlinePaint(this.colorTable.get(colors[2]));
            prop.setLinesVisible(false);
            prop.setShapesVisible(true);
            prop.setStroke(0);
            prop.setShape(5, 3);
            String s = this.table.getColumnName(this.columns[k]);
            prop.setLegendName(s);
            prop.setName(s);
            this.propVector.add(k, prop);
        }
        this.range = this.setDataIntervals();
        for (k = 0; k < this.propVector.size(); ++k) {
            prop = this.propVector.get(k);
            prop.setXIntervals(this.range);
            if (k == this.x_series_index) {
                prop.setDataSTART(this.row_start);
                prop.setDataEND(this.row_end);
            }
            PropertyPanel ppanel = new PropertyPanel(this.thisJXY, prop);
            this.panelVector.add(ppanel);
            if (this.panelVector.size() > 0) {
                this.setXGUI(prop, ppanel);
            }
            this.addPropGroup(this.panelVector.get(k));
        }
        this.finishGroupUI();
    }

    private void writeSortedData(int x_col) {
        int row_nr = this.tempLoaded ? this.table.getRowCount() : this.rows.length;
        int col_nr = this.table.getColumnCount();
        this.sorted_Row = new XYRow[row_nr];
        for (int i = 0; i < row_nr; ++i) {
            double[] rowarray = new double[col_nr];
            for (int j = 0; j < col_nr; ++j) {
                try {
                    rowarray[j] = (Double)this.table.getValueAt(i, j);
                    continue;
                }
                catch (ClassCastException cce) {
                    rowarray[j] = 0.0;
                }
            }
            this.sorted_Row[i] = new XYRow(rowarray, x_col);
        }
        Arrays.sort(this.sorted_Row);
    }

    private void resortData(int x_col) {
        for (int i = 0; i < this.sorted_Row.length; ++i) {
            this.sorted_Row[i].setCompareIndex(x_col);
        }
        Arrays.sort(this.sorted_Row);
    }

    public int[] setDataIntervals() {
        int[] range = new int[2];
        int x_column = this.propVector.get(this.x_series_index).getSelectedColumn();
        this.row_start = this.sorted_Row[0].col[x_column];
        this.row_end = this.sorted_Row[this.sorted_Row.length - 1].col[x_column];
        range[0] = 0;
        range[1] = this.sorted_Row.length - 1;
        this.dStartChanged(true);
        this.dEndChanged(true);
        return range;
    }

    public void setMaxDataIntervals(GraphProperties x_prop) {
        int[] range = new int[2];
        this.resortData(x_prop.getSelectedColumn());
        range = this.setDataIntervals();
        this.range = range;
        x_prop.setXIntervals(range);
        x_prop.setDataSTART(this.row_start);
        x_prop.setDataEND(this.row_end);
        this.dStartChanged(false);
        this.dEndChanged(false);
    }

    public void dStartChanged(boolean state) {
        this.d_start_changed = state;
    }

    public void dEndChanged(boolean state) {
        this.d_end_changed = state;
    }

    private void setXDataIntervals() {
    }

    public int[] setPossibleDataIntervals() {
        int[] range = new int[2];
        GraphProperties x_prop = this.propVector.get(this.x_series_index);
        if (!this.d_start_changed || !this.d_end_changed) {
            boolean out_of_boundaries;
            int x_col;
            int i;
            double end;
            double start;
            if (!this.d_start_changed) {
                range[0] = this.range[0];
            } else {
                start = x_prop.getDataSTART();
                end = x_prop.getDataEND();
                i = 0;
                x_col = x_prop.getSelectedColumn();
                boolean bl = out_of_boundaries = start < this.sorted_Row[0].col[x_col] || start > this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                if (end < start) {
                    end = start;
                }
                if (!out_of_boundaries) {
                    while (!(start >= this.sorted_Row[i].col[x_col]) || !(start <= this.sorted_Row[i + 1].col[x_col])) {
                        ++i;
                    }
                    if (start == this.sorted_Row[i].col[x_col]) {
                        start = this.sorted_Row[i].col[x_col];
                        range[0] = i;
                    } else {
                        start = this.sorted_Row[i + 1].col[x_col];
                        range[0] = i + 1;
                    }
                } else {
                    if (start < this.sorted_Row[0].col[x_col]) {
                        start = this.sorted_Row[0].col[x_col];
                        range[0] = 0;
                    }
                    if (start > this.sorted_Row[this.sorted_Row.length - 1].col[x_col]) {
                        start = this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                        range[0] = this.sorted_Row.length - 1;
                    }
                }
                this.row_start = start;
            }
            if (!this.d_end_changed) {
                range[1] = this.range[1];
            } else {
                start = x_prop.getDataSTART();
                end = x_prop.getDataEND();
                i = 0;
                x_col = x_prop.getSelectedColumn();
                boolean bl = out_of_boundaries = end < this.sorted_Row[0].col[x_col] || end > this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                if (!out_of_boundaries) {
                    while (!(end >= this.sorted_Row[i].col[x_col]) || !(end <= this.sorted_Row[i + 1].col[x_col])) {
                        ++i;
                    }
                    if (end == this.sorted_Row[i + 1].col[x_col]) {
                        end = this.sorted_Row[i + 1].col[x_col];
                        range[1] = i + 1;
                    } else {
                        end = this.sorted_Row[i].col[x_col];
                        range[1] = i;
                    }
                } else {
                    if (end < this.sorted_Row[0].col[x_col]) {
                        end = this.sorted_Row[0].col[x_col];
                        range[1] = 0;
                    }
                    if (end > this.sorted_Row[this.sorted_Row.length - 1].col[x_col]) {
                        end = this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                        range[1] = this.sorted_Row.length - 1;
                    }
                }
                this.row_end = end;
            }
        } else {
            boolean out_of_boundaries;
            double start = x_prop.getDataSTART();
            double end = x_prop.getDataEND();
            int i = 0;
            int x_col = x_prop.getSelectedColumn();
            boolean bl = out_of_boundaries = start < this.sorted_Row[0].col[x_col] || start > this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
            if (end < start) {
                end = start;
            }
            if (!out_of_boundaries) {
                while (!(start >= this.sorted_Row[i].col[x_col]) || !(start <= this.sorted_Row[i + 1].col[x_col])) {
                    ++i;
                }
                if (start == this.sorted_Row[i].col[x_col]) {
                    start = this.sorted_Row[i].col[x_col];
                    range[0] = i;
                } else {
                    start = this.sorted_Row[i + 1].col[x_col];
                    range[0] = i + 1;
                }
            } else {
                if (start < this.sorted_Row[0].col[x_col]) {
                    start = this.sorted_Row[0].col[x_col];
                    range[0] = 0;
                }
                if (start > this.sorted_Row[this.sorted_Row.length - 1].col[x_col]) {
                    start = this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                    range[0] = this.sorted_Row.length - 1;
                }
            }
            boolean bl2 = out_of_boundaries = end < this.sorted_Row[0].col[x_col] || end > this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
            if (!out_of_boundaries) {
                while (!(end >= this.sorted_Row[i].col[x_col]) || !(end <= this.sorted_Row[i + 1].col[x_col])) {
                    ++i;
                }
                if (end == this.sorted_Row[i + 1].col[x_col]) {
                    end = this.sorted_Row[i + 1].col[x_col];
                    range[1] = i + 1;
                } else {
                    end = this.sorted_Row[i].col[x_col];
                    range[1] = i;
                }
            } else {
                if (end < this.sorted_Row[0].col[x_col]) {
                    end = this.sorted_Row[0].col[x_col];
                    range[1] = 0;
                }
                if (end > this.sorted_Row[this.sorted_Row.length - 1].col[x_col]) {
                    end = this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                    range[1] = this.sorted_Row.length - 1;
                }
            }
            this.row_start = start;
            this.row_end = end;
        }
        this.range = range;
        return range;
    }

    private String[] getColorScheme(int scheme) {
        String[] colors = new String[3];
        switch (scheme) {
            case 0: {
                colors[0] = "red";
                colors[1] = "red";
                colors[2] = "gray";
                break;
            }
            case 1: {
                colors[0] = "blue";
                colors[1] = "blue";
                colors[2] = "black";
                break;
            }
            case 2: {
                colors[0] = "green";
                colors[1] = "green";
                colors[2] = "gray";
                break;
            }
            case 3: {
                colors[0] = "black";
                colors[1] = "black";
                colors[2] = "yellow";
                break;
            }
            case 4: {
                colors[0] = "orange";
                colors[1] = "orange";
                colors[2] = "cyan";
                break;
            }
            case 5: {
                colors[0] = "cyan";
                colors[1] = "cyan";
                colors[2] = "black";
                break;
            }
            case 6: {
                colors[0] = "magenta";
                colors[1] = "yellow";
                colors[2] = "magenta";
                break;
            }
            case 7: {
                colors[0] = "lightgray";
                colors[1] = "orange";
                colors[2] = "lightgray";
                break;
            }
            default: {
                colors[0] = "red";
                colors[1] = "blue";
                colors[2] = "red";
            }
        }
        return colors;
    }

    public void addGraph(GraphProperties prop) {
        AddGraphDlg dlg = new AddGraphDlg();
        dlg.setVisible(true);
        if (dlg.getResult()) {
            int i = this.propVector.indexOf(prop);
            GraphProperties newProp = new GraphProperties(this);
            ++this.colour_cnt;
            newProp.setPosition(dlg.getSide());
            int pos = dlg.getPosition();
            dlg.dispose();
            newProp.setSeriesPaint(Color.BLACK);
            newProp.setSeriesFillPaint(Color.BLACK);
            newProp.setSeriesOutlinePaint(Color.BLACK);
            newProp.setSelectedColumn(prop.getSelectedColumn());
            newProp.setLegendName(prop.getLegendName());
            newProp.setLinesVisible(prop.getLinesVisible());
            newProp.setShapesVisible(prop.getShapesVisible());
            newProp.setStroke(prop.getStrokeType());
            newProp.setShape(prop.getShapeType(), prop.getSizeType());
            newProp.setOutlineStroke(prop.getOutlineType());
            if (pos >= 0) {
                double d_start = prop.getDataSTART();
                double d_end = prop.getDataEND();
                newProp.setDataSTART(d_start);
                newProp.setDataEND(d_end);
            }
            PropertyPanel newPPanel = new PropertyPanel(this.thisJXY, newProp);
            this.propVector.add(pos, newProp);
            this.panelVector.add(pos, newPPanel);
            this.graphCount = this.propVector.size();
            this.initGroupUI();
            this.handleRenderer();
            for (int k = 0; k < this.graphCount; ++k) {
                newProp = this.propVector.get(k);
                newProp.setIndex(k);
                newPPanel = this.panelVector.get(k);
                if (newProp.isXSeries()) {
                    this.x_series_index = k;
                }
                this.addPropGroup(newPPanel);
            }
            this.xChanged(this.propVector.get(this.x_series_index));
            this.setMaxDataIntervals(this.propVector.get(this.x_series_index));
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void removeGraph(GraphProperties prop) {
        int i = this.propVector.indexOf(prop);
        if (this.graphCount > 1) {
            this.propVector.remove(i);
            this.panelVector.remove(i);
            this.graphCount = this.propVector.size();
            this.handleRenderer();
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                GraphProperties newProp = this.propVector.get(k);
                PropertyPanel newPPanel = this.panelVector.get(k);
                if (newProp.isXSeries()) {
                    this.x_series_index = k;
                }
                this.addPropGroup(newPPanel);
            }
            this.xChanged(this.propVector.get(this.x_series_index));
            this.setMaxDataIntervals(this.propVector.get(this.x_series_index));
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void upGraph(GraphProperties prop) {
        int i = this.propVector.indexOf(prop);
        PropertyPanel ppanel = this.panelVector.get(i);
        boolean xChanged = false;
        if (i - 1 >= 0 && i - 1 < this.graphCount) {
            this.propVector.remove(prop);
            this.panelVector.remove(i);
            this.propVector.add(i - 1, prop);
            this.panelVector.add(i - 1, ppanel);
            this.handleRenderer();
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                GraphProperties newProp = this.propVector.get(k);
                PropertyPanel newPPanel = this.panelVector.get(k);
                if (newProp.isXSeries()) {
                    this.x_series_index = k;
                    xChanged = true;
                }
                this.addPropGroup(newPPanel);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void downGraph(GraphProperties prop) {
        int i = this.propVector.indexOf(prop);
        PropertyPanel ppanel = this.panelVector.get(i);
        boolean xChanged = false;
        if (i < this.propVector.size() && i + 1 >= 0 && i + 1 < this.graphCount) {
            this.propVector.remove(prop);
            this.panelVector.remove(i);
            this.propVector.add(i + 1, prop);
            this.panelVector.add(i + 1, ppanel);
            this.graphCount = this.propVector.size();
            this.handleRenderer();
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                GraphProperties newProp = this.propVector.get(k);
                PropertyPanel newPPanel = this.panelVector.get(k);
                if (prop.isXSeries()) {
                    this.x_series_index = k;
                    xChanged = true;
                }
                this.addPropGroup(newPPanel);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    private void updatePropVector() {
        for (int i = 0; i < this.propVector.size(); ++i) {
            this.propVector.get(i).applyXYProperties();
        }
    }

    public int getRendererLeft() {
        return this.rLeftBox.getSelectedIndex();
    }

    public int getRendererRight() {
        return this.rRightBox.getSelectedIndex();
    }

    public void xChanged(GraphProperties prop) {
        int index;
        this.x_series_index = index = this.propVector.indexOf(prop);
        this.dStartChanged(true);
        this.dEndChanged(true);
        for (int i = 0; i < this.propVector.size(); ++i) {
            prop.setXChanged(true);
            prop.setIsXSeries(true);
            prop.setXSeries(prop.getSelectedColumn());
            if (i != index) {
                this.propVector.get(i).setXSeries(this.propVector.get(this.x_series_index).getSelectedColumn());
                this.propVector.get(i).setXChanged(true);
                this.propVector.get(i).setIsXSeries(false);
            } else {
                prop.setPosition(0);
            }
            if (this.panelVector.size() <= 0) continue;
            this.setXGUI(this.propVector.get(i), this.panelVector.get(i));
        }
    }

    public void setXGUI(GraphProperties prop, PropertyPanel panel) {
        if (prop.isXSeries()) {
            panel.isXAxis.setSelected(true);
            panel.setDataSTART(prop.getDataSTART());
            panel.setDataEND(prop.getDataEND());
            panel.customizeButton.setEnabled(false);
            panel.poschoice.setEnabled(false);
            panel.datachoice_START.setEnabled(true);
            panel.datachoice_END.setEnabled(true);
            panel.datachoice_max.setEnabled(true);
            panel.remButton.setEnabled(false);
            panel.poschoice.setSelectedItem(prop.getPosition());
        } else {
            panel.isXAxis.setSelected(false);
            panel.customizeButton.setEnabled(true);
            panel.poschoice.setEnabled(true);
            panel.datachoice_START.setEnabled(false);
            panel.datachoice_END.setEnabled(false);
            panel.datachoice_max.setEnabled(false);
            panel.remButton.setEnabled(true);
        }
    }

    public void plotAllGraphs() {
        this.updatePropVector();
        int l = 0;
        int r = 0;
        int x_pos = 0;
        boolean x_passed = false;
        int index_l = 0;
        int index_r = 0;
        int rLeft = this.rLeftBox.getSelectedIndex();
        int rRight = this.rRightBox.getSelectedIndex();
        XYLineAndShapeRenderer rendererLeft = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer rendererRight = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer lsr_R = new XYLineAndShapeRenderer();
        XYBarRenderer brr_R = new XYBarRenderer();
        XYDifferenceRenderer dfr_R = new XYDifferenceRenderer();
        XYAreaRenderer ar_R = new XYAreaRenderer();
        XYStepRenderer str_R = new XYStepRenderer();
        XYStepAreaRenderer sar_R = new XYStepAreaRenderer();
        XYLineAndShapeRenderer lsr_L = new XYLineAndShapeRenderer();
        XYBarRenderer brr_L = new XYBarRenderer();
        XYDifferenceRenderer dfr_L = new XYDifferenceRenderer();
        XYAreaRenderer ar_L = new XYAreaRenderer();
        XYStepRenderer str_L = new XYStepRenderer();
        XYStepAreaRenderer sar_L = new XYStepAreaRenderer();
        block16: for (int i = 0; i < this.propVector.size(); ++i) {
            GraphProperties prop = this.propVector.get(i);
            if (!x_passed) {
                ++x_pos;
            }
            if (prop.getPosition() == 0) {
                if (!this.propVector.get(i).isXSeries()) {
                    ++l;
                    index_l = i < x_pos ? i - r : i - r - 1;
                    switch (rLeft) {
                        case 0: {
                            lsr_L.setSeriesPaint(index_l, (Paint)prop.getSeriesPaint());
                            lsr_L.setSeriesStroke(index_l, prop.getSeriesStroke());
                            lsr_L.setSeriesShape(index_l, prop.getSeriesShape());
                            lsr_L.setSeriesShapesVisible(index_l, prop.getShapesVisible());
                            lsr_L.setSeriesLinesVisible(index_l, prop.getLinesVisible());
                            lsr_L.setDrawOutlines(prop.getOutlineVisible());
                            lsr_L.setUseOutlinePaint(true);
                            lsr_L.setSeriesFillPaint(index_l, (Paint)prop.getSeriesFillPaint());
                            lsr_L.setUseFillPaint(true);
                            lsr_L.setSeriesOutlineStroke(index_l, prop.getSeriesOutlineStroke());
                            lsr_L.setSeriesOutlinePaint(index_l, (Paint)prop.getSeriesOutlinePaint());
                            rendererLeft = lsr_L;
                            break;
                        }
                        case 1: {
                            brr_L.setSeriesPaint(index_l, (Paint)prop.getSeriesPaint());
                            brr_L.setSeriesStroke(index_l, prop.getSeriesStroke());
                            brr_L.setSeriesOutlineStroke(index_l, prop.getSeriesOutlineStroke());
                            brr_L.setSeriesOutlinePaint(index_l, (Paint)prop.getSeriesOutlinePaint());
                            rendererLeft = brr_L;
                            break;
                        }
                        case 2: {
                            ar_L.setSeriesPaint(index_l, (Paint)prop.getSeriesPaint());
                            ar_L.setSeriesStroke(index_l, prop.getSeriesStroke());
                            ar_L.setSeriesShape(index_l, prop.getSeriesShape());
                            ar_L.setSeriesOutlineStroke(index_l, prop.getSeriesOutlineStroke());
                            ar_L.setSeriesOutlinePaint(index_l, (Paint)prop.getSeriesOutlinePaint());
                            ar_L.setOutline(prop.getOutlineVisible());
                            rendererLeft = ar_L;
                            break;
                        }
                        case 3: {
                            str_L.setSeriesPaint(index_l, (Paint)prop.getSeriesPaint());
                            str_L.setSeriesStroke(index_l, prop.getSeriesStroke());
                            str_L.setSeriesShape(index_l, prop.getSeriesShape());
                            rendererLeft = str_L;
                            break;
                        }
                        case 4: {
                            sar_L.setSeriesPaint(index_l, (Paint)prop.getSeriesPaint());
                            sar_L.setSeriesStroke(index_l, prop.getSeriesStroke());
                            sar_L.setSeriesShape(index_l, prop.getSeriesShape());
                            sar_L.setSeriesOutlineStroke(index_l, prop.getSeriesOutlineStroke());
                            sar_L.setSeriesOutlinePaint(index_l, (Paint)prop.getSeriesOutlinePaint());
                            sar_L.setOutline(prop.getOutlineVisible());
                            rendererLeft = sar_L;
                            break;
                        }
                        case 5: {
                            dfr_L.setSeriesPaint(index_l, (Paint)prop.getSeriesPaint());
                            dfr_L.setSeriesStroke(index_l, prop.getSeriesStroke());
                            dfr_L.setSeriesShape(index_l, prop.getSeriesShape());
                            dfr_L.setSeriesOutlineStroke(index_l, prop.getSeriesOutlineStroke());
                            dfr_L.setSeriesOutlinePaint(index_l, (Paint)prop.getSeriesOutlinePaint());
                            dfr_L.setShapesVisible(prop.getShapesVisible());
                            rendererLeft = dfr_L;
                            break;
                        }
                        default: {
                            lsr_L.setSeriesPaint(index_l, (Paint)prop.getSeriesPaint());
                            lsr_L.setSeriesStroke(index_l, prop.getSeriesStroke());
                            lsr_L.setSeriesShape(index_l, prop.getSeriesShape());
                            lsr_L.setSeriesShapesVisible(index_l, prop.getShapesVisible());
                            lsr_L.setSeriesLinesVisible(index_l, prop.getLinesVisible());
                            lsr_L.setSeriesOutlineStroke(index_l, prop.getSeriesOutlineStroke());
                            lsr_L.setSeriesOutlinePaint(index_l, (Paint)prop.getSeriesOutlinePaint());
                            rendererLeft = lsr_L;
                            break;
                        }
                    }
                } else {
                    x_passed = true;
                }
            }
            if (prop.getPosition() != 1 || this.propVector.get(i).isXSeries()) continue;
            ++r;
            index_r = i < x_pos ? i - l : i - l - 1;
            switch (rRight) {
                case 0: {
                    lsr_R.setSeriesPaint(index_r, (Paint)prop.getSeriesPaint());
                    lsr_R.setSeriesStroke(index_r, prop.getSeriesStroke());
                    lsr_R.setSeriesShape(index_r, prop.getSeriesShape());
                    lsr_R.setSeriesShapesVisible(index_r, prop.getShapesVisible());
                    lsr_R.setSeriesLinesVisible(index_r, prop.getLinesVisible());
                    lsr_R.setDrawOutlines(prop.getOutlineVisible());
                    lsr_R.setUseOutlinePaint(true);
                    lsr_R.setSeriesFillPaint(index_r, (Paint)prop.getSeriesFillPaint());
                    lsr_R.setUseFillPaint(true);
                    lsr_R.setSeriesOutlineStroke(index_r, prop.getSeriesOutlineStroke());
                    lsr_R.setSeriesOutlinePaint(index_r, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = lsr_R;
                    continue block16;
                }
                case 1: {
                    brr_R.setSeriesPaint(index_r, (Paint)prop.getSeriesPaint());
                    brr_R.setSeriesStroke(index_r, prop.getSeriesStroke());
                    brr_R.setSeriesOutlineStroke(index_r, prop.getSeriesOutlineStroke());
                    brr_R.setSeriesOutlinePaint(index_r, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = brr_R;
                    continue block16;
                }
                case 2: {
                    ar_R.setSeriesPaint(index_r, (Paint)prop.getSeriesPaint());
                    ar_R.setSeriesStroke(index_r, prop.getSeriesStroke());
                    ar_R.setSeriesShape(index_r, prop.getSeriesShape());
                    ar_R.setSeriesOutlineStroke(index_r, prop.getSeriesOutlineStroke());
                    ar_R.setSeriesOutlinePaint(index_r, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = ar_R;
                    continue block16;
                }
                case 3: {
                    str_R.setSeriesPaint(index_r, (Paint)prop.getSeriesPaint());
                    str_R.setSeriesStroke(index_r, prop.getSeriesStroke());
                    str_R.setSeriesShape(index_r, prop.getSeriesShape());
                    str_R.setSeriesOutlineStroke(index_r, prop.getSeriesOutlineStroke());
                    str_R.setSeriesOutlinePaint(index_r, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = str_R;
                    continue block16;
                }
                case 4: {
                    sar_R.setSeriesPaint(index_r, (Paint)prop.getSeriesPaint());
                    sar_R.setSeriesStroke(index_r, prop.getSeriesStroke());
                    sar_R.setSeriesShape(index_r, prop.getSeriesShape());
                    sar_R.setSeriesOutlineStroke(index_r, prop.getSeriesOutlineStroke());
                    sar_R.setSeriesOutlinePaint(index_r, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = sar_R;
                    continue block16;
                }
                case 5: {
                    dfr_R.setSeriesPaint(index_r, (Paint)prop.getSeriesPaint());
                    dfr_R.setSeriesStroke(index_r, prop.getSeriesStroke());
                    dfr_R.setSeriesShape(index_r, prop.getSeriesShape());
                    dfr_R.setSeriesOutlineStroke(index_r, prop.getSeriesOutlineStroke());
                    dfr_R.setSeriesOutlinePaint(index_r, (Paint)prop.getSeriesOutlinePaint());
                    dfr_R.setShapesVisible(prop.getShapesVisible());
                    rendererRight = dfr_R;
                    continue block16;
                }
                default: {
                    lsr_R.setSeriesPaint(index_r, (Paint)prop.getSeriesPaint());
                    lsr_R.setSeriesStroke(index_r, prop.getSeriesStroke());
                    lsr_R.setSeriesShape(index_r, prop.getSeriesShape());
                    lsr_R.setSeriesShapesVisible(index_r, prop.getShapesVisible());
                    lsr_R.setSeriesLinesVisible(index_r, prop.getLinesVisible());
                    lsr_R.setSeriesOutlineStroke(index_r, prop.getSeriesOutlineStroke());
                    lsr_R.setSeriesOutlinePaint(index_r, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = lsr_R;
                }
            }
        }
        this.jxys.setPropVector(this.propVector);
        if (l > 0) {
            this.jxys.plotLeft((XYItemRenderer)rendererLeft, this.edLeftField.getText(), this.edXAxisField.getText(), this.invLeftBox.isSelected());
        }
        if (r > 0) {
            this.jxys.plotRight((XYItemRenderer)rendererRight, this.edRightField.getText(), this.edXAxisField.getText(), this.invRightBox.isSelected());
        }
        if (r == 0 && l == 0) {
            this.jxys.plotEmpty();
        }
        this.jxys.setTitle(this.edTitleField.getText());
        this.repaint();
    }

    public void handleRenderer() {
        int r = 0;
        int l = 0;
        int c = 0;
        for (int i = 0; i < this.propVector.size(); ++i) {
            if (this.propVector.get(i).getPosition() == 0) {
                if (!this.propVector.get(i).isXSeries()) {
                    ++l;
                } else {
                    ++c;
                }
            }
            if (this.propVector.get(i).getPosition() != 1) continue;
            if (!this.propVector.get(i).isXSeries()) {
                ++r;
                continue;
            }
            ++c;
        }
        if ((l < 2 || l > 2) && this.rLeftBox.getItemCount() == 6) {
            this.rLeftBox.removeItemAt(5);
        }
        if ((r < 2 || r > 2) && this.rRightBox.getItemCount() == 6) {
            this.rRightBox.removeItemAt(5);
        }
        if (l == 2 && this.rLeftBox.getItemCount() == 5) {
            this.rLeftBox.addItem("Difference");
        }
        if (r == 2 && this.rRightBox.getItemCount() == 5) {
            this.rRightBox.addItem("Difference");
        }
    }

    private void createOptionPanel() {
        GroupLayout optLayout = new GroupLayout(this.optionpanel);
        this.optionpanel.setLayout(optLayout);
        optLayout.setAutoCreateGaps(true);
        optLayout.setAutoCreateContainerGaps(true);
        this.addButton.addActionListener(this.addbuttonclick);
        GroupLayout.SequentialGroup optHGroup = optLayout.createSequentialGroup();
        GroupLayout.SequentialGroup optVGroup = optLayout.createSequentialGroup();
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitle).addComponent(this.edTitleField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edLeft).addComponent(this.edLeftField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edRight).addComponent(this.edRightField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edXAxis).addComponent(this.edXAxisField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.rLeftLabel).addComponent(this.rLeftBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.rRightLabel).addComponent(this.rRightBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.invLeftBox).addComponent(this.addButton));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.invRightBox).addComponent(this.applyButton));
        optHGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitle).addComponent(this.edLeft).addComponent(this.edRight).addComponent(this.edXAxis).addComponent(this.rLeftLabel).addComponent(this.rRightLabel).addComponent(this.invLeftBox).addComponent(this.invRightBox));
        optHGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitleField).addComponent(this.edLeftField).addComponent(this.edRightField).addComponent(this.edXAxisField).addComponent(this.rLeftBox).addComponent(this.rRightBox).addComponent(this.addButton).addGap(1, 1, 1).addComponent(this.applyButton));
        optLayout.setHorizontalGroup(optHGroup);
        optLayout.setVerticalGroup(optVGroup);
    }

    private void initGroupUI() {
        this.graphpanel.removeAll();
        JLabel typeLabel = new JLabel("Position");
        JLabel dataLabel = new JLabel("Data / Legend Entry");
        JLabel timeLabel = new JLabel("Data Range");
        this.gLayout = new GroupLayout(this.graphpanel);
        this.graphpanel.setLayout(this.gLayout);
        this.gLayout.setAutoCreateGaps(true);
        this.gLayout.setAutoCreateContainerGaps(true);
        this.hGroup = this.gLayout.createSequentialGroup();
        this.vGroup = this.gLayout.createSequentialGroup();
        this.group1 = this.gLayout.createParallelGroup();
        this.group2 = this.gLayout.createParallelGroup();
        this.group3 = this.gLayout.createParallelGroup();
        this.group4 = this.gLayout.createParallelGroup();
        this.group5 = this.gLayout.createParallelGroup();
        this.group6 = this.gLayout.createParallelGroup();
        this.group7 = this.gLayout.createParallelGroup();
        this.group8 = this.gLayout.createParallelGroup();
        this.group9 = this.gLayout.createParallelGroup();
        this.group10 = this.gLayout.createParallelGroup();
        this.group11 = this.gLayout.createParallelGroup();
        this.group12 = this.gLayout.createParallelGroup();
        this.group13 = this.gLayout.createParallelGroup();
        this.group14 = this.gLayout.createParallelGroup();
        this.group15 = this.gLayout.createParallelGroup();
        this.group1.addComponent(dataLabel);
        this.group2.addComponent(timeLabel);
        this.group3.addComponent(typeLabel);
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(dataLabel).addComponent(timeLabel).addComponent(typeLabel));
    }

    private void addPropGroup(PropertyPanel ppanel) {
        this.isXAxisGroup.add(ppanel.getIsXAxisButton());
        JLabel space3 = new JLabel(" ");
        JLabel space4 = new JLabel(" ");
        JLabel space5 = new JLabel("   ");
        JLabel lf = ppanel.getLegendLabel();
        this.group6.addComponent(space5);
        this.group1.addComponent(ppanel.getDataChoice()).addComponent(lf).addGap(20);
        this.group2.addComponent(ppanel.getDataChoiceSTART()).addComponent(ppanel.getDataChoiceEND());
        this.group3.addComponent(ppanel.getMaxButton()).addComponent(ppanel.getPosChoice());
        this.group4.addComponent(ppanel.getCustomizeButton()).addComponent(space5);
        this.group9.addComponent(space3);
        this.group10.addComponent(ppanel.getIsXAxisButton());
        this.group11.addComponent(space4);
        this.group13.addComponent(ppanel.getColorLabel()).addComponent(ppanel.getRemButton());
        this.group14.addComponent(ppanel.getUpButton());
        this.group15.addComponent(ppanel.getDownButton());
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(ppanel.getDataChoice()).addComponent(ppanel.getDataChoiceSTART()).addComponent(space5).addComponent(ppanel.getMaxButton()).addComponent(space5).addComponent(ppanel.getCustomizeButton()).addComponent(ppanel.getIsXAxisButton()).addComponent(ppanel.getColorLabel()));
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lf).addComponent(ppanel.getDataChoiceEND()).addComponent(space5).addComponent(ppanel.getPosChoice()).addComponent(space3).addComponent(space4).addComponent(ppanel.getRemButton()).addComponent(ppanel.getUpButton()).addComponent(ppanel.getDownButton()));
        this.vGroup.addGroup(this.gLayout.createParallelGroup().addGap(20));
    }

    private void finishGroupUI() {
        this.hGroup.addGroup(this.group1);
        this.hGroup.addGroup(this.group2);
        this.hGroup.addGroup(this.group6);
        this.hGroup.addGroup(this.group3);
        this.hGroup.addGroup(this.group4);
        this.hGroup.addGroup(this.group9);
        this.hGroup.addGroup(this.group10);
        this.hGroup.addGroup(this.group11);
        this.hGroup.addGroup(this.group12);
        this.hGroup.addGroup(this.group13);
        this.hGroup.addGroup(this.group14);
        this.hGroup.addGroup(this.group15);
        this.gLayout.setHorizontalGroup(this.hGroup);
        this.gLayout.setVerticalGroup(this.vGroup);
    }

    public JPanel getPanel() {
        return this.mainpanel;
    }

    public JPanel getCTSPlot() {
        return this.ctsplot.getPanel();
    }

    public void setParent(JFrame parent) {
        this.parent = parent;
    }

    private String saveTemplate() {
        Properties properties = new Properties();
        int no_of_props = this.propVector.size();
        String store = "";
        try {
            store = this.sheet.getID();
        }
        catch (NullPointerException npe) {
            store = "DEFAULT";
        }
        String names = "";
        String number = "" + no_of_props;
        String output = this.sheet.isOutputSheet() ? "true" : "false";
        properties.setProperty("output", output);
        properties.setProperty("template_type", "DATA");
        properties.setProperty("number", number);
        properties.setProperty("title", this.edTitleField.getText());
        properties.setProperty("axisLTitle", this.edLeftField.getText());
        properties.setProperty("axisRTitle", this.edRightField.getText());
        properties.setProperty("xAxisTitle", this.edXAxisField.getText());
        properties.setProperty("renderer_left", "" + this.rLeftBox.getSelectedIndex());
        properties.setProperty("renderer_right", "" + this.rRightBox.getSelectedIndex());
        properties.setProperty("inv_left", "" + this.invLeftBox.isSelected());
        properties.setProperty("inv_right", "" + this.invRightBox.isSelected());
        properties.setProperty("x_series_index", "" + this.x_series_index);
        for (int i = 0; i < no_of_props; ++i) {
            GraphProperties gprop = this.propVector.get(i);
            String name = gprop.getName();
            names = i == 0 ? name : names + "," + name;
            if (gprop.isXSeries()) {
                properties.setProperty("dataSTART", "" + this.row_start);
                properties.setProperty("dataEND", "" + this.row_end);
            }
            properties.setProperty(name + ".timeSTART", "DEFAULT");
            properties.setProperty(name + ".timeEND", "DEFAULT");
            properties.setProperty(name + ".legendname", gprop.getLegendName());
            properties.setProperty(name + ".position", "" + gprop.getPosition());
            String stroke_type = "" + gprop.getStrokeType();
            properties.setProperty(name + ".linestroke", stroke_type);
            Color linecolor_load = gprop.getSeriesPaint();
            String stroke_color = "" + linecolor_load.getRed() + "," + linecolor_load.getGreen() + "," + linecolor_load.getBlue();
            properties.setProperty(name + ".linecolor", stroke_color);
            String lines_vis = "" + gprop.getLinesVisible();
            properties.setProperty(name + ".linesvisible", lines_vis);
            String shapes_vis = "" + gprop.getShapesVisible();
            properties.setProperty(name + ".shapesvisible", shapes_vis);
            String shape_type = "" + gprop.getShapeType();
            properties.setProperty(name + ".shapetype", shape_type);
            String size_type = "" + gprop.getSizeType();
            properties.setProperty(name + ".shapesize", size_type);
            Color fillcolor_load = gprop.getSeriesFillPaint();
            String shape_color = "" + fillcolor_load.getRed() + "," + fillcolor_load.getGreen() + "," + fillcolor_load.getBlue();
            properties.setProperty(name + ".shapecolor", shape_color);
            String outline_type = "" + gprop.getOutlineType();
            properties.setProperty(name + ".outlinestroke", outline_type);
            Color outcolor_load = gprop.getSeriesOutlinePaint();
            String outline_color = "" + outcolor_load.getRed() + "," + outcolor_load.getGreen() + "," + outcolor_load.getBlue();
            properties.setProperty(name + ".outlinecolor", outline_color);
        }
        properties.setProperty("names", names);
        String filename = "";
        String inputString = "";
        StringTokenizer name_tokenizer = new StringTokenizer(store, ".");
        String storename = "";
        storename = name_tokenizer.hasMoreTokens() ? name_tokenizer.nextToken() : store;
        try {
            boolean dont_save = true;
            while (dont_save) {
                inputString = GUIHelper.showInputDlg((Component)this, (String)SpreadsheetConstants.INFO_MSG_SAVETEMP, (String)storename);
                if (inputString != null) {
                    FileOutputStream fout;
                    int result;
                    String fileexists;
                    FileOutputStream fout2;
                    File file;
                    inputString = inputString + ".ttp";
                    if (this.sheet.isOutputSheet()) {
                        file = new File(this.sheet.getOutputDSDir(), inputString);
                        if (!file.exists()) {
                            filename = file.getName();
                            fout2 = new FileOutputStream(file);
                            properties.store(fout2, "");
                            fout2.close();
                            dont_save = false;
                            continue;
                        }
                        fileexists = "The File " + file + " already exists.\n Overwrite?";
                        result = GUIHelper.showYesNoDlg((Component)this, (String)fileexists, (String)"File already exists");
                        if (result != 0) continue;
                        filename = file.getName();
                        fout = new FileOutputStream(file);
                        properties.store(fout, "");
                        fout.close();
                        dont_save = false;
                        continue;
                    }
                    file = new File(this.workspace.getDirectory().toString() + "/explorer", inputString);
                    if (!file.exists()) {
                        filename = file.getName();
                        fout2 = new FileOutputStream(file);
                        properties.store(fout2, "");
                        fout2.close();
                        dont_save = false;
                        continue;
                    }
                    fileexists = "The File " + file + " already exists.\n Overwrite?";
                    result = GUIHelper.showYesNoDlg((Component)this, (String)fileexists, (String)"File already exists");
                    if (result != 0) continue;
                    filename = file.getName();
                    fout = new FileOutputStream(file);
                    properties.store(fout, "");
                    fout.close();
                    dont_save = false;
                    continue;
                }
                dont_save = false;
            }
        }
        catch (Exception fnfex) {
            Logger.getLogger(JXYConfigurator.class.getName()).log(Level.SEVERE, null, fnfex);
        }
        return filename;
    }

    private void loadTemplate(File templateFile) {
        int c;
        int no_of_props;
        Properties properties = new Properties();
        boolean load_prop = false;
        int returnVal = -1;
        double data_start = 0.0;
        double data_end = 0.0;
        try {
            FileInputStream fin = new FileInputStream(templateFile);
            properties.load(fin);
            fin.close();
        }
        catch (Exception fnfexc) {
            returnVal = -1;
        }
        this.propVector = new Vector();
        String names = properties.getProperty("names");
        this.graphCount = no_of_props = new Integer(properties.getProperty("number")).intValue();
        StringTokenizer nameTokenizer = new StringTokenizer(names, ",");
        this.initGroupUI();
        String x_series_index_string = properties.getProperty("x_series_index");
        this.x_series_index = x_series_index_string.compareTo("DEFAULT") != 0 ? new Integer(x_series_index_string) : (this.sheet.timeRuns() ? 1 : 0);
        for (int i = 0; i < no_of_props; ++i) {
            load_prop = false;
            GraphProperties gprop = new GraphProperties(this);
            if (i == this.x_series_index) {
                gprop.setIsXSeries(true);
                String data_start_string = properties.getProperty("dataSTART");
                if (data_start_string.compareTo("DEFAULT") != 0) {
                    data_start = new Double(properties.getProperty("dataSTART"));
                    this.dStartChanged(true);
                    data_end = new Double(properties.getProperty("dataEND"));
                    this.dEndChanged(true);
                } else {
                    this.setPossibleDataIntervals();
                }
            } else {
                gprop.setIsXSeries(false);
            }
            gprop.setXSeries(this.x_series_index);
            if (!nameTokenizer.hasMoreTokens()) continue;
            String name = nameTokenizer.nextToken();
            for (int k = 0; k < this.table.getColumnCount(); ++k) {
                if (this.table.getColumnName(k).compareTo(name) != 0) continue;
                gprop.setSelectedColumn(k);
                load_prop = true;
                break;
            }
            if (load_prop) {
                gprop.setLegendName(properties.getProperty(name + ".legendname", "legend name"));
                int pos = new Integer(properties.getProperty(name + ".position"));
                gprop.setPosition(pos);
                gprop.setName(name);
                gprop.setStroke(new Integer(properties.getProperty(name + ".linestroke", "2")));
                String stroke_color = properties.getProperty(name + ".linecolor", "255,0,0");
                StringTokenizer colorTokenizer = new StringTokenizer(stroke_color, ",");
                gprop.setSeriesPaint(new Color(new Integer(colorTokenizer.nextToken()), new Integer(colorTokenizer.nextToken()), new Integer(colorTokenizer.nextToken())));
                boolean lv = new Boolean(properties.getProperty(name + ".linesvisible"));
                gprop.setLinesVisible(lv);
                boolean sv = new Boolean(properties.getProperty(name + ".shapesvisible"));
                gprop.setShapesVisible(sv);
                int stype = new Integer(properties.getProperty(name + ".shapetype", "0"));
                int ssize = new Integer(properties.getProperty(name + ".shapesize"));
                gprop.setShape(stype, ssize);
                String shape_color = properties.getProperty(name + ".shapecolor", "255,0,0");
                StringTokenizer shapeTokenizer = new StringTokenizer(shape_color, ",");
                gprop.setSeriesFillPaint(new Color(new Integer(shapeTokenizer.nextToken()), new Integer(shapeTokenizer.nextToken()), new Integer(shapeTokenizer.nextToken())));
                int os = new Integer(properties.getProperty(name + ".outlinestroke"));
                gprop.setOutlineStroke(os);
                String outline_color = properties.getProperty(name + ".outlinecolor", "255,0,0");
                StringTokenizer outTokenizer = new StringTokenizer(outline_color, ",");
                gprop.setSeriesOutlinePaint(new Color(new Integer(outTokenizer.nextToken()), new Integer(outTokenizer.nextToken()), new Integer(outTokenizer.nextToken())));
                this.propVector.add(gprop);
            }
            this.edTitleField.setText(properties.getProperty("title"));
            this.edLeftField.setText(properties.getProperty("axisLTitle"));
            this.edRightField.setText(properties.getProperty("axisRTitle"));
            this.edXAxisField.setText(properties.getProperty("xAxisTitle"));
            this.rLeftBox.setSelectedIndex(new Integer(properties.getProperty("renderer_left")));
            this.rRightBox.setSelectedIndex(new Integer(properties.getProperty("renderer_right")));
            this.invLeftBox.setSelected(new Boolean(properties.getProperty("inv_left")));
            this.invRightBox.setSelected(new Boolean(properties.getProperty("inv_right")));
        }
        this.xChanged(this.propVector.get(this.x_series_index));
        for (c = 0; c < no_of_props; ++c) {
            if (c != this.x_series_index) continue;
            this.resortData(this.propVector.get(c).getSelectedColumn());
            this.propVector.get(c).setDataSTART(data_start);
            this.propVector.get(c).setDataEND(data_end);
        }
        this.range = this.setPossibleDataIntervals();
        for (c = 0; c < this.propVector.size(); ++c) {
            this.propVector.get(c).setXIntervals(this.range);
            this.propVector.get(c).applyXYProperties();
            PropertyPanel ppanel = new PropertyPanel(this.thisJXY, this.propVector.get(c));
            this.panelVector.add(ppanel);
            if (this.panelVector.size() > 0) {
                this.setXGUI(this.propVector.get(c), ppanel);
            }
            this.addPropGroup(ppanel);
        }
        this.finishGroupUI();
        this.jxys.setPropVector(this.propVector);
    }

    private void editProperties() {
        JDialog propDlg = new JDialog((Frame)this.parent, "Properties");
        int ct = this.headers.length;
        JLabel[] labels = new JLabel[ct];
        JTextField[] textFields = new JTextField[ct];
        JPanel[] inputpanels = new JPanel[ct];
        JPanel proppanel = new JPanel();
        proppanel.setLayout(new GridLayout(ct, 1));
        for (int i = 0; i < ct; ++i) {
            labels[i] = new JLabel(this.headers[i]);
            textFields[i] = new JTextField(this.headers[i]);
            inputpanels[i] = new JPanel();
            inputpanels[i].setLayout(new FlowLayout());
            inputpanels[i].add(labels[i]);
            inputpanels[i].add(textFields[i]);
        }
        JScrollPane propPane = new JScrollPane(proppanel);
    }

    public void createActionListener() {
        Vector addAction = new Vector();
        for (int k = 0; k < this.graphCount; ++k) {
            this.activationChange[k] = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
        }
    }

    private class AddGraphDlg
    extends JDialog {
        boolean result;
        int max;
        String side;
        int side_index;
        int position;
        JSpinner posSpinner;
        JComboBox sideChoice;
        JButton okButton;
        JLabel pos_label;
        JLabel side_label;
        ActionListener ok;

        public AddGraphDlg() {
            super(JXYConfigurator.this.thisDlg, "Add Graph", true);
            this.result = false;
            this.ok = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddGraphDlg.this.side_index = AddGraphDlg.this.sideChoice.getSelectedIndex();
                    AddGraphDlg.this.position = (Integer)AddGraphDlg.this.posSpinner.getValue();
                    AddGraphDlg.this.result = true;
                    AddGraphDlg.this.setVisible(false);
                }
            };
            Point parentloc = JXYConfigurator.this.thisDlg.getLocation();
            this.setLocation(parentloc.x + 50, parentloc.y + 50);
            this.createPanel();
        }

        void createPanel() {
            this.setLayout(new FlowLayout());
            this.max = JXYConfigurator.this.propVector.size();
            String[] posArray = new String[]{"left", "right"};
            this.posSpinner = new JSpinner(new SpinnerNumberModel(this.max, 0, this.max, 1));
            this.sideChoice = new JComboBox<String>(posArray);
            this.sideChoice.setSelectedIndex(0);
            this.okButton = new JButton("OK");
            this.pos_label = new JLabel("position after: ");
            this.side_label = new JLabel("side: ");
            this.add(this.side_label);
            this.add(this.sideChoice);
            this.add(this.pos_label);
            this.add(this.posSpinner);
            this.add(this.okButton);
            this.okButton.addActionListener(this.ok);
            this.pack();
        }

        int getSide() {
            return this.side_index;
        }

        int getPosition() {
            return this.position;
        }

        boolean getResult() {
            return this.result;
        }
    }

    private class HiResPanel
    extends JPanel {
        BufferedImage bi;

        public HiResPanel(BufferedImage bi) {
            this.bi = bi;
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.bi, 0, 0, this);
        }
    }
}

