/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.gui;

import jams.JAMS;
import jams.explorer.DataCollectionViewController;
import jams.explorer.JAMSExplorer;
import jams.explorer.gui.DataCollectionView;
import jams.explorer.spreadsheet.STPConfigurator;
import jams.gui.PropertyDlg;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIHelper;
import jams.io.XMLProcessor;
import jams.server.client.gui.BrowseJAMSCloudDlg;
import jams.server.client.gui.SynchronizeDlg;
import jams.tools.JAMSTools;
import jams.tools.StringTools;
import jams.workspace.InvalidWorkspaceException;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.io.NetCDFFileReader;
import optas.io.NetCDFFileWriter;
import org.w3c.dom.Document;

public class ExplorerFrame
extends JFrame {
    protected static final int INOUT_PANE_WIDTH = 350;
    protected static final int INOUT_PANE_HEIGHT = 1000;
    protected static final int DIVIDER_WIDTH = 6;
    protected JFileChooser jfc = GUIHelper.getJFileChooser();
    protected WorkerDlg openWSDlg;
    protected Action openWSAction;
    protected Action openSTPAction;
    protected Action exitAction;
    protected Action editPrefsAction;
    protected Action sensitivityAnalysisAction;
    protected Action reloadWSAction;
    protected Action importDataAction;
    protected Action browseServerAction;
    protected Action closeCurrentPanelAction;
    protected JLabel statusLabel;
    protected JSplitPane mainSplitPane;
    protected JTabbedPane tPane;
    protected JAMSExplorer explorer;
    protected PropertyDlg propertyDlg;
    protected Document modelDoc = null;
    protected BrowseJAMSCloudDlg jamsCloudBrowser = null;
    private JMenuItem saveEnsembleItem;

    public ExplorerFrame(JAMSExplorer explorer) {
        this.explorer = explorer;
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.createListener();
        this.exitAction = new AbstractAction(JAMS.i18n((String)"CLOSE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.exit();
            }
        };
        this.openWSAction = new AbstractAction(JAMS.i18n((String)"OPEN_WORKSPACE...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.open();
            }
        };
        this.editPrefsAction = new AbstractAction(JAMS.i18n((String)"EDIT_PREFERENCES...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.propertyDlg.setProperties(ExplorerFrame.this.explorer.getProperties());
                ExplorerFrame.this.propertyDlg.setVisible(true);
                if (ExplorerFrame.this.propertyDlg.getResult() == 1) {
                    ExplorerFrame.this.propertyDlg.validateProperties();
                }
            }
        };
        this.browseServerAction = new AbstractAction(JAMS.i18n((String)"Start_Remote_Control")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.browseJAMSCloud();
            }
        };
        this.importDataAction = new AbstractAction(JAMS.i18n((String)"IMPORT_DATA")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.importData();
            }
        };
        this.openSTPAction = new AbstractAction(JAMS.i18n((String)"STACKED_TIME_PLOT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                STPConfigurator stp = new STPConfigurator(ExplorerFrame.this.explorer);
            }
        };
        this.reloadWSAction = new AbstractAction(JAMS.i18n((String)"RELOAD_WORKSPACE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.update();
            }
        };
        this.closeCurrentPanelAction = new AbstractAction(JAMS.i18n((String)"Close_Current_Panel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.explorer.getDisplayManager().removeDisplay(ExplorerFrame.this.tPane.getSelectedComponent());
            }
        };
        this.update();
        this.propertyDlg = new PropertyDlg((Frame)this, this.explorer.getProperties());
        this.openWSDlg = new WorkerDlg((Window)this, JAMS.i18n((String)"OPENING_WORKSPACE"));
        this.setIconImages(JAMSTools.getJAMSIcons());
        this.setTitle(JAMSExplorer.APP_TITLE);
        this.jfc.setFileSelectionMode(1);
        this.tPane = new JTabbedPane();
        this.mainSplitPane = new JSplitPane();
        JSplitPane inoutSplitPane = new JSplitPane();
        this.mainSplitPane.setAutoscrolls(true);
        this.mainSplitPane.setContinuousLayout(true);
        this.mainSplitPane.setLeftComponent(inoutSplitPane);
        this.mainSplitPane.setRightComponent(this.tPane);
        this.mainSplitPane.setDividerLocation(350);
        this.mainSplitPane.setDividerSize(6);
        this.mainSplitPane.setOneTouchExpandable(false);
        inoutSplitPane.setAutoscrolls(true);
        inoutSplitPane.setContinuousLayout(true);
        inoutSplitPane.setLeftComponent(this.explorer.getDisplayManager().getTreePanel());
        ScrollPane infoScroll = new ScrollPane();
        infoScroll.setMinimumSize(new Dimension(0, 0));
        infoScroll.add(this.explorer.getDisplayManager().getInputDSInfoPanel());
        inoutSplitPane.setRightComponent(infoScroll);
        inoutSplitPane.setOrientation(0);
        inoutSplitPane.setDividerLocation(1000);
        inoutSplitPane.setDividerSize(6);
        inoutSplitPane.setOneTouchExpandable(false);
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        JToolBar toolBar = new JToolBar();
        JButton wsOpenButton = new JButton(this.openWSAction);
        wsOpenButton.setText("");
        wsOpenButton.setToolTipText((String)this.openWSAction.getValue("Name"));
        wsOpenButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelOpen.png")));
        toolBar.add(wsOpenButton);
        JButton reloadWSButton = new JButton(this.reloadWSAction);
        reloadWSButton.setText("");
        reloadWSButton.setToolTipText((String)this.reloadWSAction.getValue("Name"));
        reloadWSButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Reload.png")));
        toolBar.add(reloadWSButton);
        JButton closeCurrentPanelButton = new JButton(this.closeCurrentPanelAction);
        closeCurrentPanelButton.setText("");
        closeCurrentPanelButton.setToolTipText((String)this.closeCurrentPanelAction.getValue("Name"));
        closeCurrentPanelButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/close.png")));
        toolBar.add(closeCurrentPanelButton);
        JButton stpButton = new JButton(this.openSTPAction);
        toolBar = this.processToolBarHook(toolBar);
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.setLayout(new FlowLayout(0, 0, 0));
        toolBarPanel.add(toolBar);
        this.getContentPane().add((Component)toolBarPanel, "North");
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        statusPanel.setBorder(BorderFactory.createEtchedBorder());
        statusPanel.setPreferredSize(new Dimension(14, 20));
        this.statusLabel = new JLabel();
        this.statusLabel.setText(JAMS.i18n((String)"DATA_EXPLORER"));
        statusPanel.add((Component)this.statusLabel, "Center");
        this.getContentPane().add((Component)statusPanel, "South");
        JMenuBar mainMenu = new JMenuBar();
        JMenu fileMenu = new JMenu(JAMS.i18n((String)"FILE"));
        mainMenu.add(fileMenu);
        if (this.explorer.isStandAlone()) {
            JMenu prefsMenu = new JMenu(JAMS.i18n((String)"PREFERENCES"));
            JMenuItem editPrefsItem = new JMenuItem(this.editPrefsAction);
            prefsMenu.add(editPrefsItem);
            mainMenu.add(prefsMenu);
        }
        JMenu plotMenu = new JMenu(JAMS.i18n((String)"PLOT"));
        mainMenu.add(plotMenu);
        JMenuItem openWSItem = new JMenuItem(this.openWSAction);
        openWSItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        fileMenu.add(openWSItem);
        fileMenu.addSeparator();
        JMenuItem importData = new JMenuItem(this.importDataAction);
        fileMenu.add(importData);
        JMenuItem exitItem = new JMenuItem(this.exitAction);
        exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        fileMenu.add(exitItem);
        JMenuItem stpItem = new JMenuItem(this.openSTPAction);
        plotMenu.add(stpItem);
        JMenu ensemblesMenu = new JMenu("Ensembles");
        JMenuItem newEnsembleItem = new JMenuItem(new AbstractAction(JAMS.i18n((String)"NEW_ENSEMBLE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataCollectionViewController controller = new DataCollectionViewController(new DataCollection());
                ExplorerFrame.this.tPane.addTab("New Ensemble", controller.getView());
            }
        });
        newEnsembleItem.setEnabled(true);
        ensemblesMenu.add(newEnsembleItem);
        this.saveEnsembleItem = new JMenuItem(new AbstractAction(JAMS.i18n((String)"SAVE_ENSEMBLE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog(ExplorerFrame.this.rootPane, (Object)JAMS.i18n((String)"PLEASE_ENTER_A_FILENAME"));
                Component pane = ExplorerFrame.this.getTPane().getSelectedComponent();
                if (!(pane instanceof DataCollectionView)) {
                    return;
                }
                DataCollectionView view = (DataCollectionView)pane;
                String path = ExplorerFrame.this.explorer.getWorkspace().getOutputDataDirectory().getAbsolutePath() + "/" + name;
                if (!ExplorerFrame.this.explorer.getWorkspace().getOutputDataDirectory().exists()) {
                    ExplorerFrame.this.explorer.getWorkspace().getOutputDataDirectory().mkdirs();
                }
                if (!path.endsWith(".cdat")) {
                    path = path.concat(".cdat");
                }
                view.getDataCollection().save(new File(path));
            }
        });
        this.saveEnsembleItem.setEnabled(true);
        ensemblesMenu.add(this.saveEnsembleItem);
        this.tPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component pane = ExplorerFrame.this.getTPane().getSelectedComponent();
                if (pane instanceof DataCollectionView) {
                    ExplorerFrame.this.saveEnsembleItem.setEnabled(true);
                } else {
                    ExplorerFrame.this.saveEnsembleItem.setEnabled(false);
                }
            }
        });
        mainMenu.add(ensemblesMenu);
        JMenu netCDFMenu = new JMenu("NetCDF");
        mainMenu.add(netCDFMenu);
        final JMenuItem saveToNetCDFItem = new JMenuItem(new AbstractAction("Save as NetCDF..."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent ae) {
                Component component = ExplorerFrame.this.getTPane().getSelectedComponent();
                DataCollection collection = ((DataCollectionView)component).getDataCollection();
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().endsWith(".cdf");
                    }

                    @Override
                    public String getDescription() {
                        return "NetCDF 3.0 Format";
                    }
                });
                int result = chooser.showSaveDialog(ExplorerFrame.this);
                if (result == 0) {
                    String name = chooser.getSelectedFile().getName();
                    String path = chooser.getSelectedFile().getAbsolutePath();
                    NetCDFFileWriter stream = null;
                    try {
                        stream = new NetCDFFileWriter(path);
                        stream.write(collection);
                    }
                    catch (IOException ex) {
                        System.out.println("Unable to write file: " + name + ".");
                    }
                    catch (DataSet.MismatchException ex) {
                        System.out.println(ex.getMessage());
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.flush();
                                stream.close();
                            }
                            catch (IOException ex) {
                                System.out.println("Unable to close file: " + name + ".");
                            }
                        }
                    }
                }
            }
        });
        saveToNetCDFItem.setEnabled(false);
        netCDFMenu.add(saveToNetCDFItem);
        JMenuItem readFromNetCDFItem = new JMenuItem(new AbstractAction("Read from NetCDF..."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().endsWith(".cdf");
                    }

                    @Override
                    public String getDescription() {
                        return "NetCDF 3.0 Format";
                    }
                });
                int result = chooser.showOpenDialog(ExplorerFrame.this);
                if (result == 0) {
                    String name = chooser.getSelectedFile().getName();
                    String path = chooser.getSelectedFile().getAbsolutePath();
                    DataCollection collection = null;
                    NetCDFFileReader stream = null;
                    try {
                        stream = new NetCDFFileReader(path);
                        collection = stream.read();
                        DataCollectionViewController controller = new DataCollectionViewController(collection);
                        ExplorerFrame.this.tPane.addTab("New Ensemble", controller.getView());
                        ExplorerFrame.this.tPane.setSelectedIndex(ExplorerFrame.this.tPane.getComponentCount() - 1);
                    }
                    catch (IOException ex) {
                        System.out.println("Unable to write file: " + name + ".");
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    catch (InstantiationException ex) {
                        ex.printStackTrace();
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                    catch (DataSet.MismatchException ex) {
                        System.out.println(ex.getMessage());
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException ex) {
                                System.out.println("Unable to close file: " + name + ".");
                            }
                        }
                    }
                }
            }
        });
        netCDFMenu.add(readFromNetCDFItem);
        this.tPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component pane = ExplorerFrame.this.getTPane().getSelectedComponent();
                if (pane instanceof DataCollectionView) {
                    saveToNetCDFItem.setEnabled(true);
                } else {
                    saveToNetCDFItem.setEnabled(false);
                }
            }
        });
        this.setJMenuBar(mainMenu);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(Math.min(d.width, 1200), Math.min(d.height, 1000));
    }

    protected JToolBar processToolBarHook(JToolBar toolBar) {
        return toolBar;
    }

    public void open(File workspaceFile) throws InvalidWorkspaceException {
        String[] libs = StringTools.toArray((String)this.explorer.getProperties().getProperty("libs", ""), (String)";");
        JAMSWorkspace workspace = new JAMSWorkspace(workspaceFile, this.explorer.getRuntime(), false);
        workspace.init();
        this.explorer.getDisplayManager().removeAllDisplays();
        this.explorer.setWorkspace(workspace);
        this.update();
    }

    protected void importData() {
        JAMSWorkspace ws = this.explorer.getWorkspace();
        try {
            ws.init();
        }
        catch (InvalidWorkspaceException iwe) {
            iwe.printStackTrace();
            return;
        }
        int id = ws.getID();
        if (id == -1) {
            return;
        }
        try {
            SynchronizeDlg synchronizer = new SynchronizeDlg((Window)this, (Workspace)ws, this.explorer.getProperties());
            synchronizer.setPreferredSize(new Dimension(640, 480));
            GUIHelper.centerOnParent((Window)synchronizer, (boolean)true);
            synchronizer.setVisible(true);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void browseJAMSCloud() {
        if (this.jamsCloudBrowser == null) {
            this.jamsCloudBrowser = new BrowseJAMSCloudDlg((Window)this, this.explorer.getProperties());
            this.jamsCloudBrowser.init();
            this.jamsCloudBrowser.setDefaultCloseOperation(2);
        }
        GUIHelper.centerOnScreen((Component)this.jamsCloudBrowser, (boolean)true);
        this.jamsCloudBrowser.setVisible(true);
    }

    protected void open() {
        int result = this.jfc.showOpenDialog(this);
        if (result == 0) {
            this.openWSDlg.setTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExplorerFrame.this.open(ExplorerFrame.this.jfc.getSelectedFile());
                    }
                    catch (InvalidWorkspaceException ex) {
                        ExplorerFrame.this.explorer.getRuntime().handle((Throwable)ex);
                    }
                }
            });
            this.openWSDlg.execute();
        }
    }

    public void reset() {
        this.explorer.setWorkspace(null);
        this.update();
    }

    public void update() {
        JAMSWorkspace workspace = this.explorer.getWorkspace();
        if (workspace == null) {
            this.reloadWSAction.setEnabled(false);
            this.importDataAction.setEnabled(false);
        } else {
            workspace.updateDataStores();
            this.jfc.setSelectedFile(workspace.getDirectory());
            this.setTitle(JAMSExplorer.APP_TITLE + " [" + workspace.getDirectory().toString() + "]");
            this.reloadWSAction.setEnabled(true);
            this.importDataAction.setEnabled(true);
            this.explorer.getDisplayManager().getTreePanel().update();
            this.mainSplitPane.setDividerLocation(350);
        }
    }

    protected void setWorkSpace2Model() {
        JAMSWorkspace workspace = this.explorer.getWorkspace();
        try {
            String directoryName = workspace.getDirectory().getCanonicalPath();
            XMLProcessor.setWorkspacePath((Document)this.modelDoc, (String)directoryName);
        }
        catch (Exception e) {
            this.explorer.getRuntime().handle((Throwable)e);
        }
    }

    protected void createListener() {
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ExplorerFrame.this.exit();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
    }

    public JTabbedPane getTPane() {
        return this.tPane;
    }

    protected void exit() {
        for (Window window : this.explorer.getChildWindows()) {
            window.dispose();
        }
        this.setVisible(false);
        this.dispose();
        this.explorer.exit();
    }
}

