/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer;

import jams.explorer.DataCollectionViewController;
import jams.explorer.JAMSExplorer;
import jams.explorer.gui.ExplorerFrame;
import jams.explorer.gui.ImportMonteCarloDataPanel;
import jams.explorer.gui.OutputDSPanel;
import jams.explorer.gui.SimpleOutputPanel;
import jams.explorer.spreadsheet.JAMSSpreadSheet;
import jams.explorer.tree.FileObject;
import jams.io.BufferedFileReader;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataStoreProcessor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import optas.data.DataCollection;

public class OutputPanelFactory {
    public static DataCollectionViewController constructDataCollection(ExplorerFrame frame, DataCollection dc, File f) {
        ImportMonteCarloDataPanel importDlg = new ImportMonteCarloDataPanel(frame, dc, f);
        importDlg.addActionEventListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        JDialog dialog = importDlg.getDialog();
        dialog.setLocationRelativeTo(null);
        dialog.setModal(true);
        dialog.setVisible(true);
        DataCollection collection = importDlg.getEnsemble();
        DataCollectionViewController controller = new DataCollectionViewController(collection);
        return controller;
    }

    public static Component getOutputDSPanel(JAMSExplorer explorer, FileObject file, String id) throws FileNotFoundException, IOException {
        if (file.getFile().getAbsolutePath().endsWith("cdat")) {
            DataCollection collection = DataCollection.createFromFile((File)file.getFile());
            if (collection == null) {
                JOptionPane.showMessageDialog(explorer.getExplorerFrame(), "failed to load data collection from file: " + file.getFile().getName());
                return null;
            }
            DataCollectionViewController controller = new DataCollectionViewController(collection);
            return controller.getView();
        }
        if (file.getFile().getAbsolutePath().endsWith(".csv")) {
            if (DataStoreProcessor.getDataStoreType((File)file.getFile()) == AbstractDataStoreProcessor.DataStoreType.TimeDataSerie || DataStoreProcessor.getDataStoreType((File)file.getFile()) == AbstractDataStoreProcessor.DataStoreType.DataSerie1D) {
                DataCollectionViewController controller = OutputPanelFactory.constructDataCollection(explorer.getExplorerFrame(), null, file.getFile());
                return controller.getView();
            }
            return new OutputDSPanel(explorer, file.getFile(), id);
        }
        BufferedFileReader reader = new BufferedFileReader(new FileInputStream(file.getFile()));
        String line = reader.readLine();
        reader.close();
        if (line == null) {
            return null;
        }
        if (line.startsWith("@context")) {
            return new OutputDSPanel(explorer, file.getFile(), id);
        }
        if (line.startsWith("#headers")) {
            JAMSSpreadSheet spreadsheet = new JAMSSpreadSheet(explorer);
            spreadsheet.init();
            spreadsheet.load(file.getFile());
            spreadsheet.setAsOutputSheet();
            spreadsheet.setID(id);
            return spreadsheet;
        }
        return new SimpleOutputPanel(file.getFile());
    }
}

