/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.sync;

import jams.server.client.WorkspaceController;
import jams.server.client.sync.FileSync;
import jams.server.entities.WorkspaceFileAssociation;
import jams.tools.FileTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;

public class DirectorySync
extends FileSync {
    TreeSet<FileSync> children = new TreeSet();

    public DirectorySync(WorkspaceController wc, DirectorySync parent, File localDirectory) {
        this.parent = parent;
        this.wc = wc;
        this.localFileName = parent != null ? localDirectory.getName() : localDirectory.getPath();
        this.setTargetFileName(this.localFileName);
        this.serverFile = null;
        this.isFileExisting = super.isLocalFileExisting();
        this.isFileModified = false;
    }

    @Override
    public ArrayList<FileSync> getList(ArrayList<FileSync> list) {
        if (list == null) {
            list = new ArrayList();
        }
        list.add(this);
        for (FileSync fs : this.children) {
            fs.getList(list);
        }
        return list;
    }

    public Set<FileSync> getChildren() {
        return this.children;
    }

    public void createSyncEntry(String path, WorkspaceFileAssociation serverFile) {
        int index = (path = FileTools.normalizePath((String)path)).indexOf("/");
        if (index == -1) {
            this.addFileSync(new FileSync(this.wc, this, serverFile, path));
        } else {
            String subDirName = path.substring(0, index);
            this.doSync = false;
            for (FileSync fs : this.children) {
                if (fs.getLocalFileName().equals(subDirName)) {
                    ((DirectorySync)fs).createSyncEntry(path.substring(index + 1), serverFile);
                    return;
                }
                this.doSync |= fs.doSync;
            }
            File subDirectory = new File(this.getLocalFile(), subDirName);
            this.addFileSync(new DirectorySync(this.wc, this, subDirectory));
        }
    }

    @Override
    public void setDoSync(boolean doSync, boolean recursive) {
        super.setDoSync(doSync, recursive);
        if (recursive) {
            for (FileSync fs : this.children) {
                fs.setDoSync(doSync, true);
            }
        }
    }

    private void addFileSync(FileSync filesync) {
        if (filesync.isModified()) {
            this.markAsModified();
        }
        this.children.add(filesync);
    }

    @Override
    public void applySyncFilter(FileSync.SyncFilter filter) {
        this.setDoSync(filter.isFiltered(this), false);
        for (FileSync fs : this.children) {
            fs.applySyncFilter(filter);
        }
    }

    @Override
    public boolean setSyncMode(FileSync.SyncMode mode) {
        FileSync.SyncMode[] options;
        for (FileSync.SyncMode option : options = this.getSyncOptions()) {
            if (!option.equals((Object)mode)) continue;
            this.syncMode = mode;
            if (this.syncMode == FileSync.SyncMode.DUPLICATE) {
                if (this.getLocalFileName().contains(".")) {
                    this.setTargetFileName(this.getLocalFileName().replace(".", this.sdf.format(new Date()) + "."));
                } else {
                    this.setTargetFileName(this.getLocalFileName() + "_" + this.sdf.format(new Date()));
                }
            } else {
                this.setTargetFileName(this.getLocalFileName());
            }
            for (FileSync fs : this.children) {
                fs.updateSyncMode();
            }
            return true;
        }
        return false;
    }
}

