/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.gui;

import jams.ErrorCatchingRunnable;
import jams.JAMSLogging;
import jams.SystemProperties;
import jams.gui.CancelableWorkerDlg;
import jams.gui.ObserverWorkerDlg;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIState;
import jams.server.client.Controller;
import jams.server.client.FileController;
import jams.server.client.JAMSWorkspaceUploader;
import jams.server.client.JobController;
import jams.server.client.UserController;
import jams.server.client.WorkspaceController;
import jams.server.client.error.DefaultFileUploadErrorHandling;
import jams.server.entities.Job;
import jams.server.entities.WorkspaceFileAssociation;
import jams.tools.LogTools;
import jams.workspace.Workspace;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ResponseProcessingException;

public class JAMSCloudGraphicalController
extends Observable {
    private static final Logger log = Logger.getLogger(JAMSCloudGraphicalController.class.getName());
    private String[] recentUrls = new String[]{"http://localhost:8080/jamscloud/webresources"};
    private String user = "jams";
    private String pw = "jamscloud";
    private String serverUrl = "";
    private boolean saveAccount = true;
    private SystemProperties p;
    private Controller client;
    private Window parent;
    private ObserverWorkerDlg worker;
    private LogTools.ObservableLogHandler observable = new LogTools.ObservableLogHandler(new Logger[]{Logger.getLogger(Controller.class.getName()), Logger.getLogger(FileController.class.getName()), Logger.getLogger(WorkspaceController.class.getName()), Logger.getLogger(JobController.class.getName()), Logger.getLogger(UserController.class.getName())});
    private static JAMSCloudGraphicalController instance = null;

    private JAMSCloudGraphicalController(Window parent, SystemProperties p) {
        this.p = p;
        this.parent = parent;
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)Logger.getLogger(JAMSCloudGraphicalController.class.getName()));
        this.worker = new ObserverWorkerDlg(new CancelableWorkerDlg(new WorkerDlg(parent, "Uploading Workspace")).getWorkerDlg());
        this.observable.deleteObservers();
        this.observable.getHandler().setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return record.getLevel() == Level.FINE || record.getLevel() == Level.INFO;
            }
        });
        this.observable.addObserver((Observer)this.worker);
        if (p != null) {
            this.user = p.getProperty("jams_server_user");
            this.pw = p.getProperty("jams_server_pw");
            String s = p.getProperty("jams_server_save_account");
            if (s != null) {
                try {
                    this.saveAccount = Boolean.parseBoolean(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((s = p.getProperty("jams_server_recent_urls")) != null) {
                this.recentUrls = s.split(";");
            }
        }
    }

    public static JAMSCloudGraphicalController createInstance(Window parent, SystemProperties p) {
        if (instance == null) {
            instance = new JAMSCloudGraphicalController(parent, p);
        }
        return instance;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String[] getRecentUrls() {
        return this.recentUrls;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    public Controller getClient() {
        return this.client;
    }

    public void disconnect() {
        this.client.close();
        this.client = null;
        this.setChanged();
        this.notifyObservers((Object)JAMSCloudEvents.DISCONNECT);
    }

    public Controller connect() throws IOException {
        if (!this.isConnected()) {
            return this.reconnect();
        }
        return this.client;
    }

    private boolean showReconnectDialog() {
        Object[] ob;
        int result;
        JLabel jServerName = new JLabel("Server");
        JComboBox<String> serverUrls = new JComboBox<String>(this.recentUrls);
        serverUrls.setEditable(true);
        JLabel jUserName = new JLabel("User Name");
        JTextField userName = new JTextField();
        JLabel jPassword = new JLabel("Password");
        JPasswordField password = new JPasswordField();
        JLabel jCredentials = new JLabel("Save Credentials");
        JCheckBox cred = new JCheckBox();
        cred.setSelected(this.saveAccount);
        if (this.saveAccount) {
            userName.setText(this.user);
            ((JTextComponent)password).setText(this.pw);
        }
        if ((result = JOptionPane.showConfirmDialog(this.parent, ob = new Object[]{jServerName, serverUrls, jUserName, userName, jPassword, password, jCredentials, cred}, "Please input server URL / username / password", 2)) != 0) {
            return false;
        }
        this.user = userName.getText();
        this.pw = ((JTextComponent)password).getText();
        this.serverUrl = serverUrls.getSelectedItem().toString();
        this.saveAccount = cred.isSelected();
        if (this.p != null) {
            if (this.saveAccount) {
                this.p.setProperty("jams_server_user", this.user);
                this.p.setProperty("jams_server_pw", this.pw);
            }
            this.p.setProperty("jams_server_save_account", Boolean.toString(this.saveAccount));
            String recentUrls = "";
            String curS = serverUrls.getSelectedItem().toString();
            for (int i = 0; i < serverUrls.getModel().getSize() && i < 9; ++i) {
                String s = serverUrls.getModel().getElementAt(i).toString();
                if (s.compareTo(curS) == 0) continue;
                recentUrls = recentUrls + s + ";";
            }
            recentUrls = curS + ";" + recentUrls;
            this.p.setProperty("jams_server_recent_urls", recentUrls);
            ((DefaultComboBoxModel)serverUrls.getModel()).insertElementAt(curS, 0);
            try {
                this.p.save();
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
        return true;
    }

    public Controller reconnect() throws IOException {
        try {
            if (this.isConnected()) {
                this.disconnect();
            }
        }
        catch (Throwable t) {
            LogTools.log(this.getClass(), (Level)Level.WARNING, (Throwable)t, (String)t.toString(), (Object[])new Object[0]);
        }
        this.setChanged();
        this.notifyObservers((Object)JAMSCloudEvents.CONNECTING);
        if (this.showReconnectDialog()) {
            try {
                this.client = new Controller(this.serverUrl, this.user, this.pw);
            }
            catch (ResponseProcessingException pe) {
                if (pe.getResponse().getStatus() == 403) {
                    LogTools.log(this.getClass(), (Level)Level.SEVERE, (Throwable)pe, (String)"You provided a wrong username and/or password or you are not allowed to access this server", (Object[])new Object[0]);
                    if (pe.getResponse().getStatus() == 404) {
                        LogTools.log(this.getClass(), (Level)Level.SEVERE, (Throwable)pe, (String)"The url %1 was not found!".replace("%1", this.serverUrl), (Object[])new Object[0]);
                    }
                } else {
                    LogTools.log(this.getClass(), (Level)Level.SEVERE, (Throwable)pe, (String)pe.getResponse().getStatusInfo().getReasonPhrase(), (Object[])new Object[0]);
                }
            }
            catch (ProcessingException pe) {
                if (pe.toString().contains("Connection refused")) {
                    LogTools.log(this.getClass(), (Level)Level.SEVERE, (Throwable)pe, (String)"Connection was refused.", (Object[])new Object[0]);
                } else {
                    LogTools.log(this.getClass(), (Level)Level.SEVERE, (Throwable)pe, (String)(pe.getMessage().isEmpty() ? pe.toString() : pe.getMessage()), (Object[])new Object[0]);
                }
                this.setChanged();
                this.notifyObservers((Object)JAMSCloudEvents.DISCONNECT);
            }
            this.setChanged();
            this.notifyObservers((Object)JAMSCloudEvents.CONNECT);
            return this.client;
        }
        this.setChanged();
        this.notifyObservers((Object)JAMSCloudEvents.DISCONNECT);
        return null;
    }

    public void downloadWorkspace(jams.server.entities.Workspace ws, File target) {
        WorkerDlg dlg = new WorkerDlg(GUIState.getMainWindow(), "Download Workspace ... ");
        dlg.setInderminate(true);
        dlg.setTask((Runnable)((Object)new DownloadRunnable(ws, target)));
        dlg.execute();
    }

    public void downloadFile(WorkspaceFileAssociation wfa, File target) {
        WorkerDlg dlg = new WorkerDlg(GUIState.getMainWindow(), "Download file ... ");
        dlg.setInderminate(true);
        dlg.setTask((Runnable)((Object)new DownloadRunnable(wfa, target)));
        dlg.execute();
    }

    public jams.server.entities.Workspace uploadWorkspace(Workspace jamsWorkspace, File[] compLibFile, File rtLibFile, String fileFilter) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Not connected to server!");
        }
        if (!rtLibFile.exists() || !rtLibFile.isDirectory()) {
            throw new IOException("Unable to upload workspace! Runtime libraries path is incorrect!");
        }
        this.observable.deleteObserver((Observer)this.worker);
        this.observable.addObserver((Observer)this.worker);
        this.worker.getWorkerDlg().setInderminate(true);
        this.worker.getWorkerDlg().setModal(true);
        UploadWorkspaceRunnable uploadWsTask = new UploadWorkspaceRunnable(jamsWorkspace, compLibFile, rtLibFile, fileFilter);
        this.worker.getWorkerDlg().setTask((Runnable)((Object)uploadWsTask));
        this.worker.getWorkerDlg().execute();
        return uploadWsTask.getWorkspace();
    }

    public Job startJob(jams.server.entities.Workspace ws, File modelFile) {
        if (ws == null) {
            return null;
        }
        WorkspaceFileAssociation model = null;
        for (WorkspaceFileAssociation wfa : ws.getFiles()) {
            if (!wfa.getPath().endsWith(modelFile.getName())) continue;
            model = wfa;
        }
        return this.startJob(ws, model);
    }

    public Job startJob(jams.server.entities.Workspace ws, WorkspaceFileAssociation model) {
        if (ws == null) {
            return null;
        }
        if (model == null) {
            return null;
        }
        this.observable.deleteObserver((Observer)this.worker);
        this.observable.addObserver((Observer)this.worker);
        this.worker.getWorkerDlg().setInderminate(true);
        this.worker.getWorkerDlg().setModal(true);
        StartJobRunnable task = new StartJobRunnable(ws, model);
        this.worker.getWorkerDlg().setTask((Runnable)task);
        this.worker.getWorkerDlg().execute();
        return task.getResult();
    }

    private class StartJobRunnable
    implements Runnable {
        private jams.server.entities.Workspace ws = null;
        private WorkspaceFileAssociation wfa = null;
        private Job job = null;

        public StartJobRunnable(jams.server.entities.Workspace ws, WorkspaceFileAssociation wfa) {
            this.ws = ws;
            this.wfa = wfa;
        }

        @Override
        public void run() {
            try {
                this.job = JAMSCloudGraphicalController.this.client.jobs().create(this.ws, this.wfa);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, t.toString(), t);
            }
            if (this.job != null && this.job.getId() != -1) {
                log.log(Level.INFO, "Job was started successfully! It has ID = %1.".replace("%1", this.job.getId().toString()));
            } else {
                log.log(Level.INFO, "Failed to start job!");
            }
        }

        public Job getResult() {
            return this.job;
        }
    }

    private class UploadWorkspaceRunnable
    extends ErrorCatchingRunnable {
        private final Workspace jamsWorkspace;
        private final String fileFilter;
        private final File[] compLibFile;
        private final File rtLibFile;
        private jams.server.entities.Workspace ws;

        public UploadWorkspaceRunnable(Workspace jamsWorkspace, File[] compLibFile, File rtLibFile, String fileFilter) {
            this.jamsWorkspace = jamsWorkspace;
            this.compLibFile = compLibFile;
            this.rtLibFile = rtLibFile;
            this.fileFilter = fileFilter;
        }

        public void safeRun() throws Exception {
            JAMSWorkspaceUploader uploader = new JAMSWorkspaceUploader(JAMSCloudGraphicalController.this.client);
            this.ws = uploader.uploadWorkspace(this.jamsWorkspace, this.compLibFile, this.rtLibFile, this.fileFilter, new DefaultFileUploadErrorHandling());
        }

        public jams.server.entities.Workspace getWorkspace() {
            return this.ws;
        }
    }

    private class DownloadRunnable
    extends ErrorCatchingRunnable {
        jams.server.entities.Workspace ws;
        WorkspaceFileAssociation wfa;
        File target;

        public DownloadRunnable(jams.server.entities.Workspace ws, File target) {
            this.ws = ws;
            this.target = target;
            this.wfa = null;
        }

        public DownloadRunnable(WorkspaceFileAssociation wfa, File target) {
            this.wfa = wfa;
            this.ws = null;
            this.target = target;
        }

        public void safeRun() throws Exception {
            if (this.ws != null) {
                JAMSCloudGraphicalController.this.client.workspaces().downloadWorkspace(this.target, this.ws);
            } else if (this.wfa != null) {
                JAMSCloudGraphicalController.this.client.workspaces().downloadFile(this.target, this.wfa);
            }
        }
    }

    public static enum JAMSCloudEvents {
        CONNECT,
        CONNECTING,
        DISCONNECT;

    }
}

