/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client;

import jams.JAMS;
import jams.JAMSException;
import jams.server.client.Controller;
import jams.server.client.FileController;
import jams.server.client.WorkspaceController;
import jams.server.client.error.ErrorHandler;
import jams.server.entities.WorkspaceFileAssociation;
import jams.tools.FileTools;
import jams.tools.LogTools;
import jams.workspace.Workspace;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import javax.ws.rs.client.ResponseProcessingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class JAMSWorkspaceUploader {
    private final WorkspaceController workspaceController;
    private final FileController fileController;

    public JAMSWorkspaceUploader(Controller ctrl) {
        this.workspaceController = ctrl.workspaces();
        this.fileController = ctrl.files();
    }

    public static Collection<File> getClassPathFromManifest(File f) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        try (JarFile jar = new JarFile(f);){
            Manifest mf = jar.getManifest();
            Attributes a = mf.getMainAttributes();
            if (a == null) {
                ArrayList<File> arrayList = files;
                return arrayList;
            }
            String classPath = a.getValue(Attributes.Name.CLASS_PATH);
            if (classPath != null) {
                String[] paths;
                for (String path : paths = classPath.split(" ")) {
                    files.add(new File(f.getParent(), path));
                }
            }
        }
        return files;
    }

    public Map<File, Collection<File>> findDependendLibraries(File[] libs) {
        HashMap<File, Collection<File>> map = new HashMap<File, Collection<File>>();
        for (File lib : libs) {
            map.put(lib, this.findDependendLibraries(lib));
        }
        return map;
    }

    public Collection<File> findDependendLibraries(File f) {
        TreeSet<File> doneList = new TreeSet<File>();
        TreeSet<File> libList = new TreeSet<File>();
        TreeSet<File> todoList = new TreeSet<File>();
        todoList.add(f);
        while (!todoList.isEmpty()) {
            File nextFile = (File)todoList.pollFirst();
            if (doneList.contains(nextFile) || !nextFile.exists()) continue;
            if (nextFile.isDirectory()) {
                File[] list = nextFile.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getAbsolutePath().endsWith(".jar");
                    }
                });
                todoList.addAll(Arrays.asList(list));
            } else {
                try {
                    todoList.addAll(JAMSWorkspaceUploader.getClassPathFromManifest(nextFile));
                }
                catch (IOException ioe) {
                    LogTools.log(JAMSWorkspaceUploader.class, (Level)Level.WARNING, (String)ioe.toString(), (Object[])new Object[]{ioe});
                }
                libList.add(nextFile);
            }
            doneList.add(nextFile);
        }
        return libList;
    }

    private int determineRole(File f, File workspace) {
        Path workspacePath = Paths.get(workspace.getPath(), new String[0]);
        Path filePath = Paths.get(f.getPath(), new String[0]);
        Path relativePath = workspacePath.relativize(filePath);
        int role = 4;
        if (relativePath.startsWith("input/")) {
            role = 0;
        } else if (relativePath.startsWith("output/")) {
            role = 1;
        } else if (relativePath.endsWith("config.txt")) {
            role = 3;
        } else if (FileTools.validateModelFile((File)f)) {
            role = 2;
        }
        return role;
    }

    private jams.server.entities.Workspace attachFilesToWorkspace(jams.server.entities.Workspace ws, File baseDirectory, Map<File, jams.server.entities.File> mapping, int role, String prefix) {
        TreeSet<WorkspaceFileAssociation> wfas = new TreeSet<WorkspaceFileAssociation>();
        Path basePath = Paths.get(baseDirectory.toString(), new String[0]);
        for (File localFile : mapping.keySet()) {
            Path path = Paths.get(localFile.getAbsolutePath(), new String[0]);
            String relativePath = basePath.relativize(path).toString();
            jams.server.entities.File serverFile = mapping.get(localFile);
            if (serverFile == null) {
                LogTools.log(this.getClass(), (Level)Level.WARNING, (String)JAMS.i18n((String)"Unable_to_upload_{0}"), (Object[])new Object[]{localFile});
                continue;
            }
            if (relativePath.startsWith("..")) {
                LogTools.log(this.getClass(), (Level)Level.WARNING, (String)"relative path detected, which cannot be processed {0}", (Object[])new Object[]{localFile});
                continue;
            }
            if (role < 0) {
                role = this.determineRole(localFile, baseDirectory);
            }
            if (prefix != null) {
                relativePath = prefix + relativePath;
            }
            wfas.add(new WorkspaceFileAssociation(ws, serverFile, role, relativePath));
        }
        return this.workspaceController.attachFiles(ws, wfas);
    }

    public jams.server.entities.Workspace getWorkspace(Workspace jamsWorkspace) {
        int id = jamsWorkspace.getID();
        String title = jamsWorkspace.getTitle();
        jams.server.entities.Workspace ws = this.workspaceController.ensureExistance(id, title);
        return ws;
    }

    private jams.server.entities.Workspace uploadWorkspaceFiles(jams.server.entities.Workspace ws, File wsDirectory, String fileExclusion, ErrorHandler<File> handler) throws IOException {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Processing_{0}_:{1}"), (Object[])new Object[]{JAMS.i18n((String)"Workspace_Files"), JAMS.i18n((String)"Collecting")});
        Collection workspaceFiles = FileTools.getFilesByRegEx((File)wsDirectory, (String)fileExclusion, (boolean)false);
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Processing_{0}_:{1}"), (Object[])new Object[]{JAMS.i18n((String)"Workspace_Files"), JAMS.i18n((String)"Uploading")});
        Map<File, jams.server.entities.File> wsFileMapping = this.fileController.uploadFile(workspaceFiles, handler);
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Processing_{0}_:{1}"), (Object[])new Object[]{JAMS.i18n((String)"Workspace_Files"), JAMS.i18n((String)"Attaching")});
        ws = this.attachFilesToWorkspace(ws, wsDirectory, wsFileMapping, -1, null);
        return ws;
    }

    private jams.server.entities.Workspace uploadRuntimeLibs(jams.server.entities.Workspace ws, File runtimeLibDir, ErrorHandler<File> handler) throws IOException {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Processing_{0}_:{1}"), (Object[])new Object[]{JAMS.i18n((String)"Runtime_Libraries"), JAMS.i18n((String)"Collecting")});
        Collection runtimeLibFiles = FileUtils.listFiles((File)runtimeLibDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Processing_{0}_:{1}"), (Object[])new Object[]{JAMS.i18n((String)"Runtime_Libraries"), JAMS.i18n((String)"Uploading")});
        Map<File, jams.server.entities.File> runtimeLibMapping = this.fileController.uploadFile(runtimeLibFiles, handler);
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Processing_{0}_:{1}"), (Object[])new Object[]{JAMS.i18n((String)"Runtime_Libraries"), JAMS.i18n((String)"Attaching")});
        ws = this.attachFilesToWorkspace(ws, runtimeLibDir.getParentFile(), runtimeLibMapping, 6, null);
        return ws;
    }

    private jams.server.entities.Workspace uploadComponentLibs(jams.server.entities.Workspace ws, File[] componentLibaries, ErrorHandler<File> handler) throws IOException {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Processing_{0}_:{1}"), (Object[])new Object[]{JAMS.i18n((String)"Component_Libraries"), JAMS.i18n((String)"Collecting")});
        Map<File, Collection<File>> librarySet = this.findDependendLibraries(componentLibaries);
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Processing_{0}_:{1}"), (Object[])new Object[]{JAMS.i18n((String)"Component_Libraries"), JAMS.i18n((String)"Uploading")});
        HashMap<File, Map<File, jams.server.entities.File>> fileMapping = new HashMap<File, Map<File, jams.server.entities.File>>();
        for (File file : componentLibaries) {
            Collection<File> fileList = librarySet.get(file);
            fileMapping.put(file, this.fileController.uploadFile(fileList, handler));
        }
        int c = 0;
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Processing_{0}_:{1}"), (Object[])new Object[]{JAMS.i18n((String)"Component_Libraries"), JAMS.i18n((String)"Attaching")});
        for (File componentLibrary : componentLibaries) {
            Map list = (Map)fileMapping.get(componentLibrary);
            String prefix = "components/" + c++ + "/";
            ws = this.attachFilesToWorkspace(ws, componentLibrary.getAbsoluteFile().getParentFile(), list, 5, prefix);
        }
        return ws;
    }

    public jams.server.entities.Workspace uploadWorkspace(Workspace jamsWorkspace, File[] componentLibaries, File runtimeLibraries, String fileExclusion, ErrorHandler<File> handler) throws IOException {
        jams.server.entities.Workspace ws = this.getWorkspace(jamsWorkspace);
        File wsDirectory = jamsWorkspace.getDirectory();
        try {
            ws = this.workspaceController.detachAll(ws);
            ws = this.uploadWorkspaceFiles(ws, wsDirectory, fileExclusion, handler);
            ws = this.uploadComponentLibs(ws, componentLibaries, handler);
            ws = this.uploadRuntimeLibs(ws, runtimeLibraries, handler);
            return ws;
        }
        catch (ResponseProcessingException rpex) {
            if (rpex.getResponse().getStatus() == 403) {
                throw new JAMSException(MessageFormat.format(JAMS.i18n((String)"No_permission_to_access_workspace_with_id"), jamsWorkspace.getID()), (Throwable)rpex);
            }
            throw rpex;
        }
    }
}

