/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client;

import jams.JAMS;
import jams.data.SingleDataSupplier;
import jams.server.client.Controller;
import jams.server.client.HTTPClient;
import jams.server.client.error.ErrorHandler;
import jams.server.entities.Files;
import jams.tools.LogTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.codec.digest.DigestUtils;

public class FileController {
    HTTPClient client;
    String urlStr;

    public FileController(Controller ctrl) {
        this.client = ctrl.getClient();
        this.urlStr = ctrl.getServerURL();
    }

    public String getHashCode(File f) throws IOException {
        return DigestUtils.md5Hex((InputStream)new FileInputStream(f));
    }

    public Files getHashCode(Files files) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"retrieving_hash_codes_of_server_files"), (Object[])new Object[0]);
        return this.client.httpPost(this.urlStr + "/file/hash", "POST", files, Files.class);
    }

    public jams.server.entities.File uploadFile(File f) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"uploading_{0}"), (Object[])new Object[]{f});
        return this.client.httpFileUpload(this.urlStr + "/file/upload", f, jams.server.entities.File.class);
    }

    public jams.server.entities.File uploadFile(InputStream f) throws IOException {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"uploading_stream"), (Object[])new Object[0]);
        return this.client.httpFileUpload(this.urlStr + "/file/upload", f, jams.server.entities.File.class);
    }

    public Map<File, jams.server.entities.File> uploadFile(Iterable<File> files, ErrorHandler<File> handler) throws IOException {
        Map<File, jams.server.entities.File> mapping;
        block5: {
            mapping = this.find(files);
            Iterator<File> iterator = files.iterator();
            while (true) {
                File f;
                if (mapping.containsKey(f = iterator.next())) {
                    continue;
                }
                LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"uploading_file_{0}"), (Object[])new Object[]{f.getName()});
                mapping.put(f, this.uploadFile(f));
                continue;
                break;
            }
            finally {
                if (!iterator.hasNext()) break block5;
            }
        }
        return mapping;
    }

    public InputStream getFileAsStream(jams.server.entities.File file) throws IOException {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)"{0}{1}", (Object[])new Object[]{JAMS.i18n((String)"getting_file_stream_with_id"), file.getId()});
        return this.client.getStream(this.urlStr + "/file/" + file.getId() + "/getStream");
    }

    public jams.server.entities.File find(int id) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)"{0} {1}", (Object[])new Object[]{JAMS.i18n((String)"retrieving_file_with_id"), id});
        return this.client.httpGet(this.urlStr + "/file/" + id, jams.server.entities.File.class);
    }

    public Map<File, jams.server.entities.File> find(File f) throws IOException {
        return this.find((Iterable<File>)new SingleDataSupplier((Object)f));
    }

    public Map<File, jams.server.entities.File> find(Iterable<File> files) throws IOException {
        HashMap<File, jams.server.entities.File> fileMapping = new HashMap<File, jams.server.entities.File>();
        HashMap<String, File> hashMapping = new HashMap<String, File>();
        Files request = new Files();
        for (File f : files) {
            LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"calculating_hash_key_of_{0}"), (Object[])new Object[]{f.getName()});
            try {
                String hash = this.getHashCode(f);
                request.add(new jams.server.entities.File(Integer.valueOf(0), hash));
                hashMapping.put(hash, f);
            }
            catch (IOException ioe) {
                LogTools.log(this.getClass(), (Level)Level.WARNING, (Throwable)ioe, (String)JAMS.i18n((String)"unable_to_calculate_hashkey_of_{0}"), (Object[])new Object[]{f});
            }
        }
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"searching_for_existing_files"), (Object[])new Object[0]);
        Files response = this.client.httpPost(this.urlStr + "/file/exists", "POST", request, Files.class);
        for (jams.server.entities.File rf : response.getFiles()) {
            File f = (File)hashMapping.get(rf.getHash());
            if (f == null) continue;
            fileMapping.put(f, rf);
        }
        return fileMapping;
    }
}

