/*
 * Decompiled with CFR 0.152.
 */
package Isotopes;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Isotope Mixing", author="Andrew Watson", description="The isotope mixing model utilises isotope concentrationsof rainfall, soil-water and groundwater to validateproportions of RD1, RD2, RG1 and RG2 combinedIt provides a snapshot of flow component portioning atdiscrete sampling intervalsPlease cite:Development of an isotope-enabled rainfall-runoff model:Improving the capability to capture hydrological and anthropogenic changeAuthors: Andrew Watson, Yuliya Vystavna, Sven Kralisch, J\u00f6rg HelmschrotJared van Rooyen and Jodie Miller", date="2022-03-16", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class Tertiary_Isotope_mixing
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Isotope rain", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double isotopeRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Isotope stream", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double isotopeStream;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Isotope soil-water", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double[] isotopeSw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Isotope groundwater", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double isotopeGw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Component A", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double compA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Component B", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double compB;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="RD1 component", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double catchmentRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="RD2 component", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double catchmentRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="RG1 and RG2 component", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double catchmentRG1RG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="catchment Simulated runoff", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double catchmentSimRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;

    public void init() {
    }

    public void run() {
        this.compA.setValue(this.isotopeStream.getValue() * this.catchmentSimRunoff.getValue());
        double curIsotopeSw = this.isotopeSw[this.time.get(2)].getValue();
        if (this.isotopeRain.getValue() != -99.0) {
            this.compB.setValue(this.isotopeGw.getValue() * this.catchmentRG1RG2.getValue() + curIsotopeSw * this.catchmentRD2.getValue());
        } else {
            this.compB.setValue(this.isotopeRain.getValue() * this.catchmentRD1.getValue() + this.isotopeGw.getValue() * this.catchmentRG1RG2.getValue() + curIsotopeSw * this.catchmentRD2.getValue());
        }
    }

    public void cleanup() {
    }
}

