/*
 * Decompiled with CFR 0.152.
 */
package Isotopes;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="IsotopeMixer", author="Andrew Watson, Christian Birkel and Sven Kralisch", description="The isotope mixing component used to mix the incoming isotopecomposition with an existing value as a mass flux", date="2023-04-04", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class IsotopeMixer_
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="intial_volume", defaultValue="0", unit="L", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double inVol;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Initial_concentration", defaultValue="0", unit="mol/L", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double inConc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Actual_volume", defaultValue="0", unit="L", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double actVol;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Actual_concentration", defaultValue="0", unit="mol/L", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double actConc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Actual_Mass", defaultValue="0", unit="unitless", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double actM;

    public void init() {
        this.actVol.setValue(this.inVol.getValue());
        this.actConc.setValue(this.inConc.getValue());
    }

    public void run() {
        double incomingVolume = this.inVol.getValue();
        double incomingConcentration = this.inConc.getValue();
        double totalVolume = this.actVol.getValue() + incomingVolume;
        double newConcentration = (this.actConc.getValue() * this.actVol.getValue() + incomingConcentration * incomingVolume) / totalVolume;
        this.actVol.setValue(totalVolume);
        this.actConc.setValue(newConcentration);
        double newMass = newConcentration * totalVolume;
        this.actM.setValue(newMass);
    }

    public void cleanup() {
    }
}

