/*
 * Decompiled with CFR 0.152.
 */
package Isotopes;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="IsotopeMixer", author="Andrew Watson, Christian Birkel and Sven Kralisch", description="The isotope mixing component used to mix the incoming isotopecomposition with an existing value as a mass flux", date="2023-04-04", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class IsotopeMixer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Updates both concentrations if true, otherwise just concB", defaultValue="true")
    public Attribute.Boolean bidirectional;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Updates both concentrations if true, otherwise just concB", defaultValue="1", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double mixingProportion;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="intial_volume", defaultValue="0", unit="L", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double[] volA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Initial_concentration", defaultValue="0", unit="mol/L", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double[] concA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="intial_volume", defaultValue="0", unit="L", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double[] volB;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Initial_concentration", defaultValue="0", unit="mol/L", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double[] concB;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="missingDataValue", defaultValue="-999")
    public Attribute.Double missingDataValue;

    public void run() {
        for (int i = 0; i < this.volA.length; ++i) {
            if (this.mixingProportion.getValue() == 0.0 || this.concA[i].getValue() == this.missingDataValue.getValue()) continue;
            double volA_ = this.volA[i].getValue();
            double volB_ = this.volB[i].getValue() / this.mixingProportion.getValue();
            double x = this.volA[i].getValue() + this.volB[i].getValue() == 0.0 ? 0.0 : (this.concA[i].getValue() * volA_ + this.concB[i].getValue() * volB_) / (volA_ + volB_);
            if (this.bidirectional.getValue()) {
                this.concA[i].setValue(x);
            }
            this.concB[i].setValue(x);
        }
    }
}

