/*
 * Decompiled with CFR 0.152.
 */
package org.jocl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.jocl.NativePointerObject;

public final class Pointer
extends NativePointerObject {
    public static Pointer to(byte[] values) {
        return new Pointer(ByteBuffer.wrap(values));
    }

    public static Pointer to(char[] values) {
        return new Pointer(CharBuffer.wrap(values));
    }

    public static Pointer to(short[] values) {
        return new Pointer(ShortBuffer.wrap(values));
    }

    public static Pointer to(int[] values) {
        return new Pointer(IntBuffer.wrap(values));
    }

    public static Pointer to(float[] values) {
        return new Pointer(FloatBuffer.wrap(values));
    }

    public static Pointer to(long[] values) {
        return new Pointer(LongBuffer.wrap(values));
    }

    public static Pointer to(double[] values) {
        return new Pointer(DoubleBuffer.wrap(values));
    }

    public static Pointer to(Buffer buffer) {
        if (buffer == null || !buffer.isDirect() && !buffer.hasArray()) {
            throw new IllegalArgumentException("Buffer may not be null and must have an array or be direct");
        }
        return new Pointer(buffer);
    }

    public static Pointer to(NativePointerObject ... pointers) {
        if (pointers == null) {
            throw new IllegalArgumentException("Pointer may not point to null objects");
        }
        return new Pointer(pointers);
    }

    public Pointer() {
    }

    protected Pointer(Buffer buffer) {
        super(buffer);
    }

    private Pointer(NativePointerObject[] pointers) {
        super(pointers);
    }

    protected Pointer(Pointer other) {
        super(other);
    }

    protected Pointer(Pointer other, long byteOffset) {
        super(other, byteOffset);
    }

    boolean isDirectBufferPointer() {
        return this.getBuffer().isDirect();
    }

    @Override
    public Pointer withByteOffset(long byteOffset) {
        return new Pointer(this, byteOffset);
    }
}

