/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import org.geotools.referencing.piecewise.DefaultPiecewiseTransform1DElement;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.lite.gridcoverage2d.ConstantColorMapElement;
import org.geotools.renderer.lite.gridcoverage2d.LinearColorMapElement;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;

class ColorMapUtilities {
    static final int[] DEFAULT_ARGB = new int[]{-16777216, -1};

    ColorMapUtilities() {
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(8, name));
        }
    }

    static int compare(double v1, double v2) {
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            long bits2;
            long bits1 = Double.doubleToRawLongBits(v1);
            if (bits1 < (bits2 = Double.doubleToRawLongBits(v2))) {
                return -1;
            }
            if (bits1 > bits2) {
                return 1;
            }
        }
        return Double.compare(v1, v2);
    }

    static void checkDimension(DirectPosition point) {
        int dim = point.getDimension();
        if (dim != 1) {
            throw new MismatchedDimensionException(Errors.format(13, new Integer(1), new Integer(dim)));
        }
    }

    static DefaultPiecewiseTransform1DElement[] checkPreservingElements(LinearColorMapElement[] preservingElements) {
        if (preservingElements != null) {
            double outval = Double.NaN;
            Color color = null;
            for (int i = 0; i < preservingElements.length; ++i) {
                if (!(preservingElements[i] instanceof ConstantColorMapElement)) {
                    throw new IllegalArgumentException(Errors.format(9, preservingElements));
                }
                ConstantColorMapElement nc = (ConstantColorMapElement)preservingElements[i];
                if (nc.getColors().length != 1) {
                    throw new IllegalArgumentException(Errors.format(9, nc.getColors()));
                }
                if (i == 0) {
                    outval = nc.getOutputMaximum();
                    color = nc.getColors()[0];
                    continue;
                }
                if (ColorMapUtilities.compare(outval, nc.getOutputMaximum()) != 0) {
                    throw new IllegalArgumentException(Errors.format(9, nc.getColors()));
                }
                if (color.equals(nc.getColors()[0])) continue;
                throw new IllegalArgumentException(Errors.format(9, nc.getColors()));
            }
        }
        return preservingElements;
    }
}

