/*
 * Decompiled with CFR 0.152.
 */
package jams.components.tools;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.FullModelState;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.runtime.StandardRuntime;
import jams.tools.FileTools;
import java.io.File;
import java.io.IOException;

public class JAMSModelSnapshot
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.String snapshotFile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.Boolean enable;

    public void freeze() {
        if (this.getModel().getRuntime() instanceof StandardRuntime) {
            StandardRuntime runtime = (StandardRuntime)this.getModel().getRuntime();
            String fileName = null;
            if (this.snapshotFile != null) {
                fileName = FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.snapshotFile.getValue());
            }
            File file = new File(fileName);
            FullModelState state = runtime.getFullModelState();
            try {
                state.writeToFile(file);
            }
            catch (IOException e) {
                runtime.sendErrorMsg(JAMS.i18n((String)"Unable_to_save_model_state_because,") + e.toString());
                runtime.handle((Throwable)e, true);
            }
        } else {
            this.getModel().getRuntime().sendInfoMsg(JAMS.i18n((String)"Snapshoting_not_supported_by_runtime_"));
        }
    }

    public void run() {
        if (this.enable != null && !this.enable.getValue()) {
            return;
        }
        this.freeze();
    }
}

