/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io.unidata;

import com.google.common.collect.ImmutableList;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.tools.FileTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import ucar.ma2.Array;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;

@JAMSComponentDescription(title="TimeIntervalFromNetCDF", author="Sven Kralisch", description="Extract a time interval object from a NetCDF file", date="2023-01-29", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class TimeIntervalFromNetCDF
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="NetCDF file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="name of temporal dimension")
    public Attribute.String timeDimName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time unit, defaults to day (6)", defaultValue="6")
    public Attribute.Integer timeUnit;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time unit count", defaultValue="1")
    public Attribute.Integer timeUnitCount;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Date from which time units are counted. If not set, the value will be extracted from the NetCDF.")
    public Attribute.Calendar baseDate;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The time interval covered by the NetCDF file")
    public Attribute.TimeInterval[] timeIntervals;

    public void init() {
        try {
            String fileName_ = this.fileName.getValue();
            if (!new File(fileName_).exists() && this.getModel().getWorkspaceDirectory() != null) {
                fileName_ = FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)fileName_);
            }
            if (!new File(fileName_).exists()) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't load NetCDF file " + this.fileName + "!\nIf you are not using an absolute path, please ensure you have defined a workspace directory!");
            }
            NetcdfFile ncfile = NetcdfFiles.open((String)fileName_);
            Dimension timeDim = null;
            if (this.timeDimName != null) {
                timeDim = ncfile.findDimension(this.timeDimName.getValue());
            }
            if (timeDim == null) {
                ImmutableList dimensions = ncfile.getDimensions();
                String error = "Please choose one of the following dimensions:";
                for (Dimension dimension : dimensions) {
                    String unit = "";
                    Variable var = ncfile.findVariable(dimension.getName());
                    if (var != null) {
                        unit = var.getUnitsString();
                    }
                    error = error + "\nDimension: " + dimension + " [" + unit + "]";
                }
                this.getModel().getRuntime().sendHalt("Wrong dimension name. " + error);
                return;
            }
            Variable timeVar = ncfile.findVariable(timeDim.getShortName());
            int baseUnit = 24;
            if (this.baseDate == null) {
                String units = timeVar.getUnitsString();
                String[] splitUnits = units.split("since ");
                if (splitUnits[0].startsWith("hours")) {
                    baseUnit = 1;
                }
                String baseDateString = splitUnits[1];
                this.baseDate = this.getModel().getRuntime().getDataFactory().createCalendar();
                this.baseDate.setValue(baseDateString);
            }
            Array timeValues = timeVar.read();
            long baseMillis = this.baseDate.getTimeInMillis();
            long startMillis = Math.round(timeValues.getDouble(0) * (double)baseUnit * 60.0 * 60.0 * 1000.0);
            long endMillis = Math.round(timeValues.getDouble((int)timeValues.getSize() - 1) * (double)baseUnit * 60.0 * 60.0 * 1000.0);
            Attribute.Calendar startDate = this.getModel().getRuntime().getDataFactory().createCalendar();
            Attribute.Calendar endDate = this.getModel().getRuntime().getDataFactory().createCalendar();
            startDate.setTimeInMillis(baseMillis + startMillis);
            endDate.setTimeInMillis(baseMillis + endMillis);
            for (Attribute.TimeInterval timeInterval : this.timeIntervals) {
                timeInterval.setStart(startDate);
                timeInterval.setEnd(endDate);
                timeInterval.setTimeUnit(this.timeUnit.getValue());
                timeInterval.setTimeUnitCount(this.timeUnitCount.getValue());
            }
            this.getModel().getRuntime().println("Time interval identified from NetCDF: " + this.timeIntervals[0].toString(), 2);
        }
        catch (FileNotFoundException ex) {
            this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + this.fileName.getValue() + "\n" + ex);
        }
        catch (IOException ex) {
            this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + this.fileName.getValue() + "\n" + ex);
        }
    }
}

