/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io.unidata;

import com.google.common.collect.ImmutableList;
import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.tools.FileTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;

@JAMSComponentDescription(title="NetCDFReader", author="Sven Kralisch", description="Reader for NetCDF files", date="2023-01-29", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class NetCDFReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar currentTime;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current entity")
    public Attribute.Entity currentEntity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="NetCDF file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="name of temporal dimension")
    public Attribute.String timeDimName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="name of spatial dimension")
    public Attribute.String spaceDimName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Date from which time units are counted. If not set, the value will be extracted from the NetCDF.")
    public Attribute.Calendar baseDate;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Apply data chaching? Will read data of all entities on changing time steps in one go. Not meaningful if spatial iteration is outside temporal iteration.", defaultValue="false")
    public Attribute.Boolean dataCaching;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="names of variables to read")
    public Attribute.String[] varNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="output attributes")
    public Attribute.Double[] values;
    NetcdfFile ncfile;
    List<Variable> vars = new ArrayList<Variable>();
    Dimension timeDim;
    Dimension spaceDim;
    Map<Long, Integer> timeMap = new HashMap<Long, Integer>();
    Map<Long, Integer> spaceMap = new HashMap<Long, Integer>();
    Array[] dataArray;
    double[] missingDataValues;
    int[] spaceIndices;
    int[] timeIndices;
    long oldMillis = -1L;
    int tIndex;
    int sIndex;
    Runnable runner;
    int[] origin = new int[]{0, 0};
    int[] shape = new int[]{1, 1};
    Runnable run_normal = new Runnable(){

        @Override
        public void run() {
            long millis = NetCDFReader.this.currentTime.getTimeInMillis();
            NetCDFReader.this.tIndex = NetCDFReader.this.timeMap.get(NetCDFReader.this.currentTime.getTimeInMillis());
            NetCDFReader.this.sIndex = NetCDFReader.this.spaceMap.get(NetCDFReader.this.currentEntity.getId());
            for (int i = 0; i < NetCDFReader.this.vars.size(); ++i) {
                double value = 0.0;
                NetCDFReader.this.origin[NetCDFReader.this.spaceIndices[i]] = NetCDFReader.this.sIndex;
                NetCDFReader.this.origin[NetCDFReader.this.timeIndices[i]] = NetCDFReader.this.tIndex;
                try {
                    value = NetCDFReader.this.vars.get(i).read(NetCDFReader.this.origin, NetCDFReader.this.shape).getDouble(0);
                }
                catch (IOException ex) {
                    NetCDFReader.this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + NetCDFReader.this.fileName.getValue() + "\n" + ex);
                }
                catch (InvalidRangeException ex) {
                    NetCDFReader.this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + NetCDFReader.this.fileName.getValue() + "\n" + (Object)((Object)ex));
                }
                if (value == NetCDFReader.this.missingDataValues[i]) {
                    value = JAMS.getMissingDataValue();
                }
                NetCDFReader.this.values[i].setValue(value);
            }
        }
    };
    Runnable run_cached = new Runnable(){

        @Override
        public void run() {
            long millis = NetCDFReader.this.currentTime.getTimeInMillis();
            if (millis != NetCDFReader.this.oldMillis) {
                NetCDFReader.this.oldMillis = millis;
                NetCDFReader.this.tIndex = NetCDFReader.this.timeMap.get(NetCDFReader.this.currentTime.getTimeInMillis());
                for (int i = 0; i < NetCDFReader.this.vars.size(); ++i) {
                    NetCDFReader.this.origin[NetCDFReader.this.timeIndices[i]] = NetCDFReader.this.tIndex;
                    try {
                        NetCDFReader.this.dataArray[i] = NetCDFReader.this.vars.get(i).read(NetCDFReader.this.origin, NetCDFReader.this.shape);
                        continue;
                    }
                    catch (IOException ex) {
                        NetCDFReader.this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + NetCDFReader.this.fileName.getValue() + "\n" + ex);
                        continue;
                    }
                    catch (InvalidRangeException ex) {
                        NetCDFReader.this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + NetCDFReader.this.fileName.getValue() + "\n" + (Object)((Object)ex));
                    }
                }
            }
            try {
                NetCDFReader.this.sIndex = NetCDFReader.this.spaceMap.get(NetCDFReader.this.currentEntity.getId());
            }
            catch (Exception ex) {
                if (!NetCDFReader.this.spaceMap.containsKey(NetCDFReader.this.currentEntity.getId())) {
                    NetCDFReader.this.getModel().getRuntime().println("Missing ID in NetCDF file; " + NetCDFReader.this.currentEntity.getId(), 2);
                }
                NetCDFReader.this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + NetCDFReader.this.fileName.getValue() + "\n" + ex);
            }
            for (int i = 0; i < NetCDFReader.this.vars.size(); ++i) {
                double value = NetCDFReader.this.dataArray[i].getDouble(NetCDFReader.this.sIndex);
                if (value == NetCDFReader.this.missingDataValues[i]) {
                    value = JAMS.getMissingDataValue();
                }
                NetCDFReader.this.values[i].setValue(value);
            }
        }
    };

    public void init() {
        if (this.values == null || this.varNames == null || this.values.length != this.varNames.length) {
            this.getModel().getRuntime().sendHalt("Output values and input var names must be defined and must have same number!");
            return;
        }
        this.dataArray = new Array[this.values.length];
        this.missingDataValues = new double[this.values.length];
        this.spaceIndices = new int[this.values.length];
        this.timeIndices = new int[this.values.length];
        try {
            String fileName_ = this.fileName.getValue();
            if (!new File(fileName_).exists() && this.getModel().getWorkspaceDirectory() != null) {
                fileName_ = FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)fileName_);
            }
            if (!new File(fileName_).exists()) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't load NetCDF file " + this.fileName + "!\nIf you are not using an absolute path, please ensure you have defined a workspace directory!");
            }
            this.ncfile = NetcdfFiles.open((String)fileName_);
            if (this.timeDimName != null && this.spaceDimName != null) {
                this.timeDim = this.ncfile.findDimension(this.timeDimName.getValue());
                this.spaceDim = this.ncfile.findDimension(this.spaceDimName.getValue());
            }
            if (this.timeDim == null || this.spaceDim == null) {
                ImmutableList dimensions = this.ncfile.getDimensions();
                String error = "Please choose one of the following dimensions:";
                for (Dimension dimension : dimensions) {
                    String unit = this.ncfile.findVariable(dimension.getName()).getUnitsString();
                    error = error + "\nDimension: " + dimension + " [" + unit + "]";
                }
                this.getModel().getRuntime().sendHalt("Wrong dimension name. " + error);
                return;
            }
            Variable timeVar = this.ncfile.findVariable(this.timeDim.getShortName());
            Array timeValues = timeVar.read();
            Variable spaceVar = this.ncfile.findVariable(this.spaceDim.getShortName());
            Array spaceValues = spaceVar.read();
            if (this.baseDate == null) {
                String units = timeVar.getUnitsString();
                String[] splitUnits = units.split("since ");
                String baseDateString = splitUnits[1];
                this.baseDate = this.getModel().getRuntime().getDataFactory().createCalendar();
                this.baseDate.setValue(baseDateString);
            }
            long baseMillis = this.baseDate.getTimeInMillis();
            int i = 0;
            while ((long)i < timeValues.getSize()) {
                long millis = Math.round(timeValues.getDouble(i) * 24.0 * 60.0 * 60.0 * 1000.0);
                this.timeMap.put(baseMillis + millis, i);
                ++i;
            }
            i = 0;
            while ((long)i < spaceValues.getSize()) {
                this.spaceMap.put(spaceValues.getLong(i), i);
                ++i;
            }
            if (this.varNames == null) {
                String error = "Please choose one or more of the following variables:";
                ImmutableList allVars = this.ncfile.getVariables();
                for (Variable variable : allVars) {
                    error = error + "\nVariable: " + variable.getFullName() + " (Dimensions: " + variable.getDimensionsString() + ")";
                }
                this.getModel().getRuntime().sendHalt("Wrong variable name. " + error);
                return;
            }
            i = 0;
            for (Attribute.String varName : this.varNames) {
                Attribute fillValue;
                Variable var = this.ncfile.findVariable(varName.getValue());
                if (var == null) {
                    String error = "Please choose one or more of the following variables:";
                    ImmutableList allVars = this.ncfile.getVariables();
                    for (Variable variable : allVars) {
                        error = error + "\nVariable: " + variable.getFullName() + " (Dimensions: " + variable.getDimensionsString() + ")";
                    }
                    this.getModel().getRuntime().sendHalt("Wrong variable name. " + error);
                    return;
                }
                this.vars.add(var);
                ImmutableList dimensions = var.getDimensions();
                int j = 0;
                for (Dimension dimension : dimensions) {
                    if (dimension == this.timeDim) {
                        this.timeIndices[i] = j;
                    } else if (dimension == this.spaceDim) {
                        this.spaceIndices[i] = j;
                    }
                    ++j;
                }
                if (this.dataCaching.getValue()) {
                    this.shape[this.spaceIndices[i]] = this.spaceDim.getLength();
                }
                if ((fillValue = var.findAttribute("_FillValue")) != null) {
                    this.missingDataValues[i] = fillValue.getNumericValue().doubleValue();
                }
                ++i;
            }
            this.runner = this.dataCaching.getValue() ? this.run_cached : this.run_normal;
        }
        catch (FileNotFoundException ex) {
            this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + this.fileName.getValue() + "\n" + ex);
        }
        catch (IOException ex) {
            this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + this.fileName.getValue() + "\n" + ex);
        }
    }

    public void run() throws IOException, InvalidRangeException {
        this.runner.run();
    }

    public void cleanup() {
    }
}

