/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io.unidata;

import com.google.common.collect.ImmutableList;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.tools.FileTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;

@JAMSComponentDescription(title="EntitiesFromNetCDF", author="Sven Kralisch", description="Extract an entity collection object from a NetCDF file", date="2023-09-21", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class EntitiesFromNetCDF
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="NetCDF file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="name of spatial dimension")
    public Attribute.String spaceDimName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The spatial units covered by the NetCDF file")
    public Attribute.EntityCollection entities;

    public void init() {
        try {
            String fileName_ = this.fileName.getValue();
            if (!new File(fileName_).exists() && this.getModel().getWorkspaceDirectory() != null) {
                fileName_ = FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)fileName_);
            }
            if (!new File(fileName_).exists()) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't load NetCDF file " + this.fileName + "!\nIf you are not using an absolute path, please ensure you have defined a workspace directory!");
            }
            NetcdfFile ncfile = NetcdfFiles.open((String)fileName_);
            Dimension spaceDim = null;
            if (this.spaceDimName != null) {
                spaceDim = ncfile.findDimension(this.spaceDimName.getValue());
            }
            if (spaceDim == null) {
                ImmutableList dimensions = ncfile.getDimensions();
                String error = "Please choose one of the following dimensions:";
                for (Dimension dimension : dimensions) {
                    String unit = ncfile.findVariable(dimension.getName()).getUnitsString();
                    error = error + "\nDimension: " + dimension + " [" + unit + "]";
                }
                this.getModel().getRuntime().sendHalt("Wrong dimension name. " + error);
                return;
            }
            Variable variable = ncfile.findVariable(spaceDim.getShortName());
        }
        catch (FileNotFoundException ex) {
            this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + this.fileName.getValue() + "\n" + ex);
        }
        catch (IOException ex) {
            this.getModel().getRuntime().sendHalt("Error reading NetCDF file " + this.fileName.getValue() + "\n" + ex);
        }
    }
}

