/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;

@JAMSComponentDescription(title="Entity file writer (temporal)", author="S. Kralisch", description="This component can be used to output one selected entity attribute value for every time step. The resulting CSV formatted ASCII file will contain one line per time step and one column per entity. This component must be wrapped in a temporal, but not in a spatial context!")
public class TemporalEntityWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="EntitySet")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file attribute names")
    public Attribute.String idAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file attribute names")
    public Attribute.String dataAttributeName;
    private GenericDataWriter writer;

    public void init() {
        this.writer = new GenericDataWriter(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.fileName.getValue());
        this.writer.addComment("JAMS entity output from TemporalEntityWriter");
        this.writer.addComment("Attribute name: " + this.dataAttributeName);
        this.writer.addComment("");
        this.writer.addColumn("date/time");
        for (Attribute.Entity e : this.entities.getEntityArray()) {
            this.writer.addColumn("HRU_" + (int)e.getDouble(this.idAttributeName.getValue()));
        }
        this.writer.writeHeader();
    }

    public void run() {
        this.writer.addData((Object)this.time);
        for (Attribute.Entity e : this.entities.getEntityArray()) {
            this.writer.addData((Object)e.getObject(this.dataAttributeName.getValue()).toString());
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Throwable)jre);
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

