/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="EntityObserver", author="Sven Kralisch", description="Ouput an entities attributes and their values to the info log. The entity must be specified by providing the name and value of some identifying attribute.")
public class EntityObserver
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.String idAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.Double idValue;

    public void run() {
        for (Attribute.Entity e : this.entities.getEntities()) {
            if (e.getDouble(this.idAttribute.getValue()) != this.idValue.getValue()) continue;
            this.getModel().getRuntime().println("******************************************************");
            this.getModel().getRuntime().println("Entity information for entity " + e);
            this.getModel().getRuntime().println("******************************************************");
            Object[] keys = e.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                String s;
                Object value = e.getObject(keys[i].toString());
                if (value instanceof Attribute.DoubleArray) {
                    double[] d = ((Attribute.DoubleArray)value).getValue();
                    if (d != null) {
                        for (int j = 0; j < d.length; ++j) {
                            s = String.format("%20s: %s", keys[i] + "[" + j + "]", d[j]);
                            this.getModel().getRuntime().println(s);
                        }
                        continue;
                    }
                    s = String.format("%20s: %s", keys[i] + "[]", "null");
                    this.getModel().getRuntime().println(s);
                    continue;
                }
                s = String.format("%20s: %s", keys[i], value);
                this.getModel().getRuntime().println(s);
            }
            return;
        }
    }
}

