/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="KlimaKennwerte", author="Christian Fischer", description="Calculated standard Klimakennwerte for J2000Klima")
public class TemperatureIndices
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily min temperatur", unit="\u00b0C")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily mean temperatur", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily max temperatur", unit="\u00b0C")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="relative humidity", unit="percent")
    public Attribute.Double relHum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="absolute humidity", unit="g/m\u00b3")
    public Attribute.Double absHum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if hitzetag")
    public Attribute.Double isHotDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="number of hot days without interruption")
    public Attribute.Double successiveHotDays;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if hot period (more than 5 hot days) has just started")
    public Attribute.Double isBeginningOfHotPeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if hot period (more than 5 hot days)")
    public Attribute.Double isHotPeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="threshold for hot days", defaultValue="30", unit="\u00b0C")
    public Attribute.Double hotDayThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tropennacht")
    public Attribute.Double isTropicalNight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="threshold for tropennacht", defaultValue="20", unit="\u00b0C")
    public Attribute.Double tropicalNightThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if summerday")
    public Attribute.Double isSummerDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="threshold for summerday", defaultValue="25", unit="\u00b0C")
    public Attribute.Double summerDayThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if day is attractive for tourists (temp > 15 and < 30) and less than 0.5 mm rain TODO")
    public Attribute.Double isTouristDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if frostday")
    public Attribute.Double isFrostDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="threshold for frostday", defaultValue="0", unit="\u00b0C")
    public Attribute.Double frostDayThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="threshold for frostday", defaultValue="-5", unit="\u00b0C")
    public Attribute.Double permanentFrostDayThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="number of hitzetage without interruption")
    public Attribute.Double successivePermanentFrostDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if hitzeperiode has just started")
    public Attribute.Double isBeginningOfPermanentFrostPeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if hitzeperiode")
    public Attribute.Double isPermanentFrostPeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if eistag")
    public Attribute.Double isIceDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="threshold for iceday", defaultValue="0", unit="\u00b0C")
    public Attribute.Double iceDayThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="1 if tmin is/was below 0\u00b0C")
    public Attribute.Double isTempBelowZero;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if frost/tau has been changed")
    public Attribute.Double isFrostDefrostChange;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates cooling degree days")
    public Attribute.Double coolingDegreeDays;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates heating days where tmean is below 15\u00b0C")
    public Attribute.Double isHeatDay;

    public void run() {
        double tmean = this.tmean.getValue();
        this.isFrostDefrostChange.setValue(0.0);
        this.isHotDay.setValue(0.0);
        this.isHotPeriod.setValue(0.0);
        this.isBeginningOfHotPeriod.setValue(0.0);
        this.isSummerDay.setValue(0.0);
        this.isTropicalNight.setValue(0.0);
        this.isFrostDay.setValue(0.0);
        this.isPermanentFrostPeriod.setValue(0.0);
        this.isBeginningOfPermanentFrostPeriod.setValue(0.0);
        this.isIceDay.setValue(0.0);
        this.isHeatDay.setValue(0.0);
        this.isTouristDay.setValue(0.0);
        if (this.isTempBelowZero.getValue() == 1.0 && this.tmin.getValue() > 0.0) {
            this.isFrostDefrostChange.setValue(1.0);
        }
        this.isTempBelowZero.setValue(0.0);
        if (this.tmin.getValue() < 0.0) {
            this.isTempBelowZero.setValue(1.0);
        }
        if (this.tmax.getValue() >= this.summerDayThreshold.getValue()) {
            this.isSummerDay.setValue(1.0);
        }
        if (this.tmin.getValue() >= this.tropicalNightThreshold.getValue()) {
            this.isTropicalNight.setValue(1.0);
        }
        if (this.tmax.getValue() >= this.hotDayThreshold.getValue()) {
            this.isHotDay.setValue(1.0);
            this.successiveHotDays.setValue(this.successiveHotDays.getValue() + 1.0);
            if (this.successiveHotDays.getValue() == 5.0) {
                this.isHotPeriod.setValue(5.0);
                this.isBeginningOfHotPeriod.setValue(1.0);
            } else if (this.successiveHotDays.getValue() > 5.0) {
                this.isHotPeriod.setValue(1.0);
            }
        } else {
            this.successiveHotDays.setValue(0.0);
        }
        if (this.tmin.getValue() > tmean) {
            System.out.println("Ups .. tmin (" + this.tmin + ") ist gr\u00f6\u00dfer als tmean (" + tmean + ")");
        }
        if (this.tmin.getValue() < this.frostDayThreshold.getValue()) {
            this.isFrostDay.setValue(1.0);
        }
        if (this.tmin.getValue() < this.permanentFrostDayThreshold.getValue()) {
            this.successivePermanentFrostDay.setValue(this.successivePermanentFrostDay.getValue() + 1.0);
            if (this.successivePermanentFrostDay.getValue() == 3.0) {
                this.isPermanentFrostPeriod.setValue(3.0);
                this.isBeginningOfPermanentFrostPeriod.setValue(1.0);
            } else if (this.successivePermanentFrostDay.getValue() >= 3.0) {
                this.isPermanentFrostPeriod.setValue(1.0);
            }
        } else {
            this.successivePermanentFrostDay.setValue(0.0);
        }
        if (this.tmax.getValue() < this.iceDayThreshold.getValue()) {
            this.isIceDay.setValue(1.0);
        }
        this.coolingDegreeDays.setValue(Math.max(tmean - 18.3, 0.0));
        if ((this.time.get(2) >= 8 || this.time.get(2) < 5) && tmean < 15.0) {
            this.isHeatDay.setValue(1.0);
        }
        double est = 610.8 * Math.exp(17.1 * tmean / (234.2 + tmean));
        double maxHum = est * 0.018 / 8.314 / (273.15 + tmean) * 1000.0;
        double absHum = this.relHum.getValue() / 100.0 * maxHum;
        this.absHum.setValue(absHum);
    }
}

