/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.JAMS;
import jams.components.indices.TNC_PrecipIndicators;
import jams.components.indices.TimeSeriesIndicators;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

@JAMSComponentDescription(title="TNC_GroundwaterIndicators", author="sven Kralisch", description="Calculates variance and standard deviation from groundwater levels", date="2019-07-09", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class TNC_GroundwaterIndicators
extends TimeSeriesIndicators {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of JSON output file (leave empty to diable)")
    public Attribute.String jsonFileName;

    public void run() {
        this.readTSData();
        JSONObject json = new JSONObject();
        json.put("nColumns", this.values.length);
        JSONObject jsonColumn = new JSONObject();
        json.put("columns", (Object)jsonColumn);
        for (int i = 0; i < this.values.length; ++i) {
            double d;
            double mean = 0.0;
            double var = 0.0;
            long c = 0L;
            Iterator iterator = this.values[i].iterator();
            while (iterator.hasNext()) {
                d = (Double)iterator.next();
                if (d == JAMS.getMissingDataValue()) continue;
                mean += d;
                ++c;
            }
            mean /= (double)c;
            iterator = this.values[i].iterator();
            while (iterator.hasNext()) {
                d = (Double)iterator.next();
                if (d == JAMS.getMissingDataValue()) continue;
                var += Math.pow(d - mean, 2.0);
            }
            JSONObject colStats = new JSONObject();
            jsonColumn.put(Integer.toString(i), (Object)colStats);
            colStats.put("variance", var /= (double)(c - 1L));
            colStats.put("stddev", Math.sqrt(var));
            colStats.put("mean", mean);
        }
        if (this.jsonFileName != null) {
            try {
                FileWriter writer = new FileWriter(new File(this.getModel().getWorkspace().getOutputDataDirectory(), this.jsonFileName.getValue()));
                writer.write(json.toString());
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TNC_PrecipIndicators.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            System.out.println(json.toString());
        }
    }

    public void cleanup() {
    }
}

