/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Soil Moisture Deficit Index (SMDI) Data Collector", author="Sven Kralisch", description="This component collects required data to calculate the Soil Moisture Deficit Index (SMDI) based on\nNarasimhan, B. & Srinivasan, R. (2005) Development and evaluation of Soil Moisture Deficit Index (SMDI) and Evapotranspiration Deficit Index (ETDI) for agricultural drought monitoring. Agricultural and Forest Meteorology 133(1\u20134), 69\u201388. doi:10.1016/j.agrformet.2005.07.012", date="2017-04-17", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class SMDI_DataCollect
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Soil water content", defaultValue="0")
    public Attribute.Double soilWater;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="The simulation time interval")
    public Attribute.TimeInterval simulationTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current date")
    public Attribute.Calendar date;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Size of aggregation window for baseline statistics (e.g. \"7\" for weekly stats)", defaultValue="7")
    public Attribute.Integer tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Sum of recent values collected")
    public Attribute.Double soilWater_sum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Counter of overall values stored")
    public Attribute.Integer counter;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array of collected soil water content values")
    public Attribute.DoubleArray swValues;
    int arraySize;
    int tres;
    int missing;
    int remain;

    public void init() {
        this.tres = this.tempRes.getValue();
        this.arraySize = (int)this.simulationTimeInterval.getNumberOfTimesteps() / this.tres;
        this.missing = this.simulationTimeInterval.getStart().get(6) % this.tres - 1;
        if (this.missing == -1) {
            this.missing = this.tres - 1;
        }
        this.remain = 365 % this.tres;
    }

    public void initAll() {
        this.swValues.setValue(new double[this.arraySize]);
        this.soilWater_sum.setValue(0.0);
        this.counter.setValue(0);
    }

    public void run() {
        int day = this.date.get(6);
        if (day == 366) {
            return;
        }
        double s = this.soilWater_sum.getValue();
        int c = this.counter.getValue();
        if (day == 1 && this.tres > 1 && c > 0 && this.remain > 0) {
            double newValue;
            int oldSlot = this.counter.getValue() - 1;
            double oldValue = this.swValues.getValue()[oldSlot];
            this.swValues.getValue()[oldSlot] = newValue = (oldValue * (double)this.tres + s) / (double)(this.tres + this.remain);
            s = 0.0;
        }
        s += this.soilWater.getValue();
        if (day % this.tres == 0) {
            this.swValues.getValue()[c] = c == 0 ? s / (double)(this.tres - this.missing) : s / (double)this.tres;
            this.counter.setValue(c + 1);
            s = 0.0;
        }
        this.soilWater_sum.setValue(s);
    }
}

