/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Evapotranspiration Deficit Index (ETDI) Data Collector", author="Sven Kralisch", description="This component collects required data to calculate the Evapotranspiration Deficit Index (ETDI) based on\nNarasimhan, B. & Srinivasan, R. (2005) Development and evaluation of Soil Moisture Deficit Index (SMDI) and Evapotranspiration Deficit Index (ETDI) for agricultural drought monitoring. Agricultural and Forest Meteorology 133(1\u20134), 69\u201388. doi:10.1016/j.agrformet.2005.07.012", date="2017-04-17", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class ETDI_DataCollect
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Potential evapotranspiration", defaultValue="0")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Actual evapotranspiration", defaultValue="0")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="The simulation time interval")
    public Attribute.TimeInterval simulationTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current date")
    public Attribute.Calendar date;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Size of aggregation window for baseline statistics (e.g. \"7\" for weekly stats)", defaultValue="7")
    public Attribute.Integer tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Sum of recent potET values collected")
    public Attribute.Double potET_sum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Sum of recent actET values collected")
    public Attribute.Double actET_sum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Counter of overall values stored")
    public Attribute.Integer counter;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array of collected water stress values")
    public Attribute.DoubleArray wsValues;
    int arraySize;
    int tres;

    public void init() {
        this.tres = this.tempRes.getValue();
        this.arraySize = (int)this.simulationTimeInterval.getNumberOfTimesteps() / this.tres;
    }

    public void initAll() {
        this.wsValues.setValue(new double[this.arraySize]);
        this.potET_sum.setValue(0.0);
        this.counter.setValue(0);
    }

    public void run() {
        int day = this.date.get(6);
        if (day == 366) {
            double newValue;
            int oldSlot = this.counter.getValue() - 1;
            double oldValue = this.wsValues.getValue()[oldSlot];
            double ws = (this.potET.getValue() - this.actET.getValue()) / this.potET.getValue();
            this.wsValues.getValue()[oldSlot] = newValue = (oldValue * (double)this.tres + ws) / (double)(this.tres + 1);
            return;
        }
        double sPET = this.potET_sum.getValue();
        double sAET = this.actET_sum.getValue();
        int c = this.counter.getValue();
        if (day == 1 && this.tres > 1 && c > 0) {
            double newValue;
            int n = 365 % this.tres;
            int oldSlot = this.counter.getValue() - 1;
            double oldValue = this.wsValues.getValue()[oldSlot];
            double ws = (sPET - sAET) / sPET;
            this.wsValues.getValue()[oldSlot] = newValue = (oldValue * (double)this.tres + ws * (double)n) / (double)(this.tres + n);
            sPET = 0.0;
            sAET = 0.0;
        }
        sPET += this.potET.getValue();
        sAET += this.actET.getValue();
        if (day % this.tres == 0) {
            double ws;
            this.wsValues.getValue()[c] = ws = (sPET - sAET) / sPET;
            this.counter.setValue(c + 1);
            sPET = 0.0;
            sAET = 0.0;
        }
        this.potET_sum.setValue(sPET);
        this.actET_sum.setValue(sAET);
    }
}

