/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="ClimateIndicesForest", author="Sven Kralisch", description="Calculates the climatic water balance within the forest growing season")
public class ClimateIndicesForest
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily mean temperatur", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily precipitation", unit="L")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily pot. evapotranspiration", unit="L")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="area of unit", unit="m\u00b2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="weight for calculating normalized climatic water balance, e.g. 30.5 for monthly values", defaultValue="1")
    public Attribute.Double normalization_weight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="current length of the forest vegetation period")
    public Attribute.Double forestVegetationPeriodLength;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="start day of the forest vegetation period")
    public Attribute.Double forestVegetationPeriodStart;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="end day of the forest vegetation period")
    public Attribute.Double forestVegetationPeriodEnd;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the climatic water balance (P-potET)", unit="mm")
    public Attribute.Double KWB;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the climatic water balance (P-potET) during forest vegetation period", unit="mm")
    public Attribute.Double KWBinForestVegetationPeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during forest vegetation period", unit="mm")
    public Attribute.Double KWBinForestVegetationPeriodNorm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during Apr-Jun", unit="mm")
    public Attribute.Double KWBinVP1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during Jul-Sep", unit="mm")
    public Attribute.Double KWBinVP2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during Apr-Sep", unit="mm")
    public Attribute.Double KWBinVP12;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during season 1 (3-5)", unit="mm")
    public Attribute.Double KWBinS1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during season 2 (6-8)", unit="mm")
    public Attribute.Double KWBinS2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during season 3 (9-11)", unit="mm")
    public Attribute.Double KWBinS3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during season 4 (12-2)", unit="mm")
    public Attribute.Double KWBinS4;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during Apr-Jun", unit="mm")
    public Attribute.Double potETinVP1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during Jul-Sep", unit="mm")
    public Attribute.Double potETinVP2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during Apr-Sep", unit="mm")
    public Attribute.Double potETinVP12;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during season 1 (3-5)", unit="mm")
    public Attribute.Double potETinS1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during season 2 (6-8)", unit="mm")
    public Attribute.Double potETinS2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during season 3 (9-11)", unit="mm")
    public Attribute.Double potETinS3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the normalized climatic water balance (P-potET) during season 4 (12-2)", unit="mm")
    public Attribute.Double potETinS4;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="tmp variables")
    public Attribute.DoubleArray tmp;
    private final int INDEX_successiveDaysWithTmeanAboveTenDegree = 0;
    private final int INDEX_KWB_in_forest_vegetation_period = 1;
    private final int INDEX_KWB_in_forest_vegetation_period_old = 2;
    private final int INDEX_FVB_end_day = 3;
    private final int INDEX_SIZE = 4;

    public void run() {
        int day = this.time.get(6);
        int maxDay = this.time.getActualMaximum(6);
        if (this.tmp.getValue() == null) {
            this.tmp.setValue(new double[4]);
        }
        double[] inTmp = this.tmp.getValue();
        if (day == 1) {
            this.forestVegetationPeriodStart.setValue(0.0);
            this.forestVegetationPeriodEnd.setValue(0.0);
            this.forestVegetationPeriodLength.setValue(0.0);
            this.KWBinForestVegetationPeriod.setValue(JAMS.getMissingDataValue());
            this.KWBinForestVegetationPeriodNorm.setValue(JAMS.getMissingDataValue());
            inTmp[1] = 0.0;
        }
        if (this.tmean.getValue() >= 10.0) {
            inTmp[0] = inTmp[0] + 1.0;
        } else {
            if (inTmp[0] >= 5.0) {
                inTmp[2] = inTmp[1];
                inTmp[3] = day - 1;
            }
            inTmp[0] = 0.0;
            if (this.forestVegetationPeriodStart.getValue() == 0.0) {
                inTmp[1] = 0.0;
            }
        }
        if (inTmp[0] == 5.0 && this.forestVegetationPeriodStart.getValue() == 0.0) {
            this.forestVegetationPeriodStart.setValue((double)(day - 4));
        }
        double KWB_mm = (this.precip.getValue() - this.potET.getValue()) / this.area.getValue();
        this.KWB.setValue(KWB_mm);
        if (this.forestVegetationPeriodStart.getValue() == 0.0) {
            if (this.tmean.getValue() >= 10.0) {
                inTmp[1] = inTmp[1] + KWB_mm;
            }
        } else {
            inTmp[1] = inTmp[1] + KWB_mm;
        }
        if (day == maxDay) {
            if (inTmp[0] >= 5.0) {
                inTmp[2] = inTmp[1];
                inTmp[3] = day - 1;
            }
            this.KWBinForestVegetationPeriod.setValue(inTmp[2]);
            this.forestVegetationPeriodEnd.setValue(inTmp[3]);
            this.forestVegetationPeriodLength.setValue(this.forestVegetationPeriodEnd.getValue() - this.forestVegetationPeriodStart.getValue() + 1.0);
            this.KWBinForestVegetationPeriodNorm.setValue(this.KWBinForestVegetationPeriod.getValue() * this.normalization_weight.getValue() / this.forestVegetationPeriodLength.getValue());
            inTmp[1] = 0.0;
        }
        double potET_mm = this.potET.getValue() / this.area.getValue();
        int month = this.time.get(2);
        if (month >= 3 && month <= 5) {
            this.KWBinVP1.setValue(KWB_mm);
            this.potETinVP1.setValue(potET_mm);
        } else {
            this.KWBinVP1.setValue(0.0);
            this.potETinVP1.setValue(0.0);
        }
        if (month >= 6 && month <= 8) {
            this.KWBinVP2.setValue(KWB_mm);
            this.potETinVP2.setValue(potET_mm);
        } else {
            this.KWBinVP2.setValue(0.0);
            this.potETinVP2.setValue(0.0);
        }
        if (month >= 3 && month <= 8) {
            this.KWBinVP12.setValue(KWB_mm);
            this.potETinVP12.setValue(potET_mm);
        } else {
            this.KWBinVP12.setValue(0.0);
            this.potETinVP12.setValue(0.0);
        }
        if (month >= 2 && month <= 4) {
            this.KWBinS1.setValue(KWB_mm);
            this.potETinS1.setValue(potET_mm);
        } else {
            this.KWBinS1.setValue(0.0);
            this.potETinS1.setValue(0.0);
        }
        if (month >= 5 && month <= 7) {
            this.KWBinS2.setValue(KWB_mm);
            this.potETinS2.setValue(potET_mm);
        } else {
            this.KWBinS2.setValue(0.0);
            this.potETinS2.setValue(0.0);
        }
        if (month >= 8 && month <= 10) {
            this.KWBinS3.setValue(KWB_mm);
            this.potETinS3.setValue(potET_mm);
        } else {
            this.KWBinS3.setValue(0.0);
            this.potETinS3.setValue(0.0);
        }
        if (month >= 11 || month <= 1) {
            this.KWBinS4.setValue(KWB_mm);
            this.potETinS4.setValue(potET_mm);
        } else {
            this.KWBinS4.setValue(0.0);
            this.potETinS4.setValue(0.0);
        }
    }
}

