/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import com.vividsolutions.jts.geom.MultiPolygon;
import jams.JAMS;
import jams.components.gui.JAMSAscGridReader;
import jams.components.gui.MapCollection;
import jams.components.gui.Styled3DMapPane;
import jams.components.io.ShapeTool;
import jams.data.Attribute;
import jams.model.JAMSGUIComponent;
import jams.model.JAMSVarDescription;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapCreator3D
extends JAMSGUIComponent
implements MouseListener {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of SLD-File containing layer style information")
    public Attribute.String stylesFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ID of a style in the SLD-File")
    public Attribute.Integer styleID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of hru attribute to add for mapping")
    public Attribute.StringArray showAttr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of ranges for classification attribute")
    public Attribute.StringArray numOfRanges;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Color shading the ranges")
    public Attribute.StringArray rangeColor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of shapefile to add as a layer to the map")
    public Attribute.String shapeFileName1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of shapefile to add as a layer to the map")
    public Attribute.String shapeFileName2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of shapefile to add as a layer to the map")
    public Attribute.String shapeFileName3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Colors for extra shapefiles")
    public Attribute.StringArray shapeColors;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Original shape file name")
    public Attribute.String baseShape;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="path to height map")
    public Attribute.String heightMap;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="resolution of 3d model, that means number of grid cells in each row", defaultValue="256")
    public Attribute.Integer resolution = null;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="switch to toggle directional lighting of 3d model on and off", defaultValue="true")
    public Attribute.Boolean light = null;
    private transient JPanel panel;
    private transient JPanel waitPanel;
    private transient GISPanel gispanel;
    private transient DefaultMapLayer[] optLayers = new DefaultMapLayer[3];
    private transient MapCollection[] mc;
    private int numOfParams;
    private int infoidx;
    private String mapFTypeName = "mapFType";
    private transient DefaultMutableTreeNode top;
    private transient DefaultMutableTreeNode last;
    private transient JTree tree;
    private boolean finished = false;
    private transient DefaultMapContext map;
    private transient JTextPane info;
    private transient JSplitPane mainSplitPane;
    private transient JSplitPane legendPane;
    public transient JScrollPane treeView;
    private transient SimpleFeature selectedF = null;
    private CoordinateReferenceSystem crs;
    private transient DefaultMapContext topmap;
    private DefaultMapLayer selection = null;
    private String[] otherLayers;
    private int div_hor;
    private transient Styled3DMapPane mp;
    private transient JAMSAscGridReader asg;
    static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);

    public void run() {
        try {
            if (this.panel == null) {
                return;
            }
            URL shp = new File(this.baseShape.getValue().split(";")[0]).toURI().toURL();
            ShapefileDataStore shpDs = new ShapefileDataStore(shp);
            this.crs = shpDs.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem();
            if (this.crs == null) {
                ((JLabel)this.waitPanel.getComponents()[0]).setText("<html><center>No *.PRJ file found for<br>" + shp.getFile() + "<center><html>");
                ((JLabel)this.waitPanel.getComponents()[0]).setIcon(new ImageIcon(this.getModel().getRuntime().getClassLoader().getResource("jams/components/gui/resources/error.png")));
                return;
            }
            this.gispanel.removeAll();
            if (this.shapeFileName1 == null) {
                this.shapeFileName1 = this.getModel().getRuntime().getDataFactory().createString();
            }
            if (this.shapeFileName2 == null) {
                this.shapeFileName2 = this.getModel().getRuntime().getDataFactory().createString();
            }
            if (this.shapeFileName3 == null) {
                this.shapeFileName3 = this.getModel().getRuntime().getDataFactory().createString();
            }
            if (this.mp == null) {
                this.mp = new Styled3DMapPane();
            }
            this.info.setText(JAMS.i18n((String)"3D_Map_Pane_loading_map"));
            this.asg = new JAMSAscGridReader(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.heightMap.toString());
            this.mp.light = this.light.getValue();
            this.mp.xRes = this.resolution.getValue();
            this.mp.yRes = this.resolution.getValue();
            this.mp.textureWidth = 2.0 * (double)this.resolution.getValue();
            this.mp.textureHeight = 2.0 * (double)this.resolution.getValue();
            this.mp.setHeightMap(this.asg);
            this.info.setText(JAMS.i18n((String)"3D_Map_Pane_calculating_normals"));
            this.otherLayers = new String[]{this.shapeFileName1.getValue(), this.shapeFileName2.getValue(), this.shapeFileName3.getValue()};
            int j = 0;
            for (String s : this.otherLayers) {
                DefaultMapLayer layer = null;
                if (!s.isEmpty()) {
                    try {
                        File shpFile = new File(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.otherLayers[j]);
                        URL shpUrl = shpFile.toURI().toURL();
                        ShapefileDataStore ds = new ShapefileDataStore(shpUrl);
                        List featureNames = ds.getNames();
                        FeatureSource featureSource = ds.getFeatureSource((Name)featureNames.get(0));
                        String geoType = ((SimpleFeatureType)featureSource.getSchema()).getGeometryDescriptor().getType().getName().toString();
                        if (geoType.equals("LineString") || geoType.equals("MultiLineString")) {
                            layer = new DefaultMapLayer(featureSource, this.gispanel.getLineStyle(this.shapeColors.getValue()[j]));
                        } else if (geoType.equals("Point") || geoType.equals("MultiPoint")) {
                            layer = new DefaultMapLayer(featureSource, this.gispanel.getPointStyle(this.shapeColors.getValue()[j]));
                        } else if (geoType.equals("Polygon") || geoType.equals("MultiPolygon")) {
                            layer = new DefaultMapLayer(featureSource, this.gispanel.getSurfaceStyle(this.shapeColors.getValue()[j]));
                        }
                        layer.setTitle(new File(this.otherLayers[j]).getName());
                        this.optLayers[j] = layer;
                    }
                    catch (Exception e) {
                        this.getModel().getRuntime().handle((Throwable)e);
                    }
                }
                ++j;
            }
            this.numOfParams = this.showAttr.getValue().length;
            this.mc = new MapCollection[this.numOfParams];
            this.getCollections();
            for (int i = 0; i < this.numOfParams; ++i) {
                if (this.mc[i] == null) continue;
                this.gispanel.addMap(this.mc[i]);
                this.infoidx = i;
            }
            if (this.mc[0] == null) {
                this.panel.removeAll();
                JLabel label = new JLabel("No geometry features found in entity set!", 0);
                label.setVerticalTextPosition(3);
                label.setHorizontalTextPosition(0);
                label.setFont(new Font("Dialog", 1, 14));
                this.panel.setLayout(new BorderLayout());
                this.panel.add((Component)label, "Center");
                this.panel.updateUI();
                return;
            }
            this.setMap(this.mc[0]);
            this.mp.init();
            for (DefaultMapLayer l : this.optLayers) {
                if (l == null) continue;
                this.topmap.addLayer((MapLayer)l);
            }
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.expandRow(i);
            }
            this.finished = true;
            this.div_hor = this.gispanel.getSize().width - this.mainSplitPane.getInsets().right - this.mainSplitPane.getDividerSize() - 150;
            int div_ver = this.gispanel.getSize().height - this.mainSplitPane.getInsets().bottom - this.mainSplitPane.getDividerSize() - 150;
            this.mainSplitPane.setLeftComponent(this.mp);
            this.mainSplitPane.setRightComponent(this.legendPane);
            this.mainSplitPane.setDividerLocation(this.div_hor);
            this.legendPane.setDividerLocation(div_ver);
            this.gispanel.add(this.mainSplitPane);
        }
        catch (IOException ex) {
            this.getModel().getRuntime().sendErrorMsg("An error occured while trying to load geometries from " + new File(this.baseShape.getValue().split(";")[0]).getAbsolutePath() + " (" + ex.getMessage() + ")");
        }
    }

    public JPanel getPanel() {
        try {
            this.gispanel = new GISPanel();
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.gispanel, "Center");
        }
        catch (Exception e) {
            this.getModel().getRuntime().handle((Throwable)e);
        }
        if (this.panel == null) {
            this.panel = new JPanel();
            JTextField text = new JTextField("Available only under Windows!");
            text.setEditable(false);
            text.setBorder(null);
            this.panel.add(text);
        }
        return this.panel;
    }

    private void setMap(MapCollection mc) {
        this.map = mc.getMapContext();
        this.mp.setHeightMap(this.asg);
        this.mp.setContext((MapContext)this.map);
    }

    protected SimpleFeature getSelectedFeature() {
        return this.selectedF;
    }

    private void getCollections() {
        for (int i = 0; i <= this.numOfParams - 1; ++i) {
            FeatureCollection fc = FeatureCollections.newCollection();
            SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
            sftb.setName(this.mapFTypeName);
            sftb.setCRS(this.crs);
            sftb.add("geo", MultiPolygon.class);
            sftb.add("newAt", Object.class);
            SimpleFeatureType mapFType = sftb.buildFeatureType();
            Iterator hrusIterate = this.hrus.getEntities().iterator();
            TreeSet<Double> s = new TreeSet<Double>();
            Attribute.Entity e = null;
            while (hrusIterate.hasNext()) {
                e = (Attribute.Entity)hrusIterate.next();
                if (!e.existsAttribute("geom")) continue;
                SimpleFeature f = SimpleFeatureBuilder.template((SimpleFeatureType)mapFType, (String)Integer.toString(Double.valueOf(e.getDouble("ID")).intValue()));
                f.setAttribute("geo", (Object)e.getGeometry("geom"));
                f.setAttribute("newAt", (Object)e.getDouble(this.showAttr.getValue()[i]));
                fc.add((Feature)f);
                s.add(e.getDouble(this.showAttr.getValue()[i]));
            }
            if (fc.isEmpty()) continue;
            this.mc[i] = new MapCollection(this.showAttr.getValue()[i], (FeatureCollection<SimpleFeatureType, SimpleFeature>)fc, "newAt", this.rangeColor.getValue()[i], Integer.parseInt(this.numOfRanges.getValue()[i]), this.crs);
            DefaultMutableTreeNode mapNode = new DefaultMutableTreeNode(this.mc[i].getDesc());
            this.top.add(mapNode);
            Object[] nodeContent = this.mc[i].getRanges();
            DefaultMutableTreeNode entry = null;
            for (int j = 1; j <= nodeContent.length - 1; ++j) {
                entry = new DefaultMutableTreeNode("<= " + (double)Math.round((Double)nodeContent[j] * 100.0) / 100.0, false);
                mapNode.add(entry);
            }
        }
        DefaultMutableTreeNode layerEntry = null;
        int i = 0;
        for (DefaultMapLayer l : this.optLayers) {
            if (l != null) {
                layerEntry = new DefaultMutableTreeNode(this.optLayers[i].getTitle());
                this.top.add(layerEntry);
            }
            ++i;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void mouseExited(MouseEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.optLayers = new DefaultMapLayer[3];
    }

    public class GISPanel
    extends JPanel {
        private StyleBuilder sb;

        private Style createFromSLD(String str) {
            File sld = new File(str);
            try {
                SLDParser stylereader = new SLDParser(styleFactory, sld);
                Style[] style = stylereader.readXML();
                return style[0];
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage());
                return null;
            }
        }

        public Style getLineStyle(String c) {
            this.sb = new StyleBuilder();
            LineSymbolizer ls = this.sb.createLineSymbolizer(Color.decode("#" + c), 2.0);
            return this.sb.createStyle((Symbolizer)ls);
        }

        public Style getPointStyle(String c) {
            this.sb = new StyleBuilder();
            Mark pointMarker = this.sb.createMark("square", Color.decode("#" + c));
            PointSymbolizer ps = this.sb.createPointSymbolizer(this.sb.createGraphic(null, pointMarker, null, 0.0, 7.0, 0.0));
            return this.sb.createStyle((Symbolizer)ps);
        }

        public Style getSurfaceStyle(String c) {
            this.sb = new StyleBuilder();
            PolygonSymbolizer pgs = this.sb.createPolygonSymbolizer(Color.decode("#" + c), Color.decode("#000000"), 1.0);
            return this.sb.createStyle((Symbolizer)pgs);
        }

        public void addMap(MapCollection m) {
            try {
                MapCreator3D.this.topmap.removeLayer((MapLayer)MapCreator3D.this.selection);
                for (DefaultMapLayer l : MapCreator3D.this.optLayers) {
                    if (l == null) continue;
                    MapCreator3D.this.topmap.removeLayer((MapLayer)l);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MapCreator3D.this.map = m.getMapContext();
            MapCreator3D.this.topmap = MapCreator3D.this.map;
            for (DefaultMapLayer l : MapCreator3D.this.optLayers) {
                if (l == null) continue;
                MapCreator3D.this.topmap.addLayer((MapLayer)l);
            }
            MapCreator3D.this.mp.setContext((MapContext)MapCreator3D.this.map);
        }

        public void addToolbar() {
            URL url_zoomIn = this.getClass().getResource("resources/zoom_in.png");
            ImageIcon icon_zoomIn = new ImageIcon(url_zoomIn);
            URL url_zoomOut = this.getClass().getResource("resources/zoom_out.png");
            ImageIcon icon_zoomOut = new ImageIcon(url_zoomOut);
            URL url_zoomExtent = this.getClass().getResource("resources/zoom_extent.png");
            ImageIcon icon_zoomExtent = new ImageIcon(url_zoomExtent);
            URL url_pan = this.getClass().getResource("resources/pan.png");
            ImageIcon icon_pan = new ImageIcon(url_pan);
            URL url_select = this.getClass().getResource("resources/select.png");
            ImageIcon icon_select = new ImageIcon(url_select);
            URL url_export = this.getClass().getResource("resources/export.png");
            ImageIcon icon_export = new ImageIcon(url_export);
            JPanel buttons = new JPanel();
            JButton zoomInButton = new JButton(icon_zoomIn);
            final Cursor defaultCursor = new Cursor(0);
            zoomInButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator3D.this.mp.setCursor(defaultCursor);
                }
            });
            buttons.add(zoomInButton);
            JButton zoomOutButton = new JButton(icon_zoomOut);
            zoomOutButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator3D.this.mp.setCursor(defaultCursor);
                }
            });
            buttons.add(zoomOutButton);
            JButton zoomExtentButton = new JButton(icon_zoomExtent);
            zoomExtentButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator3D.this.mp.setCursor(defaultCursor);
                    MapCreator3D.this.mp.repaint();
                }
            });
            buttons.add(zoomExtentButton);
            JButton panButton = new JButton(icon_pan);
            final Cursor panCursor = new Cursor(13);
            panButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator3D.this.mp.setCursor(panCursor);
                }
            });
            buttons.add(panButton);
            JButton selectButton = new JButton(icon_select);
            final Cursor selectCursor = new Cursor(1);
            selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator3D.this.mp.setCursor(selectCursor);
                }
            });
            buttons.add(selectButton);
            JButton exportButton = new JButton(icon_export);
            exportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator3D.this.mp.setCursor(defaultCursor);
                    try {
                        int idx = MapCreator3D.this.last == null || MapCreator3D.this.last.isRoot() ? 0 : (MapCreator3D.this.last.isLeaf() ? MapCreator3D.this.top.getIndex(MapCreator3D.this.last.getParent()) : (MapCreator3D.this.top.isNodeChild(MapCreator3D.this.last) ? MapCreator3D.this.top.getIndex(MapCreator3D.this.last) : MapCreator3D.this.top.getIndex(MapCreator3D.this.top)));
                        ShapeTool exportPanel = new ShapeTool(MapCreator3D.this.mc[idx], MapCreator3D.this.baseShape, MapCreator3D.this.legendPane);
                        MapCreator3D.this.mainSplitPane.setRightComponent(exportPanel);
                        MapCreator3D.this.mainSplitPane.setDividerLocation(MapCreator3D.this.div_hor);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "For export please select an attribute layer!");
                    }
                }
            });
            buttons.add(exportButton);
            this.add((Component)buttons, "North");
        }

        public GISPanel() throws Exception {
            MapCreator3D.this.mp = new Styled3DMapPane();
            MapCreator3D.this.mp.setCursor(new Cursor(0));
            MapCreator3D.this.legendPane = new JSplitPane(0);
            MapCreator3D.this.info = new JTextPane();
            MapCreator3D.this.info.setContentType("text/html");
            MapCreator3D.this.info.setText("<html><br><center>No feature selected</center></html>");
            MapCreator3D.this.info.setEditable(false);
            MapCreator3D.this.top = new DefaultMutableTreeNode("Map List");
            MapCreator3D.this.tree = new JTree(MapCreator3D.this.top);
            MapCreator3D.this.tree.setCellRenderer(new NodeRenderer());
            MapCreator3D.this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)MapCreator3D.this.tree.getLastSelectedPathComponent();
                    if (node != null) {
                        MapCreator3D.this.last = node;
                        int idxToTopNode = node.isLeaf() ? MapCreator3D.this.top.getIndex(node.getParent()) : MapCreator3D.this.top.getIndex(node);
                        if (e.getClickCount() == 1 & idxToTopNode >= 0 & (MapCreator3D.this.top.isNodeChild(node) || node.isLeaf())) {
                            try {
                                GISPanel.this.addMap(MapCreator3D.this.mc[idxToTopNode]);
                                MapCreator3D.this.mp.repaint();
                                if (MapCreator3D.this.last == null || MapCreator3D.this.last.isRoot()) {
                                    MapCreator3D.this.infoidx = 0;
                                } else if (MapCreator3D.this.last.isLeaf()) {
                                    MapCreator3D.this.infoidx = MapCreator3D.this.top.getIndex(MapCreator3D.this.last.getParent());
                                } else {
                                    MapCreator3D.this.infoidx = MapCreator3D.this.top.getIndex(MapCreator3D.this.last);
                                }
                            }
                            catch (Exception e1) {
                                MapCreator3D.this.getModel().getRuntime().handle((Throwable)e1);
                            }
                        }
                    }
                }
            });
            MapCreator3D.this.info = new JTextPane();
            MapCreator3D.this.info.setEditable(false);
            MapCreator3D.this.info.setText("3D Map Pane has not been started yet, please wait ..");
            boolean light2 = true;
            int Resolution = 256;
            if (MapCreator3D.this.resolution != null) {
                Resolution = MapCreator3D.this.resolution.getValue();
            }
            if (MapCreator3D.this.light != null) {
                light2 = MapCreator3D.this.light.getValue();
            }
            if (MapCreator3D.this.mp == null) {
                MapCreator3D.this.mp = new Styled3DMapPane();
            }
            ((MapCreator3D)MapCreator3D.this).mp.light = light2;
            MapCreator3D.this.mp.setHeightMap(MapCreator3D.this.asg);
            ((MapCreator3D)MapCreator3D.this).mp.xRes = Resolution;
            ((MapCreator3D)MapCreator3D.this).mp.yRes = Resolution;
            ((MapCreator3D)MapCreator3D.this).mp.textureWidth = 2.0 * (double)Resolution;
            ((MapCreator3D)MapCreator3D.this).mp.textureHeight = 2.0 * (double)Resolution;
            JSlider js = new JSlider();
            js.setMinimum(-20);
            js.setMaximum(10);
            js.setPreferredSize(new Dimension(125, 25));
            js.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    ((MapCreator3D)MapCreator3D.this).mp.hScale = (float)Math.exp((double)source.getValue() / 10.0);
                }
            });
            js.setValue(-5);
            JPanel sliderPanel = new JPanel();
            sliderPanel.setBorder(BorderFactory.createTitledBorder("Vertical exaggeration"));
            sliderPanel.add(js);
            JSplitPane miscPanel = new JSplitPane(0);
            miscPanel.setDividerLocation(0.4);
            miscPanel.setBottomComponent(MapCreator3D.this.info);
            miscPanel.setTopComponent(sliderPanel);
            MapCreator3D.this.treeView = new JScrollPane(MapCreator3D.this.tree);
            MapCreator3D.this.legendPane.setTopComponent(MapCreator3D.this.treeView);
            MapCreator3D.this.legendPane.setBottomComponent(miscPanel);
            this.setLayout(new BorderLayout());
            MapCreator3D.this.waitPanel = new JPanel();
            ImageIcon waiticon = new ImageIcon(MapCreator3D.this.getModel().getRuntime().getClassLoader().getResource("jams/components/gui/resources/wait.gif"));
            MapCreator3D.this.waitPanel.setLayout(new BorderLayout());
            JLabel label = new JLabel("Please wait...!", waiticon, 0);
            label.setVerticalTextPosition(3);
            label.setHorizontalTextPosition(0);
            label.setFont(new Font("Dialog", 1, 14));
            MapCreator3D.this.waitPanel.add(label);
            MapCreator3D.this.mainSplitPane = new JSplitPane(1);
            this.add(MapCreator3D.this.waitPanel);
        }

        private void getFeatureInfo(int a, int b) throws CQLException, IOException {
            block7: {
                double x = a;
                double y = b;
                Rectangle bounds = MapCreator3D.this.mp.getBounds();
                double width = 100.0;
                double height = 100.0;
                double mapX = 100.0;
                double mapY = 100.0;
                Filter f1 = CQL.toFilter((String)("CONTAINS(geo, POINT(" + mapX + " " + mapY + "))"));
                int idx = 0;
                try {
                    idx = MapCreator3D.this.last == null || MapCreator3D.this.last.isRoot() ? 0 : (MapCreator3D.this.last.isLeaf() ? MapCreator3D.this.top.getIndex(MapCreator3D.this.last.getParent()) : MapCreator3D.this.top.getIndex(MapCreator3D.this.last));
                    FeatureCollection result = MapCreator3D.this.mc[idx].asCollectionDataStore().getFeatureSource(MapCreator3D.this.mc[idx].asCollectionDataStore().getTypeNames()[0]).getFeatures(f1);
                    if (result.size() == 0) {
                        MapCreator3D.this.info.setText("<html><br><center>No feature selected</center></html>");
                        try {
                            MapCreator3D.this.topmap.removeLayer((MapLayer)MapCreator3D.this.selection);
                        }
                        catch (Exception exception) {}
                        break block7;
                    }
                    MapCreator3D.this.selectedF = null;
                    MapCreator3D.this.selectedF = (SimpleFeature)result.features().next();
                    String paramvalue = String.valueOf((double)Math.round((Double)MapCreator3D.this.selectedF.getAttribute("newAt") * 100.0) / 100.0);
                    String infoTxt = "<html><center><b>HRU-ID:</b><br>" + MapCreator3D.this.selectedF.getIdentifier() + "<br><b>" + MapCreator3D.this.mc[MapCreator3D.this.infoidx].getDesc() + ":</b><br>" + paramvalue + "</center></html>";
                    MapCreator3D.this.info.setText(infoTxt);
                    try {
                        MapCreator3D.this.topmap.removeLayer((MapLayer)MapCreator3D.this.selection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MapCreator3D.this.selection = new DefaultMapLayer(result, this.createFromSLD(MapCreator3D.this.getModel().getWorkspaceDirectory().getPath() + "/" + MapCreator3D.this.stylesFileName.getValue()), "selection");
                    MapCreator3D.this.topmap.addLayer(1, (MapLayer)MapCreator3D.this.selection);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "No attribute layer selected!");
                }
            }
        }
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon iconProject;
        private ImageIcon iconRange;
        private Icon blatt;
        private Icon blatt2;

        public NodeRenderer() {
            this.iconProject = new ImageIcon(MapCreator3D.this.getModel().getRuntime().getClassLoader().getResource("jams/components/gui/resources/root.png"));
            this.iconRange = new ImageIcon(MapCreator3D.this.getModel().getRuntime().getClassLoader().getResource("jams/components/gui/resources/map.png"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            DefaultMutableTreeNode parentnode = (DefaultMutableTreeNode)node.getParent();
            int idxToParentNode = 0;
            int idxToTopNode = 0;
            if (!node.isRoot()) {
                idxToParentNode = parentnode.getIndex(node);
                idxToTopNode = MapCreator3D.this.top.getIndex(parentnode);
            }
            if (node.isRoot()) {
                this.setIcon(this.iconProject);
            }
            if (!leaf && !node.isRoot()) {
                this.setIcon(this.iconRange);
            }
            if (leaf && node.getParent() == MapCreator3D.this.top) {
                this.blatt2 = new MyLayerIcon(MapCreator3D.this.top.getIndex(node));
                this.setIcon(this.blatt2);
            } else if (leaf) {
                this.blatt = new MyIcon(idxToTopNode, idxToParentNode);
                this.setIcon(this.blatt);
            }
            return this;
        }
    }

    class MyIcon
    implements Icon {
        private Integer a;
        private Integer b;

        public MyIcon(Integer a, Integer b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (MapCreator3D.this.finished) {
                g.drawRect(1, 1, 19, 14);
                g.setColor(Color.BLACK);
                g.setColor((Color)MapCreator3D.this.mc[this.a].getColors()[MapCreator3D.this.mc[this.a].getRanges().length - this.b - 1]);
                g.fillRect(1, 1, 19, 14);
            } else {
                MapCreator3D.this.tree.setVisible(false);
            }
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }

    class MyLayerIcon
    implements Icon {
        private int idx;

        public MyLayerIcon(Integer idx) {
            this.idx = idx - MapCreator3D.this.numOfParams;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.BLACK);
            g2d.drawRoundRect(0, 0, 20, 13, 5, 5);
            String geoType = ((SimpleFeatureType)MapCreator3D.this.optLayers[this.idx].getFeatureSource().getSchema()).getGeometryDescriptor().getType().getName().toString();
            g2d.setColor(Color.decode("#" + MapCreator3D.this.shapeColors.getValue()[this.idx]));
            if (geoType.equals("LineString") || geoType.equals("MultiLineString")) {
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(4, 4, 13, 6);
                g2d.drawLine(13, 6, 15, 9);
            } else if (geoType.equals("Point") || geoType.equals("MultiPoint")) {
                g2d.fillRect(4, 4, 4, 4);
                g2d.fillRect(13, 6, 4, 4);
            } else if (geoType.equals("Polygon") || geoType.equals("MultiPolygon")) {
                int[] xPoints = new int[]{2, 5, 9, 17};
                int[] yPoints = new int[]{3, 10, 12, 2};
                g2d.fillPolygon(xPoints, yPoints, 4);
            }
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }
}

