/*
 * Decompiled with CFR 0.152.
 */
package jams.components.efficiencies;

import jams.JAMS;

public class Regression {
    public static double[] calcLinReg(double[] xData, double[] yData) {
        int i;
        double sumYValue = 0.0;
        double meanYValue = 0.0;
        double sumXValue = 0.0;
        double meanXValue = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        double prod = 0.0;
        double NODATA = JAMS.getMissingDataValue();
        int nstat = xData.length;
        double[] regCoef = new double[3];
        int counter = 0;
        for (i = 0; i < nstat; ++i) {
            if (yData[i] == NODATA || xData[i] == NODATA) continue;
            sumYValue += yData[i];
            sumXValue += xData[i];
            ++counter;
        }
        meanYValue = sumYValue / (double)counter;
        meanXValue = sumXValue / (double)counter;
        for (i = 0; i < nstat; ++i) {
            if (yData[i] == NODATA || xData[i] == NODATA) continue;
            sumX += Math.pow(xData[i] - meanXValue, 2.0);
            sumY += Math.pow(yData[i] - meanYValue, 2.0);
            prod += (xData[i] - meanXValue) * (yData[i] - meanYValue);
        }
        if (sumX > 0.0 && sumY > 0.0) {
            regCoef[1] = prod / sumX;
            regCoef[0] = meanYValue - regCoef[1] * meanXValue;
            regCoef[2] = Math.pow(prod / Math.sqrt(sumX * sumY), 2.0);
        } else {
            regCoef[1] = 0.0;
            regCoef[0] = 0.0;
            regCoef[2] = 0.0;
        }
        return regCoef;
    }
}

