/*
 * Decompiled with CFR 0.152.
 */
package jams.components.data;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="EntityAccess", author="Sven Kralisch", description="Find entities by ID in an entity collection. IDs are assumed to be unique, i.e. the first match is returned.", date="2022-08-18", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class EntityAccess
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The entity collection")
    public Attribute.EntityCollection collection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="IDs of the entities to access")
    public Attribute.Long[] ids;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The entities")
    public Attribute.Entity[] entities;

    public void init() {
        for (int i = 0; i < this.ids.length; ++i) {
            long id_ = this.ids[i].getValue();
            for (Attribute.Entity e : this.collection.getEntities()) {
                if (e.getId() != id_) continue;
                this.entities[i].setValue(e);
            }
        }
    }
}

