/*
 * Decompiled with CFR 0.152.
 */
package jams.components.conditional;

import jams.data.Attribute;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="SwitchContext", author="Sven Kralisch", date="12. November 2012", version="1.0_1", description="This component represents a JAMS context which can be used to switch between alternative components. It executes child component number i if the the given attribute matches the i-th value. If no value matches, the i+1-th child component is executed (if existing).")
@VersionComments(entries={@VersionComments.Entry(version="1.0_1", date="2015-02-18", comment="Fixed minor issue with wrong counting of run() invocations")})
public class SwitchContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Double attribute to be compared with values")
    public Attribute.Double attribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Double values to be compared which attribute")
    public Attribute.Double[] values;

    public ComponentEnumerator getRunEnumerator() {
        return new RunEnumerator();
    }

    public long getNumberOfIterations() {
        return -1L;
    }

    public long getRunCount() {
        return -1L;
    }

    static /* synthetic */ Component[] access$000(SwitchContext x0) {
        return x0.getCompArray();
    }

    public class RunEnumerator
    implements ComponentEnumerator {
        final JAMSComponent dummy = new JAMSComponent(){

            public void run() {
            }
        };
        Component[] compArray = SwitchContext.access$000(SwitchContext.this);
        boolean next = true;

        public boolean hasNext() {
            if (this.next) {
                this.next = false;
                return true;
            }
            return false;
        }

        public boolean hasPrevious() {
            return !this.hasNext();
        }

        public Component next() {
            for (int i = 0; i < SwitchContext.this.values.length; ++i) {
                if (SwitchContext.this.attribute.getValue() != SwitchContext.this.values[i].getValue()) continue;
                return this.compArray[i];
            }
            if (this.compArray.length <= SwitchContext.this.values.length) {
                return this.dummy;
            }
            return this.compArray[SwitchContext.this.values.length];
        }

        public Component previous() {
            return this.next();
        }

        public void reset() {
            this.next = true;
        }
    }
}

