/*
 * Decompiled with CFR 0.152.
 */
package jams.components.conditional;

import jams.data.Attribute;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="BooleanConditionalContext", author="Sven Kralisch", description="This component represents a JAMS context which can be used to conditionally execute components. This context must contain two components. If \"condition\" is true, the first one will be executed, otherwise the second one.", date="2008-01-07", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_1", comment="added support for InitAll/CleanupAll states")})
public class BooleanConditionalContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Boolean attribute defining which component to execute", defaultValue="1")
    public Attribute.Boolean condition;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Boolean attribute defining which component to execute", defaultValue="1")
    public Attribute.Boolean initCondition;

    public ComponentEnumerator getInitEnumerator() {
        if (this.initCondition == null) {
            return super.getInitEnumerator();
        }
        return new InitEnumerator();
    }

    protected ComponentEnumerator getInitAllEnumerator() {
        return this.getInitEnumerator();
    }

    protected ComponentEnumerator getCleanupAllEnumerator() {
        return this.getInitEnumerator();
    }

    public ComponentEnumerator getRunEnumerator() {
        return new RunEnumerator();
    }

    public long getNumberOfIterations() {
        return -1L;
    }

    public long getRunCount() {
        return -1L;
    }

    public void initAll() {
        super.initAll();
    }

    public void cleanupAll() {
        super.cleanupAll();
    }

    static /* synthetic */ Component[] access$000(BooleanConditionalContext x0) {
        return x0.getCompArray();
    }

    class InitEnumerator
    extends RunEnumerator {
        final RunEnumerator.DummyComponent dummy;
        Component[] compArray;
        boolean next;

        InitEnumerator() {
            this.dummy = new RunEnumerator.DummyComponent();
            this.compArray = BooleanConditionalContext.this.getCompArray();
            this.next = true;
        }

        @Override
        public Component next() {
            if (BooleanConditionalContext.this.initCondition.getValue()) {
                return this.compArray[0];
            }
            if (this.compArray.length < 1 || this.compArray[1] == null) {
                return this.dummy;
            }
            return this.compArray[1];
        }
    }

    class RunEnumerator
    implements ComponentEnumerator {
        final DummyComponent dummy = new DummyComponent();
        Component[] compArray = BooleanConditionalContext.access$000(BooleanConditionalContext.this);
        boolean next = true;

        RunEnumerator() {
        }

        public boolean hasNext() {
            if (this.next) {
                this.next = false;
                return true;
            }
            return false;
        }

        public boolean hasPrevious() {
            return !this.hasNext();
        }

        public Component next() {
            if (BooleanConditionalContext.this.condition.getValue()) {
                return this.compArray[0];
            }
            if (this.compArray.length < 2 || this.compArray[1] == null) {
                return this.dummy;
            }
            return this.compArray[1];
        }

        public Component previous() {
            return this.next();
        }

        public void reset() {
            this.next = true;
        }

        public class DummyComponent
        extends JAMSComponent {
            public void run() {
            }
        }
    }
}

