/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import it.unimi.dsi.fastutil.doubles.Double2ObjectAVLTreeMap;
import jams.JAMS;
import jams.components.aggregate.SpatialOutputDataStore;
import jams.data.Attribute;
import jams.data.DataSupplier;
import jams.data.DefaultDataFactory;
import jams.data.DoubleArrayDataSupplier;
import jams.io.ShapeFileOutputDataStore;
import jams.io.SimpleOutputDataStore;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@JAMSComponentDescription(title="TimePeriodAggregator", author="Christian Fischer", description="Aggregates timeseries values to a given time period of day, month, year or dekade")
@Deprecated
public class TimePeriodAggregator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="current time")
    public Attribute.TimeInterval interval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="id of e.g. the spatial unit", defaultValue="1")
    public Attribute.Double id;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculate the average value? If average is false, the sum will be calculated.")
    public Attribute.String[] attributeNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The value(s) to be aggregated")
    public Attribute.Double[] value;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="A weight to be used to calculate the weighted aggregate", defaultValue="1")
    public Attribute.Double weight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="aggregationMode: sum; avg; min; max;")
    public Attribute.String[] outerAggregationMode;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="aggregationMode: sum; avg; min; max; ind;")
    public Attribute.String[] innerAggregationMode;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="enable or disable aggregation for the i-th value")
    public Attribute.Boolean[] enabled;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The time period to which the values should be aggregated, possible values are: hourly, daily, monthly, seasonal, halfyear, hydhalfyear, yearly, decadly or custom", defaultValue="daily")
    public Attribute.String outerTimeUnit;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The reference time period for aggregation, e.g. yearly mean of months mean, possible values are: hourly, daily, monthly, seasonal, halfyear, hydhalfyear, yearly, decadly", defaultValue="daily")
    public Attribute.String innerTimeUnit;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="custom time period to which values should be aggregated. Is only used when timeUnit is set to custom.", defaultValue="")
    public Attribute.String customOuterTimePeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="custom number of hrus to filter", defaultValue="")
    public Attribute.String idFilters;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the shapefile to which data should be added.")
    public Attribute.String shpFile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the name of the id field in the shapefile.", defaultValue="ID")
    public Attribute.String idFieldName;
    SimpleOutputDataStore[] outData = null;
    SpatialOutputDataStore[] outData2 = null;
    Double2ObjectAVLTreeMap<SpatialAggregationEntity[]> aggregatedValues = new Double2ObjectAVLTreeMap();
    Attribute.Calendar currentOuterTimePeriod = null;
    Attribute.Calendar currentInnerTimePeriod = null;
    Attribute.Calendar currentTimeStep = null;
    AggregationTimePeriod outerTimeUnitID = AggregationTimePeriod.YEARLY;
    AggregationTimePeriod innerTimeUnitID = AggregationTimePeriod.DAILY;
    AggregationMode[] outerAggregationModeID = null;
    AggregationMode[] innerAggregationModeID = null;
    boolean isHeaderWritten = false;
    boolean writeShpFile = false;
    File dbfFileOriginal = null;
    ShapeFileOutputDataStore[] shpStore = null;
    boolean[] isEnabled = null;
    HashSet<Double> selectedIds = null;
    ArrayList<Attribute.TimeInterval> customTimePeriods = new ArrayList();
    int n = 0;
    ArrayList<double[]> buffers = new ArrayList();

    public boolean checkConfiguration() {
        int n = this.attributeNames.length;
        if (this.outerAggregationMode.length != n) {
            this.getModel().getRuntime().sendInfoMsg("Number of values in parameter \"outerAggregationMode\" does not match the number of attributes");
            return false;
        }
        if (this.innerAggregationMode != null && this.innerAggregationMode.length != n) {
            this.getModel().getRuntime().sendInfoMsg("Number of values in parameter \"innerAggregationMode\" does not match the number of attributes");
            return false;
        }
        if (this.enabled != null && this.enabled.length != n) {
            this.getModel().getRuntime().sendInfoMsg("Number of values in parameter \"enabled\" does not match the number of attributes");
            return false;
        }
        if (this.value.length != n) {
            this.getModel().getRuntime().sendInfoMsg("Number of values in parameter \"value\" does not match the number of attributes");
            return false;
        }
        if (this.outerTimeUnitID == null) {
            this.getModel().getRuntime().sendInfoMsg("Unknown outer aggregation ID:" + this.outerTimeUnit);
            return false;
        }
        if (this.innerTimeUnitID == null) {
            this.getModel().getRuntime().sendInfoMsg("Unknown inner aggregation ID:" + this.innerTimeUnit);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        this.getModel().getRuntime().sendInfoMsg("Init " + this.getInstanceName());
        this.n = this.attributeNames.length;
        this.outData = new SimpleOutputDataStore[this.n];
        this.outData2 = new SpatialOutputDataStore[this.n];
        this.shpStore = new ShapeFileOutputDataStore[this.n];
        this.isEnabled = new boolean[this.n];
        this.outerAggregationModeID = new AggregationMode[this.n];
        this.innerAggregationModeID = new AggregationMode[this.n];
        boolean bl = this.writeShpFile = this.shpFile != null && this.shpFile.getValue() != null && !this.shpFile.getValue().isEmpty();
        if (!this.checkConfiguration()) {
            this.getModel().getRuntime().sendHalt("Configuration of component " + this.getInstanceName() + " is not valid!");
        }
        this.outerTimeUnitID = this.getAggregationTimePeriodByString(this.outerTimeUnit.getValue());
        this.innerTimeUnitID = this.getAggregationTimePeriodByString(this.innerTimeUnit.getValue());
        for (int i = 0; i < this.n; ++i) {
            void var2_3;
            boolean bl2 = this.isEnabled[i] = this.enabled == null || this.enabled[i] == null || this.enabled[i].getValue();
            if (!this.isEnabled[i]) continue;
            this.outerAggregationModeID[i] = this.getAggregationModeByString(this.outerAggregationMode[i].getValue());
            if (this.innerAggregationMode != null) {
                this.innerAggregationModeID[i] = this.getAggregationModeByString(this.innerAggregationMode[i].getValue());
                String string = this.attributeNames[i].getValue() + " " + JAMS.i18n((String)this.outerTimeUnitID.name()) + " " + JAMS.i18n((String)this.outerAggregationModeID[i].name()) + " of " + JAMS.i18n((String)this.innerTimeUnitID.name()) + " " + JAMS.i18n((String)this.innerAggregationModeID[i].name());
            } else {
                this.innerAggregationModeID[i] = AggregationMode.AVERAGE;
                String string = this.attributeNames[i].getValue() + " " + JAMS.i18n((String)this.outerTimeUnitID.name()) + " " + JAMS.i18n((String)this.outerAggregationModeID[i].name());
            }
            File f = new File(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspace().getOutputDataDirectory().getAbsolutePath(), (String)((String)var2_3 + ".dat")));
            File f2 = new File(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspace().getOutputDataDirectory().getAbsolutePath(), (String)((String)var2_3 + "_SODS.dat")));
            try {
                this.outData[i] = new SimpleOutputDataStore(f, false);
                this.outData2[i] = new SpatialOutputDataStore(f2);
            }
            catch (IOException ioe) {
                this.getModel().getRuntime().sendHalt("Can't write to output file:" + f);
            }
            if (!this.writeShpFile) continue;
            File originalShpFile = new File(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspacePath(), (String)this.shpFile.getValue()));
            File newDBFFile = new File(this.getModel().getWorkspace().getOutputDataDirectory().getAbsolutePath() + "/" + (String)var2_3);
            newDBFFile.mkdirs();
            try {
                this.shpStore[i] = new ShapeFileOutputDataStore(originalShpFile, newDBFFile);
                continue;
            }
            catch (IOException ioe) {
                this.getModel().getRuntime().sendErrorMsg(MessageFormat.format(ioe.toString(), this.getInstanceName()));
            }
        }
        this.customTimePeriods.clear();
        if (!this.customOuterTimePeriod.getValue().isEmpty()) {
            void var2_8;
            String[] periods;
            for (String period : periods = this.customOuterTimePeriod.getValue().split(";")) {
                period = period + " 6 1";
                Attribute.TimeInterval ti = DefaultDataFactory.getDataFactory().createTimeInterval();
                ti.setValue(period);
                this.customTimePeriods.add(ti);
            }
            boolean bl3 = false;
            while (var2_8 < this.customTimePeriods.size()) {
                Attribute.TimeInterval tii = this.customTimePeriods.get((int)var2_8);
                for (int j = 0; j < this.customTimePeriods.size(); ++j) {
                    if (var2_8 == j) continue;
                    Attribute.TimeInterval tij = this.customTimePeriods.get(j);
                    if ((!tii.getStart().before(tij.getStart()) || !tii.getEnd().after(tij.getStart())) && (!tii.getEnd().before(tij.getEnd()) || !tii.getEnd().after(tij.getEnd()))) continue;
                    this.getModel().getRuntime().sendHalt("Error: Time-Interval " + tii + " is overlapping with " + tij + "!");
                }
                ++var2_8;
            }
        }
    }

    private AggregationTimePeriod getAggregationTimePeriodByString(String mode) {
        if (mode.compareToIgnoreCase("hourly") == 0) {
            return AggregationTimePeriod.HOURLY;
        }
        if (mode.compareToIgnoreCase("daily") == 0) {
            return AggregationTimePeriod.DAILY;
        }
        if (mode.compareToIgnoreCase("monthly") == 0) {
            return AggregationTimePeriod.MONTHLY;
        }
        if (mode.compareToIgnoreCase("yearly") == 0) {
            return AggregationTimePeriod.YEARLY;
        }
        if (mode.compareToIgnoreCase("decadly") == 0) {
            return AggregationTimePeriod.DECADLY;
        }
        if (mode.compareToIgnoreCase("seasonal") == 0) {
            return AggregationTimePeriod.SEASONAL;
        }
        if (mode.compareToIgnoreCase("halfyear") == 0) {
            return AggregationTimePeriod.HALFYEAR;
        }
        if (mode.compareToIgnoreCase("hydhalfyear") == 0) {
            return AggregationTimePeriod.HYDHALFYEAR;
        }
        if (mode.compareToIgnoreCase("custom") == 0) {
            return AggregationTimePeriod.CUSTOM;
        }
        this.getModel().getRuntime().sendErrorMsg(MessageFormat.format(JAMS.i18n((String)("Unknown time unit:" + mode + ".\nPossible values are daily, monthly, yearly and decadly.")), this.getInstanceName()));
        return null;
    }

    private AggregationMode getAggregationModeByString(String mode) {
        if (mode.compareToIgnoreCase("sum") == 0) {
            return AggregationMode.SUM;
        }
        if (mode.compareToIgnoreCase("avg") == 0) {
            return AggregationMode.AVERAGE;
        }
        if (mode.compareToIgnoreCase("min") == 0) {
            return AggregationMode.MINIMUM;
        }
        if (mode.compareToIgnoreCase("max") == 0) {
            return AggregationMode.MAXIMUM;
        }
        if (mode.compareToIgnoreCase("last") == 0) {
            return AggregationMode.LAST;
        }
        if (mode.compareToIgnoreCase("independent") == 0) {
            return AggregationMode.INDEPENDENT;
        }
        this.getModel().getRuntime().sendErrorMsg(MessageFormat.format(JAMS.i18n((String)("Unknown aggregation mode:" + mode + ".\nPossible values are sum, average, min, max, independent")), this.getInstanceName()));
        return null;
    }

    private Attribute.Calendar roundToTimePeriod(Attribute.Calendar in, AggregationTimePeriod timeUnitID) {
        Attribute.Calendar out = in.clone();
        switch (timeUnitID) {
            case HOURLY: {
                out.removeUnsignificantComponents(11);
                break;
            }
            case DAILY: {
                out.removeUnsignificantComponents(5);
                break;
            }
            case MONTHLY: {
                out.removeUnsignificantComponents(2);
                break;
            }
            case YEARLY: {
                out.removeUnsignificantComponents(1);
                break;
            }
            case DECADLY: {
                out.removeUnsignificantComponents(1);
                int yearInDekade = (out.get(1) - 1) % 10;
                out.set(out.get(1) - yearInDekade, 0, 1, 12, 0, 0);
                break;
            }
            case SEASONAL: {
                out.removeUnsignificantComponents(2);
                int month = out.get(2);
                int year = out.get(1);
                if (month < 2) {
                    month = 12;
                    --year;
                } else {
                    month = month < 5 ? 2 : (month < 8 ? 5 : (month < 11 ? 8 : 12));
                }
                out.set(year, month, 1, 12, 0, 0);
                break;
            }
            case HALFYEAR: {
                out.removeUnsignificantComponents(2);
                int month = out.get(2);
                month = month < 6 ? 0 : 6;
                out.set(out.get(1), month, 1, 12, 0, 0);
                break;
            }
            case HYDHALFYEAR: {
                out.removeUnsignificantComponents(2);
                int month = out.get(2);
                if (month >= 4 && month <= 9) {
                    month = 4;
                    out.set(out.get(1), month, 1, 12, 0, 0);
                    break;
                }
                if (month < 4) {
                    month = 10;
                    out.set(out.get(1) - 1, month, 1, 12, 0, 0);
                    break;
                }
                month = 10;
                out.set(out.get(1), month, 1, 12, 0, 0);
                break;
            }
            case CUSTOM: {
                boolean isConsidered = false;
                for (Attribute.TimeInterval ti : this.customTimePeriods) {
                    if (ti.getStart().after(in) || ti.getEnd().before(in)) continue;
                    out.setValue(ti.getStart().toString());
                    isConsidered = true;
                    break;
                }
                if (isConsidered) break;
                return null;
            }
        }
        return out;
    }

    private void writeData(AggregationMode[] outerAggregationMode, AggregationTimePeriod innerAggregationTimePeriod, AggregationTimePeriod outerAggregationTimePeriod, Attribute.Calendar outerTimePeriod) {
        int i;
        if (!this.isHeaderWritten) {
            for (i = 0; i < this.outData.length; ++i) {
                if (!this.isEnabled[i]) continue;
                try {
                    this.outData[i].setHeader((Set)this.aggregatedValues.keySet());
                    this.outData2[i].setHeader((Collection<Double>)this.aggregatedValues.keySet());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                this.isHeaderWritten = true;
            }
        }
        for (i = 0; i < this.buffers.size(); ++i) {
            Arrays.fill(this.buffers.get(i), 0.0);
        }
        for (i = 0; i < this.outData.length; ++i) {
            if (!this.isEnabled[i]) continue;
            try {
                int j = 0;
                if (this.buffers.isEmpty()) {
                    this.buffers.add(new double[this.aggregatedValues.size()]);
                }
                double[] buffer = this.buffers.get(0);
                for (SpatialAggregationEntity[] dataset : this.aggregatedValues.values()) {
                    switch (outerAggregationMode[i]) {
                        case AVERAGE: {
                            dataset[i].outerValue[0] = dataset[i].outerValue[0] / (double)dataset[i].outerTimestepCounter[0];
                            buffer[j] = dataset[i].outerValue[0];
                            break;
                        }
                        case SUM: {
                            buffer[j] = dataset[i].outerValue[0];
                            break;
                        }
                        case MINIMUM: {
                            buffer[j] = dataset[i].outerValue[0];
                            break;
                        }
                        case MAXIMUM: {
                            buffer[j] = dataset[i].outerValue[0];
                            break;
                        }
                        case INDEPENDENT: {
                            for (int k = 0; k < dataset[i].outerValue.length; ++k) {
                                int n = k;
                                dataset[i].outerValue[n] = dataset[i].outerValue[n] / (double)dataset[i].outerTimestepCounter[k];
                                if (this.buffers.size() <= k) {
                                    this.buffers.add(new double[this.aggregatedValues.size()]);
                                }
                                this.buffers.get((int)k)[j] = dataset[i].outerValue[k];
                            }
                        }
                        case LAST: {
                            buffer[j] = dataset[i].outerValue[0];
                        }
                    }
                    ++j;
                }
                if (outerTimePeriod == null) continue;
                if (outerAggregationMode[i] == AggregationMode.INDEPENDENT) {
                    for (int k = 0; k < this.buffers.size(); ++k) {
                        Attribute.Calendar c = outerTimePeriod.clone();
                        if (innerAggregationTimePeriod == AggregationTimePeriod.HOURLY || outerAggregationTimePeriod == AggregationTimePeriod.HOURLY) {
                            this.getModel().getRuntime().sendHalt("Hourly time step is not supported in independent mode!!");
                        }
                        if (innerAggregationTimePeriod == AggregationTimePeriod.DAILY && outerAggregationTimePeriod == AggregationTimePeriod.MONTHLY) {
                            c.set(c.get(1), c.get(2), k, 1, 0, 0);
                        }
                        if (innerAggregationTimePeriod == AggregationTimePeriod.DAILY && outerAggregationTimePeriod == AggregationTimePeriod.YEARLY) {
                            c.add(5, k);
                        }
                        if (innerAggregationTimePeriod == AggregationTimePeriod.MONTHLY) {
                            c.add(2, k);
                        }
                        if (innerAggregationTimePeriod == AggregationTimePeriod.SEASONAL) {
                            c.add(2, 3 * k);
                        }
                        if (innerAggregationTimePeriod == AggregationTimePeriod.YEARLY) {
                            c.add(1, k);
                        }
                        this.outData[i].writeData(c.toString(), (DataSupplier)new DoubleArrayDataSupplier(this.buffers.get(k)));
                        this.outData2[i].writeData(c.toString(), (DataSupplier<Double>)new DoubleArrayDataSupplier(this.buffers.get(k)));
                    }
                    continue;
                }
                this.outData[i].writeData(outerTimePeriod.toString(), (DataSupplier)new DoubleArrayDataSupplier(buffer));
                this.outData2[i].writeData(outerTimePeriod.toString(), (DataSupplier<Double>)new DoubleArrayDataSupplier(buffer));
                continue;
            }
            catch (IOException ioe) {
                this.getModel().getRuntime().sendHalt("Can't write to output file:" + this.outData[i].getFile());
            }
        }
    }

    private void initAggregatedValueArray(SpatialAggregationEntity[] value, AggregationMode[] innerAggregationMode, AggregationMode[] outerAggregationMode, AggregationTimePeriod innerTimePeriod, AggregationTimePeriod outerTimePeriod) {
        for (int i = 0; i < value.length; ++i) {
            if (!this.isEnabled[i]) continue;
            value[i] = new SpatialAggregationEntity();
            value[i].initInnerAggregatedValueArray(innerAggregationMode[i]);
            value[i].initOuterAggregatedValueArray(outerAggregationMode[i], outerTimePeriod, innerTimePeriod, this.interval);
        }
    }

    public boolean isIDSelected(double id) {
        if (!this.idFilters.getValue().isEmpty()) {
            String[] idFilter;
            if (this.selectedIds != null) {
                return this.selectedIds.contains(id);
            }
            this.selectedIds = new HashSet();
            for (String filter : idFilter = this.idFilters.getValue().split(";")) {
                try {
                    if (filter.contains("[")) {
                        String[] ids = filter.split("-");
                        ids[0] = ids[0].replace("[", "");
                        ids[0] = ids[0].replace("]", "");
                        ids[1] = ids[1].replace("[", "");
                        ids[1] = ids[1].replace("]", "");
                        double id1 = Double.parseDouble(ids[1]);
                        for (double id0 = Double.parseDouble(ids[0]); id0 <= id1; id0 += 1.0) {
                            this.selectedIds.add(id0);
                        }
                        continue;
                    }
                    double idF = Double.parseDouble(filter);
                    this.selectedIds.add(idF);
                }
                catch (Throwable nfe) {
                    this.getModel().getRuntime().sendErrorMsg("Error: Could not parse filter string:" + filter);
                    return false;
                }
            }
            return this.selectedIds.contains(id);
        }
        return true;
    }

    private void transferInnerDataToOuterData(AggregationMode[] outerAggregationMode, AggregationTimePeriod outerTimePeriod, AggregationMode[] innerAggregationMode, AggregationTimePeriod innerTimePeriod, Attribute.Calendar time, Attribute.TimeInterval timeInterval) {
        int n = outerAggregationMode.length;
        for (SpatialAggregationEntity[] entity : this.aggregatedValues.values()) {
            for (int i = 0; i < n; ++i) {
                if (!this.isEnabled[i]) continue;
                entity[i].transferInnerDataToOuterData(outerAggregationMode[i], outerTimePeriod, innerAggregationMode[i], innerTimePeriod, time, timeInterval);
            }
        }
    }

    public void run() {
        boolean nextTimeStep;
        int i;
        double iid = this.id.getValue();
        SpatialAggregationEntity[] entity = null;
        entity = (SpatialAggregationEntity[])this.aggregatedValues.get(iid);
        boolean idSelected = this.isIDSelected(iid);
        if (!idSelected) {
            return;
        }
        if (entity == null) {
            entity = new SpatialAggregationEntity[this.n];
            this.initAggregatedValueArray(entity, this.innerAggregationModeID, this.outerAggregationModeID, this.innerTimeUnitID, this.outerTimeUnitID);
            this.aggregatedValues.put(iid, (Object)entity);
        }
        if (this.currentTimeStep == null) {
            this.currentTimeStep = this.time.getValue();
        }
        if (this.currentInnerTimePeriod == null) {
            this.currentInnerTimePeriod = this.roundToTimePeriod(this.currentTimeStep, this.innerTimeUnitID);
            for (i = 0; i < entity.length; ++i) {
                if (!this.isEnabled[i]) continue;
                entity[i].innerTimestepCounter = 0;
            }
        }
        if (this.currentOuterTimePeriod == null) {
            this.currentOuterTimePeriod = this.roundToTimePeriod(this.currentTimeStep, this.outerTimeUnitID);
            this.currentInnerTimePeriod = this.roundToTimePeriod(this.currentTimeStep, this.innerTimeUnitID);
            for (i = 0; i < entity.length; ++i) {
                if (!this.isEnabled[i]) continue;
                Arrays.fill(entity[i].outerTimestepCounter, 0);
            }
        }
        boolean bl = nextTimeStep = this.currentTimeStep.getTimeInMillis() != this.time.getTimeInMillis();
        if (this.currentOuterTimePeriod == null) {
            if (nextTimeStep) {
                this.currentTimeStep = this.time.clone();
                Attribute.Calendar tmp = this.time.clone();
                tmp.add(this.interval.getTimeUnit(), this.interval.getTimeUnitCount());
                boolean isLastTimeStep = tmp.after(this.interval.getEnd());
                if (isLastTimeStep & this.writeShpFile) {
                    for (int i2 = 0; i2 < this.attributeNames.length; ++i2) {
                        if (!this.isEnabled[i2]) continue;
                        this.getModel().getRuntime().sendInfoMsg("Transfering data to shapefile from dataset: " + this.outData[i2].getFile().getName());
                        try {
                            this.shpStore[i2].addDataToShpFiles(this.outData[i2], this.idFieldName.getValue());
                            continue;
                        }
                        catch (IOException ioe) {
                            this.getModel().getRuntime().sendHalt("Can't write to output file:" + this.outData[i2].getFile() + "\n" + ioe.toString());
                        }
                    }
                }
            }
            return;
        }
        if (nextTimeStep) {
            this.currentTimeStep = this.time.clone();
            if (!this.currentInnerTimePeriod.equals(this.roundToTimePeriod(this.currentTimeStep, this.innerTimeUnitID))) {
                this.transferInnerDataToOuterData(this.outerAggregationModeID, this.outerTimeUnitID, this.innerAggregationModeID, this.innerTimeUnitID, this.currentInnerTimePeriod, this.interval);
                this.currentInnerTimePeriod = this.roundToTimePeriod(this.currentTimeStep, this.innerTimeUnitID);
            }
            if (!this.currentOuterTimePeriod.equals(this.roundToTimePeriod(this.currentTimeStep, this.outerTimeUnitID))) {
                this.writeData(this.outerAggregationModeID, this.innerTimeUnitID, this.outerTimeUnitID, this.currentOuterTimePeriod);
                for (SpatialAggregationEntity[] entity2 : this.aggregatedValues.values()) {
                    this.initAggregatedValueArray(entity2, this.innerAggregationModeID, this.outerAggregationModeID, this.innerTimeUnitID, this.outerTimeUnitID);
                }
                this.currentOuterTimePeriod = this.roundToTimePeriod(this.currentTimeStep, this.outerTimeUnitID);
            }
        }
        for (int i3 = 0; i3 < this.n; ++i3) {
            if (!this.isEnabled[i3]) continue;
            entity[i3].considerData(this.value[i3].getValue(), this.innerAggregationModeID[i3], this.innerTimeUnitID, this.time, this.interval);
        }
        if (nextTimeStep) {
            Attribute.Calendar tmp = this.time.clone();
            tmp.add(this.interval.getTimeUnit(), this.interval.getTimeUnitCount());
            boolean isLastTimeStep = tmp.after(this.interval.getEnd());
            if (isLastTimeStep) {
                this.transferInnerDataToOuterData(this.outerAggregationModeID, this.outerTimeUnitID, this.innerAggregationModeID, this.innerTimeUnitID, this.currentTimeStep, this.interval);
                this.writeData(this.outerAggregationModeID, this.innerTimeUnitID, this.outerTimeUnitID, this.currentOuterTimePeriod);
                if (this.writeShpFile) {
                    for (int i4 = 0; i4 < this.attributeNames.length; ++i4) {
                        if (!this.isEnabled[i4]) continue;
                        this.getModel().getRuntime().sendInfoMsg("Transfering data to shapefile from dataset: " + this.outData[i4].getFile().getName());
                        try {
                            this.shpStore[i4].addDataToShpFiles(this.outData[i4], this.idFieldName.getValue());
                            continue;
                        }
                        catch (IOException ioe) {
                            this.getModel().getRuntime().sendHalt("Can't write to output file:" + this.outData[i4].getFile() + "\n" + ioe.toString());
                        }
                    }
                }
            }
        }
    }

    static enum AggregationMode {
        MINIMUM,
        MAXIMUM,
        AVERAGE,
        SUM,
        INDEPENDENT,
        LAST;

    }

    static enum AggregationTimePeriod {
        HOURLY,
        DAILY,
        YEARLY,
        SEASONAL,
        MONTHLY,
        DECADLY,
        HALFYEAR,
        HYDHALFYEAR,
        CUSTOM;

    }

    private class SpatialAggregationEntity {
        double innerValue;
        double[] outerValue;
        int innerTimestepCounter;
        int[] outerTimestepCounter;

        private SpatialAggregationEntity() {
        }

        public void initInnerAggregatedValueArray(AggregationMode innerAggregationMode) {
            switch (innerAggregationMode) {
                default: {
                    this.innerValue = 0.0;
                    break;
                }
                case AVERAGE: {
                    this.innerValue = 0.0;
                    break;
                }
                case MINIMUM: {
                    this.innerValue = Double.POSITIVE_INFINITY;
                    break;
                }
                case MAXIMUM: {
                    this.innerValue = Double.NEGATIVE_INFINITY;
                    break;
                }
                case LAST: {
                    this.innerValue = 0.0;
                }
            }
            this.innerTimestepCounter = 0;
        }

        public void initOuterAggregatedValueArray(AggregationMode outerAggregationMode, AggregationTimePeriod outerTimePeriod, AggregationTimePeriod innerTimePeriod, Attribute.TimeInterval interval) {
            switch (outerAggregationMode) {
                case SUM: {
                    if (this.outerValue == null) {
                        this.outerValue = new double[1];
                        this.outerTimestepCounter = new int[1];
                    }
                    this.outerValue[0] = 0.0;
                    this.outerTimestepCounter[0] = 0;
                    break;
                }
                case AVERAGE: {
                    if (this.outerValue == null) {
                        this.outerValue = new double[1];
                        this.outerTimestepCounter = new int[1];
                    }
                    this.outerValue[0] = 0.0;
                    this.outerTimestepCounter[0] = 0;
                    break;
                }
                case MINIMUM: {
                    if (this.outerValue == null) {
                        this.outerValue = new double[1];
                        this.outerTimestepCounter = new int[1];
                    }
                    this.outerValue[0] = Double.POSITIVE_INFINITY;
                    this.outerTimestepCounter[0] = 0;
                    break;
                }
                case MAXIMUM: {
                    if (this.outerValue == null) {
                        this.outerValue = new double[1];
                        this.outerTimestepCounter = new int[1];
                    }
                    this.outerValue[0] = Double.NEGATIVE_INFINITY;
                    this.outerTimestepCounter[0] = 0;
                    break;
                }
                case LAST: {
                    if (this.outerValue == null) {
                        this.outerValue = new double[1];
                        this.outerTimestepCounter = new int[1];
                    }
                    this.outerValue[0] = 0.0;
                    this.outerTimestepCounter[0] = 0;
                    break;
                }
                case INDEPENDENT: {
                    if (this.outerValue == null) {
                        if (innerTimePeriod == AggregationTimePeriod.DAILY) {
                            if (outerTimePeriod == AggregationTimePeriod.MONTHLY) {
                                this.outerValue = new double[31];
                                this.outerTimestepCounter = new int[31];
                                break;
                            }
                            this.outerTimestepCounter = new int[366];
                            this.outerValue = new double[366];
                            break;
                        }
                        if (innerTimePeriod == AggregationTimePeriod.SEASONAL) {
                            this.outerValue = new double[4];
                            this.outerTimestepCounter = new int[4];
                            break;
                        }
                        if (innerTimePeriod == AggregationTimePeriod.MONTHLY) {
                            this.outerValue = new double[12];
                            this.outerTimestepCounter = new int[12];
                            break;
                        }
                        if (innerTimePeriod == AggregationTimePeriod.YEARLY) {
                            int l = interval.getEnd().get(1) - interval.getStart().get(1);
                            this.outerValue = new double[l + 1];
                            this.outerTimestepCounter = new int[l + 1];
                            break;
                        }
                        TimePeriodAggregator.this.getModel().getRuntime().sendHalt("Error unsupported combination of aggregation options!");
                        break;
                    }
                    Arrays.fill(this.outerValue, 0.0);
                    Arrays.fill(this.outerTimestepCounter, 0);
                }
            }
        }

        public void considerData(double data, AggregationMode innerAggregationMode, AggregationTimePeriod innerTimePeriod, Attribute.Calendar time, Attribute.TimeInterval interval) {
            if (data == JAMS.getMissingDataValue()) {
                return;
            }
            switch (innerAggregationMode) {
                case AVERAGE: {
                    this.innerValue += data / TimePeriodAggregator.this.weight.getValue();
                    break;
                }
                case SUM: {
                    this.innerValue += data / TimePeriodAggregator.this.weight.getValue();
                    break;
                }
                case MINIMUM: {
                    this.innerValue = Math.min(data / TimePeriodAggregator.this.weight.getValue(), this.innerValue);
                    break;
                }
                case MAXIMUM: {
                    this.innerValue = Math.max(data / TimePeriodAggregator.this.weight.getValue(), this.innerValue);
                    break;
                }
                case LAST: {
                    this.innerValue = data / TimePeriodAggregator.this.weight.getValue();
                    this.innerTimestepCounter = 1;
                    return;
                }
            }
            this.innerTimestepCounter = (int)((double)this.innerTimestepCounter + 1.0);
        }

        public void transferInnerDataToOuterData(AggregationMode outerAggregationMode, AggregationTimePeriod outerTimePeriod, AggregationMode innerAggregationMode, AggregationTimePeriod innerTimePeriod, Attribute.Calendar time, Attribute.TimeInterval interval) {
            if (this.innerTimestepCounter == 0) {
                this.initInnerAggregatedValueArray(innerAggregationMode);
                return;
            }
            if (innerAggregationMode == AggregationMode.AVERAGE) {
                this.innerValue /= (double)this.innerTimestepCounter;
            }
            if (outerAggregationMode == AggregationMode.AVERAGE || outerAggregationMode == AggregationMode.SUM) {
                this.outerValue[0] = this.outerValue[0] + this.innerValue;
                this.outerTimestepCounter[0] = this.outerTimestepCounter[0] + 1;
            } else if (outerAggregationMode == AggregationMode.MAXIMUM) {
                this.outerValue[0] = Math.max(this.outerValue[0], this.innerValue);
                this.outerTimestepCounter[0] = this.outerTimestepCounter[0] + 1;
            } else if (outerAggregationMode == AggregationMode.MINIMUM) {
                this.outerValue[0] = Math.min(this.outerValue[0], this.innerValue);
                this.outerTimestepCounter[0] = this.outerTimestepCounter[0] + 1;
            } else if (outerAggregationMode == AggregationMode.INDEPENDENT) {
                if (innerTimePeriod == AggregationTimePeriod.DAILY) {
                    if (outerTimePeriod == AggregationTimePeriod.MONTHLY) {
                        int dayOfMonth = time.get(5);
                        int n = dayOfMonth - 1;
                        this.outerValue[n] = this.outerValue[n] + this.innerValue;
                        int n2 = dayOfMonth - 1;
                        this.outerTimestepCounter[n2] = this.outerTimestepCounter[n2] + 1;
                    } else {
                        int dayOfYear = time.get(6);
                        int n = dayOfYear - 1;
                        this.outerValue[n] = this.outerValue[n] + this.innerValue;
                        int n3 = dayOfYear - 1;
                        this.outerTimestepCounter[n3] = this.outerTimestepCounter[n3] + 1;
                    }
                } else if (innerTimePeriod == AggregationTimePeriod.SEASONAL) {
                    int month = time.get(2);
                    if (month < 2) {
                        this.outerValue[0] = this.outerValue[0] + this.innerValue;
                        this.outerTimestepCounter[0] = this.outerTimestepCounter[0] + 1;
                    } else if (month < 5) {
                        this.outerValue[1] = this.outerValue[1] + this.innerValue;
                        this.outerTimestepCounter[1] = this.outerTimestepCounter[1] + 1;
                    } else if (month < 8) {
                        this.outerValue[2] = this.outerValue[2] + this.innerValue;
                        this.outerTimestepCounter[2] = this.outerTimestepCounter[2] + 1;
                    } else if (month < 11) {
                        this.outerValue[3] = this.outerValue[3] + this.innerValue;
                        this.outerTimestepCounter[3] = this.outerTimestepCounter[3] + 1;
                    } else if (month < 12) {
                        this.outerValue[0] = this.outerValue[0] + this.innerValue;
                        this.outerTimestepCounter[0] = this.outerTimestepCounter[0] + 1;
                    }
                } else if (innerTimePeriod == AggregationTimePeriod.MONTHLY) {
                    int month;
                    int n = month = time.get(2);
                    this.outerValue[n] = this.outerValue[n] + this.innerValue;
                    int n4 = month;
                    this.outerTimestepCounter[n4] = this.outerTimestepCounter[n4] + 1;
                } else if (innerTimePeriod == AggregationTimePeriod.YEARLY) {
                    int l1 = interval.getStart().get(1);
                    int year = time.get(1);
                    int n = year - l1;
                    this.outerValue[n] = this.outerValue[n] + this.innerValue;
                    int n5 = year - l1;
                    this.outerTimestepCounter[n5] = this.outerTimestepCounter[n5] + 1;
                } else {
                    TimePeriodAggregator.this.getModel().getRuntime().sendHalt("Error unsupported combination of aggregation options!");
                }
            } else if (outerAggregationMode == AggregationMode.LAST) {
                this.outerValue[0] = this.innerValue;
                this.outerTimestepCounter[0] = 1;
            }
            this.initInnerAggregatedValueArray(innerAggregationMode);
        }
    }
}

