/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.time;

import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class UtcTimeUtilities {
    private static DateTimeFormatter withMinutesformatter = JGTConstants.utcDateFormatterYYYYMMDDHHMM;
    private static DateTimeFormatter withSecondsformatter = JGTConstants.utcDateFormatterYYYYMMDDHHMMSS;

    public static DateTime newDateTime() {
        DateTime dt = new DateTime().withZone(DateTimeZone.UTC);
        return dt;
    }

    public static DateTime fromStringWithSeconds(String dateTimeString) {
        DateTime dt = withSecondsformatter.parseDateTime(dateTimeString);
        return dt;
    }

    public static DateTime fromStringWithMinutes(String dateTimeString) {
        DateTime dt = withMinutesformatter.parseDateTime(dateTimeString);
        return dt;
    }

    public static String toStringWithSeconds(DateTime dateTime) {
        String dtStr = dateTime.toString(withSecondsformatter);
        return dtStr;
    }

    public static String toStringWithMinutes(DateTime dateTime) {
        String dtStr = dateTime.toString(withMinutesformatter);
        return dtStr;
    }
}

