/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.features;

import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class FeatureExtender {
    private SimpleFeatureType newFeatureType;

    public FeatureExtender(SimpleFeatureType oldFeatureType, String[] fieldArray, Class<?>[] classesArray) throws FactoryRegistryException, SchemaException {
        List oldAttributeDescriptors = oldFeatureType.getAttributeDescriptors();
        ArrayList<AttributeDescriptor> addedAttributeDescriptors = new ArrayList<AttributeDescriptor>();
        for (int i = 0; i < fieldArray.length; ++i) {
            AttributeTypeBuilder build = new AttributeTypeBuilder();
            build.setNillable(true);
            build.setBinding(classesArray[i]);
            AttributeDescriptor descriptor = build.buildDescriptor(fieldArray[i]);
            addedAttributeDescriptors.add(descriptor);
        }
        ArrayList<AttributeDescriptor> newAttributesTypesList = new ArrayList<AttributeDescriptor>();
        for (AttributeDescriptor attributeDescriptor : oldAttributeDescriptors) {
            newAttributesTypesList.add(attributeDescriptor);
        }
        newAttributesTypesList.addAll(addedAttributeDescriptors);
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(oldFeatureType.getName());
        b.setCRS(oldFeatureType.getCoordinateReferenceSystem());
        b.addAll(newAttributesTypesList);
        this.newFeatureType = b.buildFeatureType();
    }

    public SimpleFeatureType getNewFeatureType() {
        return this.newFeatureType;
    }

    public SimpleFeature extendFeature(SimpleFeature oldFeature, Object[] additionalAttributes) {
        Object[] attributes = oldFeature.getAttributes().toArray();
        Object[] newAttributes = new Object[attributes.length + additionalAttributes.length];
        System.arraycopy(attributes, 0, newAttributes, 0, attributes.length);
        for (int i = 0; i < additionalAttributes.length; ++i) {
            newAttributes[attributes.length + i] = additionalAttributes[i];
        }
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.newFeatureType);
        builder.addAll(newAttributes);
        SimpleFeature f = builder.buildFeature(null);
        return f;
    }
}

