/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.colors;

import org.geotools.coverage.grid.GridCoverage2D;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.modules.r.summary.OmsRasterSummary;
import org.jgrasstools.gears.utils.colors.ColorTables;
import org.jgrasstools.gears.utils.colors.RasterStyleUtilities;

public class RasterStyle {
    private double min;
    private double max;
    private double alpha = 1.0;

    public RasterStyle() {
    }

    public RasterStyle(GridCoverage2D raster) throws Exception {
        OmsRasterSummary summary = new OmsRasterSummary();
        summary.inRaster = raster;
        summary.process();
        this.min = summary.outMin;
        this.max = summary.outMax;
    }

    public RasterStyle(int min, int max) throws Exception {
        this.min = min;
        this.max = max;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public String style(String colorTableName) throws Exception {
        String createStyleForColortable = RasterStyleUtilities.createStyleForColortable(colorTableName, this.min, this.max, null, this.alpha);
        if (createStyleForColortable != null) {
            return createStyleForColortable;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("The colortable ");
        sb.append(colorTableName);
        sb.append(" could not be found in the default colortables.\n");
        sb.append("Available colortables are:\n");
        for (ColorTables colorTable : ColorTables.values()) {
            sb.append("\t");
            sb.append(colorTable.name());
            sb.append("\n");
        }
        throw new ModelsIllegalargumentException(sb.toString(), this);
    }
}

