/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.spatialite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class SpatialiteTableNames {
    public static final String USERDATA = "User Data";
    public static final String SPATIALINDEX = "Spatial Index";
    public static final String spatialIndex = "SpatialIndex";
    public static final String startsWithIndexTables = "idx_";
    public static final String STYLE = "Styling (SLD/SE)";
    public static final String startsWithStyleTables = "SE_";
    public static final String METADATA = "Metadata";
    public static final List<String> metadataTables = Arrays.asList("geom_cols_ref_sys", "geometry_columns", "geometry_columns_time", "raster_coverages", "raster_coverages_keyword", "raster_coverages_ref_sys", "raster_coverages_srid", "spatial_ref_sys", "spatial_ref_sys_all", "spatial_ref_sys_aux", "spatialite_history", "vector_coverages", "vector_coverages_keyword", "vector_coverages_ref_sys", "vector_coverages_srid", "vector_layers", "views_geometry_columns", "virts_geometry_columns");
    public static final String INTERNALDATA = "Internal Data";
    public static final List<String> internalDataTables = Arrays.asList("ElementaryGeometries", "geometry_columns_auth", "geometry_columns_field_infos", "geometry_columns_statistics", "sql_statements_log", "sqlite_sequence", "vector_layers_auth", "vector_layers_field_infos", "vector_layers_statistics", "views_geometry_columns_auth", "views_geometry_columns_field_infos", "views_geometry_columns_statistics", "virts_geometry_columns_auth", "virts_geometry_columns_field_infos", "virts_geometry_columns_statistics");
    public static final List<String> ALL_TYPES_LIST = Arrays.asList("User Data", "Spatial Index", "Styling (SLD/SE)", "Metadata", "Internal Data");

    public static LinkedHashMap<String, List<String>> getTablesSorted(List<String> allTableNames, boolean doSort) {
        LinkedHashMap<String, List<String>> tablesMap = new LinkedHashMap<String, List<String>>();
        tablesMap.put(USERDATA, new ArrayList());
        tablesMap.put(STYLE, new ArrayList());
        tablesMap.put(METADATA, new ArrayList());
        tablesMap.put(INTERNALDATA, new ArrayList());
        tablesMap.put(SPATIALINDEX, new ArrayList());
        for (String tableName : allTableNames) {
            List<String> list;
            if (tableName.equals(spatialIndex) || tableName.startsWith(startsWithIndexTables)) {
                list = tablesMap.get(SPATIALINDEX);
                list.add(tableName);
                continue;
            }
            if (tableName.startsWith(startsWithStyleTables)) {
                list = tablesMap.get(STYLE);
                list.add(tableName);
                continue;
            }
            if (metadataTables.contains(tableName)) {
                list = tablesMap.get(METADATA);
                list.add(tableName);
                continue;
            }
            if (internalDataTables.contains(tableName)) {
                list = tablesMap.get(INTERNALDATA);
                list.add(tableName);
                continue;
            }
            list = tablesMap.get(USERDATA);
            list.add(tableName);
        }
        if (doSort) {
            for (List values : tablesMap.values()) {
                Collections.sort(values);
            }
        }
        return tablesMap;
    }
}

