/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.triangulation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.triangulate.DelaunayTriangulationBuilder;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Creates a Delaunay triangulation from a set of points.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="vector, delaunay, triangulation")
@Label(value="Vector Processing")
@Name(value="_delaunaytriangulation")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsDelaunayTriangulation
extends JGTModel {
    @Description(value="The input points map.")
    @In
    public SimpleFeatureCollection inMap = null;
    @Description(value="The optional name of the field containing the elevation value.")
    @In
    public String fElev = "elev";
    @Description(value="The output triangles map.")
    @Out
    public SimpleFeatureCollection outMap = null;
    public static final String NAME = "delaunaytriangulation";
    public static final String KEYWORDS = "vector, delaunay, triangulation";
    public static final String DESCRIPTION = "Creates a Delaunay triangulation from a set of points.";
    public static final String outMap_DESCR = "The output triangles map.";
    public static final String fElev_DESCR = "The optional name of the field containing the elevation value.";
    public static final String inMap_DESCR = "The input points map.";

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inMap);
        if (!GeometryUtilities.isPoint(((SimpleFeatureType)this.inMap.getSchema()).getGeometryDescriptor())) {
            throw new ModelsIllegalargumentException("The input geometry needs to be points.", this, this.pm);
        }
        if (this.fElev != null) {
            this.fElev = FeatureUtilities.findAttributeName((SimpleFeatureType)this.inMap.getSchema(), this.fElev);
            if (this.fElev == null) {
                throw new ModelsIllegalargumentException("Couldn't find field: " + this.fElev, this);
            }
        }
        CoordinateReferenceSystem crs = this.inMap.getBounds().getCoordinateReferenceSystem();
        List<SimpleFeature> fList = FeatureUtilities.featureCollectionToList(this.inMap);
        this.pm.beginTask("Processing...", fList.size());
        DelaunayTriangulationBuilder b = new DelaunayTriangulationBuilder();
        ArrayList<Coordinate> cList = new ArrayList<Coordinate>();
        for (SimpleFeature f : fList) {
            Geometry geometry = (Geometry)f.getDefaultGeometry();
            double elev = 0.0;
            if (this.fElev != null) {
                elev = (Double)f.getAttribute(this.fElev);
            }
            Coordinate c = geometry.getCoordinate();
            c.z = elev;
            cList.add(c);
            this.pm.worked(1);
        }
        this.pm.done();
        b.setSites(cList);
        ArrayList<Geometry> geosList = new ArrayList<Geometry>();
        Geometry triangles = b.getTriangles(this.gf);
        for (int i = 0; i < triangles.getNumGeometries(); ++i) {
            Geometry geometryN = triangles.getGeometryN(i);
            Coordinate[] coordinates = geometryN.getCoordinates();
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (Coordinate coordinate : coordinates) {
                min = Math.min(min, coordinate.z);
                max = Math.max(max, coordinate.z);
            }
            geometryN.setUserData((Object)new String[]{"" + min, "" + max});
            geosList.add(geometryN);
        }
        this.outMap = FeatureUtilities.featureCollectionFromGeometry(crs, geosList.toArray(new Geometry[0]));
    }
}

