/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.rangelookup;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.HashMap;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.jaitools.media.jai.rangelookup.RangeLookupTable;
import org.jaitools.numeric.Range;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;

@Description(value="Module for raster rangelookup.")
@Documentation(value="OmsRangeLookup.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Rangelookup")
@Label(value="Raster Processing")
@Name(value="rrangelookup")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRangeLookup
extends JGTModel {
    @Description(value="The raster that has to be processed.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The ranges in the form [r1l r1h),[r2l r2h]")
    @In
    public String pRanges;
    @Description(value="The classes to substitute in the same order of the ranges (in the form 1,2)")
    @In
    public String pClasses;
    @Description(value="The processed raster.")
    @Out
    public GridCoverage2D outRaster = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        this.checkNull(this.inRaster, this.pRanges, this.pClasses);
        RenderedImage inRI = this.inRaster.getRenderedImage();
        RangeLookupTable.Builder builder = new RangeLookupTable.Builder();
        String[] rangesSplit = this.pRanges.trim().split(",");
        String[] classesSplit = this.pClasses.trim().split(",");
        if (rangesSplit.length != classesSplit.length) {
            throw new ModelsIllegalargumentException("Ranges and classes must be in pairs!", this, this.pm);
        }
        for (int i = 0; i < rangesSplit.length; ++i) {
            String classStr = classesSplit[i].trim();
            double classNum = Double.parseDouble(classStr);
            String range = rangesSplit[i].trim();
            boolean minIncluded = false;
            boolean maxIncluded = false;
            if (range.startsWith("[")) {
                minIncluded = true;
            }
            if (range.endsWith("]")) {
                maxIncluded = true;
            }
            String rangeNoBrac = range.replaceAll("\\[|\\]|\\(|\\)", "");
            String[] split = rangeNoBrac.trim().split("\\s+");
            Double min = null;
            try {
                min = Double.parseDouble(split[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Double max = null;
            try {
                max = Double.parseDouble(split[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Range r = new Range((Number)min, minIncluded, (Number)max, maxIncluded);
            builder.add(r, (Number)classNum);
        }
        RangeLookupTable table = builder.build();
        ParameterBlockJAI pb = new ParameterBlockJAI("RangeLookup");
        pb.setSource("source0", (Object)inRI);
        pb.setParameter("table", (Object)table);
        pb.setParameter("default", Double.NaN);
        RenderedOp lookupImg = JAI.create((String)"RangeLookup", (ParameterBlock)pb);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        this.outRaster = CoverageUtilities.buildCoverage("rangelookup", (RenderedImage)lookupImg, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
    }
}

