/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.converters;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;

@Description(value="Utility class for converting from 'id1 value1[]' to 'id1 value1' by averaging.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Reading")
@Label(value="Others")
@Name(value="valuesarray2idvaluesconverter")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
@UI(value="hide")
public class IdValuesArray2IdValuesConverter
extends JGTModel {
    @Description(value="Input data.")
    @In
    public HashMap<Integer, double[]> inData;
    @Description(value="Output data.")
    @Out
    public HashMap<Integer, Double> outData;

    @Execute
    public void convert() throws IOException {
        if (this.outData == null) {
            this.outData = new HashMap();
        }
        Set<Map.Entry<Integer, double[]>> entries = this.inData.entrySet();
        for (Map.Entry<Integer, double[]> entry : entries) {
            Integer id = entry.getKey();
            double[] value = entry.getValue();
            double avg = 0.0;
            int num = 0;
            for (double d : value) {
                if (JGTConstants.isNovalue(d)) continue;
                avg += d;
                ++num;
            }
            this.outData.put(id, avg /= (double)num);
        }
    }
}

