/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="NashCascade", author="Peter Krause", description="Description")
public class NashCascade
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="number of tanks")
    public Attribute.Integer nTanks;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="recision coefficient k for all tanks")
    public Attribute.Double k;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="input to the first tank in the cascade")
    public Attribute.Double input;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="the tanks itself")
    public Attribute.DoubleArray storages;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="outflow from the last tank in the cascade")
    public Attribute.Double output;

    public void init() {
        double[] tanks = new double[this.nTanks.getValue()];
        for (int i = 0; i < this.nTanks.getValue(); ++i) {
            tanks[i] = 0.0;
        }
        this.storages.setValue(tanks);
    }

    public void run() {
        double[] tanks = this.storages.getValue();
        double[] outflow = new double[tanks.length];
        double rec = this.k.getValue();
        tanks[0] = tanks[0] + this.input.getValue();
        for (int i = 0; i < this.nTanks.getValue(); ++i) {
            outflow[i] = 1.0 / rec * tanks[i];
            tanks[i] = tanks[i] - outflow[i];
            if (i >= this.nTanks.getValue() - 1) continue;
            tanks[i + 1] = tanks[i + 1] + outflow[i];
        }
        this.output.setValue(outflow[this.nTanks.getValue() - 1]);
        this.storages.setValue(tanks);
    }

    public void cleanup() {
    }
}

