/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;

public class AssignClimateGridCell
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="EntitySet of modelling units")
    public Attribute.EntityCollection entitySet;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of numerical GRID cell ids", defaultValue="")
    public Attribute.DoubleArray statId;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Column of first data value", defaultValue="gridcellID")
    public Attribute.String gridCellColumnName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Column of first data value", defaultValue="gridcellID")
    public Attribute.String gridCellAttributeName;

    public void init() {
        System.out.println("init in ACGC");
        double[] sid = this.statId.getValue();
        for (Attribute.Entity e : this.entitySet.getEntities()) {
            boolean notFound = true;
            int idx = 0;
            try {
                double gc = e.getDouble(this.gridCellColumnName.getValue());
                while (notFound) {
                    if (gc == sid[idx]) {
                        notFound = false;
                        e.setInt(this.gridCellAttributeName.getValue(), idx + 1);
                    }
                    ++idx;
                }
            }
            catch (Attribute.Entity.NoSuchAttributeException noSuchAttributeException) {
            }
        }
    }

    public void run() {
        System.out.println("run in ACGC");
    }

    public void cleanup() {
    }
}

