/*
 * Decompiled with CFR 0.152.
 */
package oms3;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oms3.ComponentException;
import oms3.ConversionProvider;
import oms3.Converter;

public class Conversions {
    private static ServiceLoader<ConversionProvider> convServices = ServiceLoader.load(ConversionProvider.class);
    static final char LB = '{';
    static final char RB = '}';
    static final char SEP = ',';
    static final Pattern pattern = Pattern.compile("(\\w+)\\s*(\\[[0-9]+\\])*?");
    static final Pattern splitP = Pattern.compile(Character.toString(','));
    public static boolean debug = false;
    private static final String[] fmt = new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd hh:mm", "yyyy-MM-dd hh:mm:ss", "yyyy-MM-dd", "MM-dd-yyyy", "MM/dd/yyyy", "dd.MM.yyyy", "yyyy.MM.dd", "yyyy MM dd H m s"};
    private static Map<String, Converter> co = new HashMap<String, Converter>(){
        {
            this.put(Conversions.key(String.class, String.class), new Converter<String, String>(){

                @Override
                public String convert(String s, Object arg) {
                    return s;
                }
            });
            this.put(Conversions.key(BigDecimal.class, Double.class), new Converter<BigDecimal, Double>(){

                @Override
                public Double convert(BigDecimal s, Object arg) {
                    return s.doubleValue();
                }
            });
            this.put(Conversions.key(Integer.class, Double.class), new Converter<Integer, Double>(){

                @Override
                public Double convert(Integer s, Object arg) {
                    return s.doubleValue();
                }
            });
            this.put(Conversions.key(double[].class, String.class), new Converter<double[], String>(){

                @Override
                public String convert(double[] s, Object arg) {
                    StringBuilder b = new StringBuilder("{");
                    if (s.length > 0) {
                        for (int i = 0; i < s.length - 1; ++i) {
                            b.append(s[i] + ", ");
                        }
                        b.append(s[s.length - 1]);
                    }
                    b.append("}");
                    return b.toString();
                }
            });
            this.put(Conversions.key(Double[].class, double[].class), new Converter<Double[], double[]>(){

                @Override
                public double[] convert(Double[] s, Object arg) {
                    double[] d = new double[s.length];
                    for (int i = 0; i < s.length; ++i) {
                        d[i] = s[i];
                    }
                    return d;
                }
            });
            this.put(Conversions.key(double[][].class, String.class), new Converter<double[][], String>(){

                @Override
                public String convert(double[][] s, Object arg) {
                    StringBuilder b = new StringBuilder("{");
                    if (s.length > 0) {
                        for (int i = 0; i < s.length - 1; ++i) {
                            b.append(Conversions.convert(s[i], String.class) + ", ");
                        }
                        b.append(Conversions.convert(s[s.length - 1], String.class));
                    }
                    b.append("}");
                    return b.toString();
                }
            });
            this.put(Conversions.key(int[].class, String.class), new Converter<int[], String>(){

                @Override
                public String convert(int[] s, Object arg) {
                    StringBuilder b = new StringBuilder("{");
                    if (s.length > 0) {
                        for (int i = 0; i < s.length - 1; ++i) {
                            b.append(s[i] + ", ");
                        }
                        b.append(s[s.length - 1]);
                    }
                    b.append("}");
                    return b.toString();
                }
            });
            this.put(Conversions.key(int[][].class, String.class), new Converter<int[][], String>(){

                @Override
                public String convert(int[][] s, Object arg) {
                    StringBuilder b = new StringBuilder("{");
                    if (s.length > 0) {
                        for (int i = 0; i < s.length - 1; ++i) {
                            b.append(Conversions.convert(s[i], String.class) + ", ");
                        }
                        b.append(Conversions.convert(s[s.length - 1], String.class));
                    }
                    b.append("}");
                    return b.toString();
                }
            });
            this.put(Conversions.key(int[].class, double[].class), new Converter<int[], double[]>(){

                @Override
                public double[] convert(int[] s, Object arg) {
                    double[] out = new double[s.length];
                    for (int i = 0; i < s.length; ++i) {
                        out[i] = s[i];
                    }
                    return out;
                }
            });
            this.put(Conversions.key(double[].class, int[].class), new Converter<double[], int[]>(){

                @Override
                public int[] convert(double[] s, Object arg) {
                    int[] out = new int[s.length];
                    for (int i = 0; i < s.length; ++i) {
                        out[i] = (int)s[i];
                    }
                    return out;
                }
            });
            this.put(Conversions.key(String.class, URL.class), new Converter<String, URL>(){

                @Override
                public URL convert(String s, Object arg) {
                    try {
                        return new URL(s);
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalArgumentException(s, ex);
                    }
                }
            });
            this.put(Conversions.key(String.class, File.class), new Converter<String, File>(){

                @Override
                public File convert(String s, Object arg) {
                    return new File(s);
                }
            });
            this.put(Conversions.key(String.class, Date.class), new Converter<String, Date>(){

                @Override
                public Date convert(String s, Object arg) {
                    if (arg instanceof DateFormat) {
                        try {
                            return ((DateFormat)arg).parse(s);
                        }
                        catch (ParseException E) {
                            throw new RuntimeException(E);
                        }
                    }
                    return Conversions.parse(s);
                }
            });
            this.put(Conversions.key(String.class, Calendar.class), new Converter<String, Calendar>(){

                @Override
                public Calendar convert(String s, Object arg) {
                    Date d = null;
                    if (arg instanceof DateFormat) {
                        try {
                            d = ((DateFormat)arg).parse(s);
                        }
                        catch (ParseException E) {
                            throw new RuntimeException(E);
                        }
                    } else {
                        d = Conversions.parse(s);
                    }
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(d);
                    return cal;
                }
            });
            this.put(Conversions.key(GregorianCalendar.class, String.class), new Converter<GregorianCalendar, String>(){

                @Override
                public String convert(GregorianCalendar s, Object arg) {
                    if (arg instanceof DateFormat) {
                        return ((DateFormat)arg).format(s.getTime());
                    }
                    return Conversions.ISO().format(s.getTime());
                }
            });
            this.put(Conversions.key(Double.class, String.class), new Converter<Double, String>(){

                @Override
                public String convert(Double s, Object arg) {
                    if (arg instanceof NumberFormat) {
                        NumberFormat nf = (NumberFormat)arg;
                        return nf.format(s);
                    }
                    return s.toString();
                }
            });
            this.put(Conversions.key(Float.class, String.class), new Converter<Float, String>(){

                @Override
                public String convert(Float s, Object arg) {
                    if (arg instanceof NumberFormat) {
                        NumberFormat nf = (NumberFormat)arg;
                        return nf.format(s);
                    }
                    return s.toString();
                }
            });
            this.put(Conversions.key(Integer.class, String.class), new Converter<Integer, String>(){

                @Override
                public String convert(Integer s, Object arg) {
                    return s.toString();
                }
            });
            this.put(Conversions.key(String.class, BigDecimal.class), new Converter<String, BigDecimal>(){

                @Override
                public BigDecimal convert(String s, Object arg) {
                    return new BigDecimal(s.trim());
                }
            });
            this.put(Conversions.key(String.class, Double.TYPE), new Converter<String, Double>(){

                @Override
                public Double convert(String s, Object arg) {
                    return Double.parseDouble(s.trim());
                }
            });
            this.put(Conversions.key(String.class, Double.class), (Converter)this.get(Conversions.key(String.class, Double.TYPE)));
            this.put(Conversions.key(String.class, Float.TYPE), new Converter<String, Float>(){

                @Override
                public Float convert(String s, Object arg) {
                    return Float.valueOf(Float.parseFloat(s.trim()));
                }
            });
            this.put(Conversions.key(String.class, Float.class), (Converter)this.get(Conversions.key(String.class, Float.TYPE)));
            this.put(Conversions.key(String.class, Long.TYPE), new Converter<String, Long>(){

                @Override
                public Long convert(String s, Object arg) {
                    return Long.parseLong(s.trim());
                }
            });
            this.put(Conversions.key(String.class, Long.class), (Converter)this.get(Conversions.key(String.class, Long.TYPE)));
            this.put(Conversions.key(String.class, Integer.TYPE), new Converter<String, Integer>(){

                @Override
                public Integer convert(String s, Object arg) {
                    return Integer.parseInt(s.trim());
                }
            });
            this.put(Conversions.key(String.class, Integer.class), (Converter)this.get(Conversions.key(String.class, Integer.TYPE)));
            this.put(Conversions.key(String.class, Short.TYPE), new Converter<String, Short>(){

                @Override
                public Short convert(String s, Object arg) {
                    return Short.parseShort(s.trim());
                }
            });
            this.put(Conversions.key(String.class, Short.class), (Converter)this.get(Conversions.key(String.class, Short.TYPE)));
            this.put(Conversions.key(String.class, Byte.TYPE), new Converter<String, Byte>(){

                @Override
                public Byte convert(String s, Object arg) {
                    return Byte.parseByte(s.trim());
                }
            });
            this.put(Conversions.key(String.class, Byte.class), (Converter)this.get(Conversions.key(String.class, Byte.TYPE)));
            this.put(Conversions.key(Boolean.TYPE, String.class), new Converter<Boolean, String>(){

                @Override
                public String convert(Boolean s, Object arg) {
                    return s.toString();
                }
            });
            this.put(Conversions.key(Boolean.class, String.class), (Converter)this.get(Conversions.key(Boolean.TYPE, String.class)));
            this.put(Conversions.key(String.class, Boolean.TYPE), new Converter<String, Boolean>(){

                @Override
                public Boolean convert(String s, Object arg) {
                    return Boolean.parseBoolean(s.trim());
                }
            });
            this.put(Conversions.key(String.class, Boolean.class), (Converter)this.get(Conversions.key(String.class, Boolean.TYPE)));
            this.put(Conversions.key(String.class, Character.TYPE), new Converter<String, Character>(){

                @Override
                public Character convert(String s, Object arg) {
                    return Character.valueOf(s.trim().charAt(0));
                }
            });
            this.put(Conversions.key(String.class, Character.class), (Converter)this.get(Conversions.key(String.class, Character.TYPE)));
            this.put(Conversions.key(Integer.class, Integer.TYPE), new Converter<Integer, Integer>(){

                @Override
                public Integer convert(Integer s, Object arg) {
                    return s;
                }
            });
            this.put(Conversions.key(Double.class, Double.TYPE), new Converter<Double, Double>(){

                @Override
                public Double convert(Double s, Object arg) {
                    return s;
                }
            });
            this.put(Conversions.key(Float.class, Float.TYPE), new Converter<Float, Float>(){

                @Override
                public Float convert(Float s, Object arg) {
                    return s;
                }
            });
            this.put(Conversions.key(Boolean.class, Boolean.TYPE), new Converter<Boolean, Boolean>(){

                @Override
                public Boolean convert(Boolean s, Object arg) {
                    return s;
                }
            });
        }

        @Override
        public Converter put(String key, Converter value) {
            Converter v = super.put(key, value);
            if (v != null) {
                throw new IllegalArgumentException("Duplicate Converter for " + key);
            }
            return v;
        }
    };

    public static boolean canConvert(Class<?> from, Class<?> to) {
        if (from == String.class && to.isArray()) {
            return true;
        }
        Converter c = co.get(Conversions.key(from, to));
        return c != null || (c = Conversions.lookupConversionService(from, to)) != null;
    }

    public static <T> T convert(Object from, Class<? extends T> to, Object arg) {
        Params p = new Params();
        p.add(from.getClass(), to, arg);
        return Conversions.convert(from, to, p);
    }

    public static <T> T convert(Object from, Class<? extends T> to, Params arg) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        if (to == null) {
            throw new NullPointerException("to");
        }
        if (from.getClass() == String.class && to.isArray()) {
            return new ArrayConverter((String)from).getArrayForType(to);
        }
        Converter<Object, T> c = co.get(Conversions.key(from.getClass(), to));
        if (c == null) {
            c = Conversions.lookupConversionService(from.getClass(), to);
            if (c == null) {
                throw new ComponentException("No Converter: " + from + " (" + from.getClass() + ") -> " + to);
            }
            co.put(Conversions.key(from.getClass(), to), c);
        }
        Object param = null;
        if (arg != null) {
            param = arg.get(from.getClass(), to);
        }
        return c.convert(from, param);
    }

    public static <T> T convert(Object from, Class<? extends T> to) {
        return Conversions.convert(from, to, null);
    }

    private static <T> Converter<Object, T> lookupConversionService(Class from, Class to) {
        for (ConversionProvider converter : convServices) {
            Converter<?, ?> c = converter.getConverter(from, to);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public static String[] parseArrayElement(String src) {
        Matcher matcher = pattern.matcher(src.trim());
        ArrayList<String> a = new ArrayList<String>();
        while (matcher.find()) {
            a.add(matcher.group(0));
        }
        return a.toArray(new String[0]);
    }

    private static Class getArrayBaseType(Class array) {
        while (array.isArray()) {
            array = array.getComponentType();
        }
        return array;
    }

    public static String formatISO(Date date) {
        return Conversions.ISO().format(date);
    }

    public static SimpleDateFormat ISO() {
        return new SimpleDateFormat(fmt[3]);
    }

    private static Date parse(String date) {
        for (int i = 0; i < fmt.length; ++i) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(fmt[i]);
                return df.parse(date);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        throw new IllegalArgumentException(date);
    }

    private static final String key(Class from, Class to) {
        return from.getName() + "->" + to.getName();
    }

    public static double[] rollDoubleArray(double[][] in) {
        int cols = in[0].length;
        int rows = in.length;
        int index = 0;
        double[] out = new double[rows * cols];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                out[index++] = in[row][col];
            }
        }
        return out;
    }

    public static double[][] unrollDoubleArray(double[] in, int rows) {
        int cols = in.length / rows;
        int index = 0;
        double[][] out = new double[rows][cols];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                out[row][col] = in[index++];
            }
        }
        return out;
    }

    public static void main(String[] args) throws ParseException {
        String t = "t[][]";
        System.out.println(Arrays.toString(Conversions.parseArrayElement(t)));
        double a = 1231.2345672828287;
        System.out.println(String.format(Locale.US, "'%2.5f'", a));
        System.out.print(co.keySet());
        String b = "{333.345, 12.42}";
        double[] arr = Conversions.convert(b, double[].class);
        System.out.println(Arrays.toString(arr));
    }

    static class ArrayConverter {
        String[] content;
        String layout;
        int[] dims = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

        private int count(String s, char c) {
            int count = 0;
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                if (s.charAt(i) != c) continue;
                ++count;
            }
            return count;
        }

        ArrayConverter(String text) {
            text = text.trim();
            if (this.count(text, '}') != this.count(text, '}')) {
                throw new IllegalArgumentException("Brackets mismatch.");
            }
            if (debug) {
                System.out.println(text);
            }
            String mass = text.replace('{', ' ').replace('}', ' ').trim();
            this.content = splitP.split(mass);
            if (debug) {
                System.out.println(mass.isEmpty());
                System.out.println("content " + Arrays.toString(this.content));
            }
            this.layout = this.changed(text, mass.isEmpty() ? 0 : this.content.length);
            if (debug) {
                System.out.println("layout " + this.layout);
            }
            this.parseDims(this.layout);
        }

        private String changed(String inp, int len) {
            StringBuilder c = new StringBuilder();
            int count = 0;
            boolean b = false;
            boolean first = true;
            block4: for (int i = 0; i < inp.length(); ++i) {
                char ch = inp.charAt(i);
                switch (ch) {
                    case ' ': {
                        continue block4;
                    }
                    case ',': 
                    case '{': 
                    case '}': {
                        first = true;
                        c.append(ch);
                        continue block4;
                    }
                    default: {
                        if (!first) continue block4;
                        c.append(count++);
                        first = false;
                    }
                }
            }
            if (count != len) {
                throw new IllegalArgumentException(count + "!=" + len);
            }
            return c.toString();
        }

        private Class[] types(int[] dims, Class basetype) {
            int i = 0;
            while (dims[i] > -1) {
                ++i;
            }
            if (debug) {
                System.out.println(" rank " + i);
            }
            Object[] c = new Class[i];
            c[i - 1] = basetype;
            while (--i > 0) {
                c[i - 1] = Array.newInstance(c[i], 0).getClass();
            }
            if (debug) {
                System.out.println("Types " + Arrays.toString(c));
            }
            return c;
        }

        private void parseDims(String layout) {
            int level = -1;
            block5: for (int i = 0; i < layout.length(); ++i) {
                char c = layout.charAt(i);
                switch (c) {
                    case '{': {
                        if (level == this.dims.length - 1) {
                            throw new UnsupportedOperationException("Can only handle arrays with length " + this.dims.length);
                        }
                        if (i > 0 && layout.charAt(i - 1) == '{') {
                            int n = level;
                            this.dims[n] = this.dims[n] + 1;
                        }
                        this.dims[++level] = 0;
                        continue block5;
                    }
                    case '}': {
                        --level;
                        continue block5;
                    }
                    case ',': {
                        int n = level;
                        this.dims[n] = this.dims[n] + 1;
                        continue block5;
                    }
                    default: {
                        if (this.dims[level] != 0) continue block5;
                        int n = level;
                        this.dims[n] = this.dims[n] + 1;
                    }
                }
            }
            if (debug) {
                System.out.println("dims :" + Arrays.toString(this.dims));
            }
        }

        <T> T getArrayForType(Class<? extends T> type) {
            if (!type.isArray()) {
                throw new IllegalArgumentException("Not an array type");
            }
            Class cType = Conversions.getArrayBaseType(type);
            Object o = new Parser((Converter)co.get(Conversions.key(String.class, cType))).parse(0, this.layout, this.types(this.dims, cType));
            if (o.getClass() != type) {
                throw new RuntimeException(o.getClass() + "!=" + type);
            }
            return (T)o;
        }

        private class Parser {
            int idx = 1;
            Converter converter;

            Parser(Converter converter) {
                if (converter == null) {
                    throw new RuntimeException("cannot convert.");
                }
                this.converter = converter;
            }

            Object parse(int level, String layout, Class[] cc) {
                int arridx = 0;
                Object arr = Array.newInstance(cc[level], ArrayConverter.this.dims[level]);
                while (this.idx < layout.length()) {
                    char c = layout.charAt(this.idx);
                    switch (c) {
                        case '{': {
                            ++this.idx;
                            Object elem = this.parse(level + 1, layout, cc);
                            System.out.flush();
                            Array.set(arr, arridx, elem);
                            break;
                        }
                        case '}': {
                            return arr;
                        }
                        case ',': {
                            ++arridx;
                            break;
                        }
                        default: {
                            int index = 0;
                            while (Character.isDigit(layout.charAt(this.idx))) {
                                index = index * 10 + (layout.charAt(this.idx++) - 48);
                            }
                            --this.idx;
                            Object o = this.converter.convert(ArrayConverter.this.content[index], null);
                            try {
                                Array.set(arr, arridx, o);
                                break;
                            }
                            catch (IllegalArgumentException E) {
                                System.out.println(arr.getClass() + " element " + arridx + " " + o + " " + o.getClass());
                                throw E;
                            }
                        }
                    }
                    ++this.idx;
                }
                return arr;
            }
        }
    }

    public static class Params {
        HashMap<String, Object> arg = new HashMap();

        public void add(Class from, Class to, Object par) {
            this.arg.put(Conversions.key(from, to), par);
        }

        public Object get(Class from, Class to) {
            return this.arg.get(Conversions.key(from, to));
        }
    }
}

