/*
 * Decompiled with CFR 0.152.
 */
package oms3;

import oms3.ComponentException;
import oms3.Controller;
import oms3.Notification;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.Initialize;

public class Compound {
    private final Controller controller = new Controller(this);

    @Initialize
    public void initializeComponents() {
        this.controller.callAnnotated(Initialize.class, true);
    }

    @Execute
    public void execute() throws ComponentException {
        this.check();
        this.internalExec();
    }

    @Finalize
    public void finalizeComponents() {
        this.controller.callAnnotated(Finalize.class, true);
    }

    public void out2infb(Object from, String from_out, Object to, String to_in) {
        this.controller.connect(from, from_out, to, to_in);
    }

    public void out2in(Object from, String from_out, Object to, String to_in) {
        this.controller.connect(from, from_out, to, to_in);
    }

    public void out2in(Object from, String from_out, Object ... tos) {
        for (Object co : tos) {
            this.out2in(from, from_out, co, from_out);
        }
    }

    public void feedback(Object from, String from_out, Object to, String to_in) {
        this.controller.feedback(from, from_out, to, to_in);
    }

    public void feedback(Object from, String from_out, Object ... tos) {
        for (Object co : tos) {
            this.feedback(from, from_out, co, from_out);
        }
    }

    public void in2in(String in, Object to, String to_in) {
        this.controller.mapIn(in, to, to_in);
    }

    public void in2in(String in, Object ... to) {
        for (Object cmd : to) {
            this.in2in(in, cmd, in);
        }
    }

    public void field2inout(Object o, String field, Object comp, String inout) {
        this.controller.mapInField(o, field, comp, inout);
        this.controller.mapOutField(comp, inout, o, field);
    }

    public void field2inout(Object o, String field, Object comp) {
        this.field2inout(o, field, comp, field);
    }

    public void field2in(Object o, String field, Object to, String to_in) {
        this.controller.mapInField(o, field, to, to_in);
    }

    public void field2in(Object o, String field, Object to) {
        if ((field = field.trim()).indexOf(32) > 0) {
            String[] fields;
            for (String f : fields = field.split("\\s+")) {
                this.field2in(o, f, to, f);
            }
        } else {
            this.field2in(o, field, to, field);
        }
    }

    public void out2field(Object from, String from_out, Object o, String field) {
        this.controller.mapOutField(from, from_out, o, field);
    }

    public void out2field(Object from, String from_out, Object o) {
        this.out2field(from, from_out, o, from_out);
    }

    public void out2out(String out, Object to, String to_out) {
        this.controller.mapOut(out, to, to_out);
    }

    public void out2out(String out, Object to) {
        this.out2out(out, to, out);
    }

    public void val2in(boolean val, Object to, String field) {
        this.controller.mapInVal(val, to, field);
    }

    public void val2in(char val, Object to, String field) {
        this.controller.mapInVal(new Character(val), to, field);
    }

    public void val2in(byte val, Object to, String field) {
        this.controller.mapInVal(new Byte(val), to, field);
    }

    public void val2in(short val, Object to, String field) {
        this.controller.mapInVal(new Short(val), to, field);
    }

    public void val2in(int val, Object to, String field) {
        this.controller.mapInVal(new Integer(val), to, field);
    }

    public void val2in(long val, Object to, String field) {
        this.controller.mapInVal(new Long(val), to, field);
    }

    public void val2in(float val, Object to, String field) {
        this.controller.mapInVal(new Float(val), to, field);
    }

    public void val2in(double val, Object to, String field) {
        this.controller.mapInVal(new Double(val), to, field);
    }

    public void val2in(Object val, Object to, String field) {
        this.controller.mapInVal(val, to, field);
    }

    @Deprecated
    public void connect(Object from, String from_out, Object to, String to_in) {
        this.controller.connect(from, from_out, to, to_in);
    }

    @Deprecated
    public void connect(Object from, String from_out, Object ... tos) {
        for (Object co : tos) {
            this.connect(from, from_out, co, from_out);
        }
    }

    @Deprecated
    public void mapIn(String in, Object to, String to_in) {
        this.controller.mapIn(in, to, to_in);
    }

    @Deprecated
    public void mapIn(String in, Object ... to) {
        for (Object cmd : to) {
            this.mapIn(in, cmd, in);
        }
    }

    @Deprecated
    public void mapInField(Object o, String out, Object from, String from_out) {
        this.controller.mapInField(o, out, from, from_out);
    }

    @Deprecated
    public void mapInField(Object o, String out, Object from) {
        this.controller.mapInField(o, out, from, out);
    }

    @Deprecated
    public void mapOutField(Object o, String out, Object from, String from_out) {
        this.controller.mapOutField(o, out, from, from_out);
    }

    @Deprecated
    public void mapOutField(Object o, String out, Object from) {
        this.controller.mapOutField(o, out, from, out);
    }

    @Deprecated
    public void mapOut(String out, Object from, String from_out) {
        this.controller.mapOut(out, from, from_out);
    }

    @Deprecated
    public void mapOut(String out, Object from) {
        this.mapOut(out, from, out);
    }

    protected void check() {
        this.controller.sanityCheck();
    }

    protected void internalExec() throws ComponentException {
        this.controller.internalExec();
    }

    public void addListener(Notification.Listener l) {
        this.controller.getNotification().addListener(l);
    }

    public void removeListerer(Notification.Listener l) {
        this.controller.getNotification().removeListener(l);
    }
}

