/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.HashSet;
import java.util.Set;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.opengis.filter.Filter;

public class SetAttributeType
extends AttributeDescriptorImpl
implements AttributeType {
    private final AttributeType[] children;

    public SetAttributeType(SetAttributeType copy) {
        super(copy.getType(), copy.getName(), copy.getMinOccurs(), copy.getMaxOccurs(), copy.isNillable(), copy.getDefaultValue());
        this.children = copy.getAttributeTypes();
    }

    public SetAttributeType(String name, boolean nillable, int min, int max, AttributeType[] children, Filter restriction) {
        super(DefaultAttributeType.createAttributeType(name, Set.class, restriction), new NameImpl(name), min, max, nillable, null);
        this.children = children;
    }

    public SetAttributeType(String name, boolean nillable, AttributeType[] children) {
        this(name, nillable, 1, 1, children, (Filter)Filter.EXCLUDE);
    }

    public Filter getRestriction() {
        return DefaultAttributeType.getRestriction(this);
    }

    public String getLocalName() {
        return DefaultAttributeType.getLocalName(this);
    }

    public Class getBinding() {
        return DefaultAttributeType.getBinding(this);
    }

    public boolean isGeometry() {
        return false;
    }

    public Object parse(Object value) throws IllegalArgumentException {
        if (value instanceof Set) {
            Object[] in = ((Set)value).toArray();
            HashSet<Object> out = new HashSet<Object>(in.length);
            if (in.length == this.children.length) {
                for (int i = 0; i < this.children.length; ++i) {
                    out.add(this.children[i].parse(in[i]));
                }
                return out;
            }
            throw new IllegalArgumentException("Expected " + this.children.length + " Objects, got " + in.length + " Objects");
        }
        throw new IllegalArgumentException("Not an Object []");
    }

    public void validate(Object obj) throws IllegalArgumentException {
        if (obj instanceof Set) {
            Object[] in = ((Set)obj).toArray();
            if (in.length == this.children.length) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].validate(in[i]);
                }
                return;
            }
            throw new IllegalArgumentException("Expected " + this.children.length + " Objects, got " + in.length + " Objects");
        }
        throw new IllegalArgumentException("Not an Object []");
    }

    public Object duplicate(Object src) throws IllegalAttributeException {
        if (src instanceof Set) {
            Object[] in = ((Set)src).toArray();
            HashSet<Object> out = new HashSet<Object>(in.length);
            if (in.length == this.children.length) {
                for (int i = 0; i < this.children.length; ++i) {
                    out.add(this.children[i].duplicate(in[i]));
                }
                return out;
            }
            throw new IllegalArgumentException("Expected " + this.children.length + " Objects, got " + in.length + " Objects");
        }
        throw new IllegalArgumentException("Not an Object []");
    }

    public Object createDefaultValue() {
        HashSet<Object> out = new HashSet<Object>(this.children.length);
        for (int i = 0; i < this.children.length; ++i) {
            out.add(this.children[i].createDefaultValue());
        }
        return out;
    }

    public boolean hasAttributeType(String xPath) {
        return this.getAttributeType(xPath) != null;
    }

    public int getAttributeCount() {
        return this.children.length;
    }

    public AttributeType getAttributeType(String xPath) {
        AttributeType attType = null;
        int idx = this.find(xPath);
        if (idx >= 0) {
            attType = this.children[idx];
        }
        return attType;
    }

    public int find(AttributeType type) {
        if (type == null) {
            return -1;
        }
        int idx = this.find(type.getLocalName());
        if (idx < 0 || !this.children[idx].equals(type)) {
            idx = -1;
        }
        return idx;
    }

    public int find(String attName) {
        int i;
        for (i = 0; i < this.children.length && !attName.equals(this.children[i].getLocalName()); ++i) {
        }
        return i == this.children.length ? -1 : i;
    }

    public AttributeType getAttributeType(int position) {
        return this.children[position];
    }

    public AttributeType[] getAttributeTypes() {
        return (AttributeType[])this.children.clone();
    }
}

