/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.ui.view;

import jams.worldwind.data.DataTransfer3D;
import jams.worldwind.ui.view.ShapeAttributePlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ShapeAttributeView
extends JDialog {
    private JTable t;
    private DataTransfer3D dataTransfer;
    private String id;
    private Frame owner;
    ShapeAttributePlot shapePlot;

    public ShapeAttributeView(Frame owner, String title, String[][] data, DataTransfer3D dataTransfer) {
        super(owner, title);
        this.owner = owner;
        this.id = data[0][1];
        this.setDataTransfer(dataTransfer);
        this.init();
        this.setData(data);
    }

    public void setDataTransfer(DataTransfer3D dataTransfer) {
        this.dataTransfer = dataTransfer;
    }

    public void setData(String[][] data) {
        this.t.setModel(new DefaultTableModel(data, new String[]{"Attribute", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
    }

    private void init() {
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.setLocationByPlatform(true);
        this.t = new JTable();
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.t);
        this.getContentPane().add((Component)sp, "Center");
        JButton plotButton = new JButton("Plot");
        plotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ShapeAttributeView.this.shapePlot == null) {
                    ShapeAttributeView.this.shapePlot = new ShapeAttributePlot(ShapeAttributeView.this, "Entity " + ShapeAttributeView.this.id + ": Data Plot", ShapeAttributeView.this.id, ShapeAttributeView.this.dataTransfer);
                }
                ShapeAttributeView.this.shapePlot.setVisible(true);
                ShapeAttributeView.this.shapePlot.toFront();
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShapeAttributeView.this.dispose();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(plotButton);
        buttonPanel.add(closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
    }

    public static void main(String[] args) {
        String[][] o = new String[][]{{"0", "1"}, {"2", "3"}};
        ShapeAttributeView d = new ShapeAttributeView(null, "TEST", o, null);
        d.setVisible(true);
        String[][] o2 = new String[][]{{"0", "1"}, {"4", "5"}};
        d.setData(o2);
    }
}

