/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.handler;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.event.MessageListener;
import gov.nasa.worldwind.render.Highlightable;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import gov.nasa.worldwindx.examples.util.HighlightController;
import gov.nasa.worldwindx.examples.util.ScreenSelector;
import java.util.ArrayList;
import java.util.List;

public class SelectionHighlightController
extends HighlightController
implements MessageListener {
    protected ScreenSelector screenSelector;
    protected List<Highlightable> lastBoxHighlightObjects = new ArrayList<Highlightable>();

    public SelectionHighlightController(WorldWindow wwd, ScreenSelector screenSelector) {
        super(wwd, (Object)"gov.nasa.worldwind.SelectEvent.Rollover");
        this.screenSelector = screenSelector;
        this.screenSelector.addMessageListener((MessageListener)this);
    }

    public void dispose() {
        super.dispose();
        this.screenSelector.removeMessageListener((MessageListener)this);
    }

    public void onMessage(Message msg) {
        try {
            if (msg.getName().equals("ScreenSelector.SelectionStarted") || msg.getName().equals("ScreenSelector.SelectionChanged")) {
                this.highlightSelectedObjects(this.screenSelector.getSelectedObjects());
            }
        }
        catch (Exception e) {
            Util.getLogger().warning(e.getMessage() != null ? e.getMessage() : e.toString());
        }
    }

    protected void highlight(Object o) {
        if (this.lastHighlightObject != o && this.lastBoxHighlightObjects.contains(this.lastHighlightObject)) {
            this.lastHighlightObject = null;
            return;
        }
        super.highlight(o);
    }

    protected void highlightSelectedObjects(List<?> list) {
        if (this.lastBoxHighlightObjects.equals(list)) {
            return;
        }
        for (Highlightable h : this.lastBoxHighlightObjects) {
            if (h == this.lastHighlightObject) continue;
            h.setHighlighted(false);
        }
        this.lastBoxHighlightObjects.clear();
        if (list != null) {
            for (Object o : list) {
                if (!(o instanceof Highlightable)) continue;
                this.lastBoxHighlightObjects.add((Highlightable)o);
            }
        }
        this.wwd.redraw();
    }
}

