/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.DoubleStream;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervallCalculation {
    private static final Logger logger = LoggerFactory.getLogger(IntervallCalculation.class);
    private final double[] values;
    private final SummaryStatistics statistics;

    public IntervallCalculation(double[] dvalues, SummaryStatistics statistics) {
        this.values = dvalues;
        this.statistics = statistics;
    }

    public double getValue(int index) {
        if (index >= 0 && index < this.values.length) {
            return this.values[index];
        }
        return Double.NaN;
    }

    public double[] getValues() {
        return this.values;
    }

    public double getMinimumValue() {
        return this.statistics.getMin();
    }

    public double getMaximumValue() {
        return this.statistics.getMax();
    }

    public double getRange() {
        return this.getMaximumValue() - this.getMinimumValue();
    }

    public double getMean() {
        return this.statistics.getMean();
    }

    public double getVariance() {
        return this.statistics.getVariance();
    }

    public double getStandardDeviation() {
        return this.statistics.getStandardDeviation();
    }

    private List<Double> standardMinimumMaximumIntervall() {
        ArrayList<Double> breakPoints = new ArrayList<Double>(2);
        breakPoints.add(this.getMinimumValue());
        breakPoints.add(this.getMaximumValue());
        return breakPoints;
    }

    public List<Double> getEqualIntervall(int numberOfClasses) {
        if (numberOfClasses > 0) {
            ArrayList<Double> breakPoints = new ArrayList<Double>(numberOfClasses + 1);
            double intervallWidth = this.getRange() / (double)numberOfClasses;
            double sum = 0.0;
            breakPoints.add(this.getMinimumValue());
            for (int i = 1; i < numberOfClasses; ++i) {
                breakPoints.add(Math.nextUp((Double)breakPoints.get(i - 1)) + intervallWidth);
            }
            breakPoints.add(this.getMaximumValue());
            return breakPoints;
        }
        logger.warn("Intervall classes must be greater zero! Getting standard intervall!");
        return this.standardMinimumMaximumIntervall();
    }

    public List<Double> getEqualIntervall(double min, double max, int numberOfClasses) {
        if (numberOfClasses > 0) {
            ArrayList<Double> breakPoints = new ArrayList<Double>(numberOfClasses + 1);
            double intervallWidth = (max - min) / (double)numberOfClasses;
            double sum = 0.0;
            breakPoints.add(this.getMinimumValue());
            for (int i = 1; i < numberOfClasses; ++i) {
                breakPoints.add(Math.nextUp((Double)breakPoints.get(i - 1)) + intervallWidth);
            }
            breakPoints.add(this.getMaximumValue());
            return breakPoints;
        }
        logger.warn("Intervall classes must be greater zero! Getting standard intervall!");
        return this.standardMinimumMaximumIntervall();
    }

    public List<Double> getDefinedIntervall(double intervallSize) {
        if (intervallSize > 0.0) {
            int numberOfClasses = (int)Math.round(this.getRange() / intervallSize);
            return this.getEqualIntervall(numberOfClasses);
        }
        logger.warn("Intervall size must be greater zero! Getting standard intervall!");
        return this.standardMinimumMaximumIntervall();
    }

    public List<Double> getQuantilIntervall(int numberOfClasses) {
        if (numberOfClasses <= 0) {
            logger.warn("Intervall classes must be greater zero! Getting standard intervall!");
            return this.standardMinimumMaximumIntervall();
        }
        double[] uniques = DoubleStream.of(this.values).distinct().toArray();
        double width = 100 / numberOfClasses;
        ArrayList<Double> breakPoints = new ArrayList<Double>(numberOfClasses + 1);
        breakPoints.add(this.getMinimumValue());
        double d = width;
        for (int i = 1; i < numberOfClasses; ++i) {
            breakPoints.add(StatUtils.percentile((double[])uniques, (double)d));
            d += width;
        }
        breakPoints.add(this.getMaximumValue());
        return breakPoints;
    }

    public void printHistogramm(List<?> intervall) {
        double[] tmp = (double[])this.values.clone();
        Arrays.sort(tmp);
        int start = 0;
        int count = 0;
        int sum = 0;
        for (int h = 0; h < intervall.size() - 1; ++h) {
            System.out.print("[" + intervall.get(h) + "," + intervall.get(h + 1) + "] : ");
            for (int i = start; i < tmp.length && tmp[i] <= (Double)intervall.get(h + 1); ++i) {
                System.out.print("*");
                ++count;
                ++start;
            }
            System.out.print(" | COUNT: " + count);
            sum += count;
            count = 0;
            System.out.println();
        }
        System.out.println("SUMMARY: TOTAL STARS: " + sum + " | TOTAL ELEMENTS: " + tmp.length);
    }

    public int getIntervallIndex(List<?> intervall, double d) {
        for (int j = 0; j < intervall.size() - 1; ++j) {
            if (!(d >= (Double)intervall.get(j) && d < (Double)intervall.get(j + 1)) && d != (Double)intervall.get(intervall.size() - 1)) continue;
            return j;
        }
        throw new NoSuchElementException("VALUE (" + d + ") NOT FOUND IN INTERVALL " + this.values);
    }
}

