/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind;

import gov.nasa.worldwind.Configuration;
import jams.worldwind.ui.view.GlobeView;
import java.awt.EventQueue;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Starter {
    static final String appName = "JAMS WorldWind";
    static final Logger logger = LoggerFactory.getLogger(Starter.class);

    public static void main(String[] args) {
        logger.info("Entering Starter application.");
        if (Configuration.isMacOS()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", appName);
        }
        if (args[0].equals("run_from_netbeans")) {
            System.out.println("Run from Netbeans...");
            System.setProperty("gov.nasa.worldwind.app.config.document", System.getProperty("user.dir") + "/dist/config/worldwind.xml");
        } else {
            String path;
            System.out.println("Normal start...");
            String decodedPath = path = Starter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            try {
                decodedPath = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.toString());
            }
            String absolutePath = decodedPath.substring(0, decodedPath.lastIndexOf("/"));
            System.setProperty("gov.nasa.worldwind.app.config.document", absolutePath + "/config/worldwind.xml");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlobeView view = GlobeView.getInstance();
                view.readFromDisk("../../JAMSworldwind/src/jams/worldwind/test/DataTransfer3DTestData.ser");
                view.show();
            }
        });
        logger.info("Exiting Starter application.");
    }

    static {
        System.setProperty("java.net.useSystemProxies", "true");
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Application");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("apple.awt.brushMetalLook", "true");
        } else if (Configuration.isWindowsOS()) {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
    }
}

