/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.testFunctions;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Hosaki Test Function", author="Peter Krause", description="A test function for optimizers which has a global and a local optimum")
public class NashCascadeTestFunction
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="number of storages")
    public Attribute.Double para_n;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="recession coefficient k")
    public Attribute.Double para_k;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="input reduction value")
    public Attribute.Double para_r;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="parameter e")
    public Attribute.DoubleArray storages;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the input value")
    public Attribute.Double input;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the simulated response")
    public Attribute.Double simulation;

    public void init() {
        int n = (int)this.para_n.getValue();
        double[] stor = new double[n];
        for (int i = 0; i < n; ++i) {
            stor[i] = 0.0;
        }
        this.storages.setValue(stor);
    }

    public void run() {
        int n = (int)this.para_n.getValue();
        double inp = this.input.getValue() * this.para_r.getValue();
        double k = this.para_k.getValue();
        double[] stor = this.storages.getValue();
        double y = this.nash(inp, k, stor);
        this.simulation.setValue(y);
    }

    public double nash(double inp, double k, double[] stor) {
        int n = stor.length;
        double[] outflow = new double[n];
        double[] xend = new double[n + 1];
        stor[0] = stor[0] + inp;
        for (int i = 0; i < n; ++i) {
            try {
                outflow[i] = k * stor[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("Some error occured");
            }
            stor[i] = stor[i] - outflow[i];
            if (i <= 0) continue;
            stor[i] = stor[i] + outflow[i - 1];
        }
        return outflow[n - 1];
    }
}

