/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Daily Reservoir module", author="Manfred Fink", description="Reservoir Management according to pool based management ;reservoir plan for daily timesteps; no proper flood modeintegration into the reaches", date="21.05.2025", version="1.0")
public class ReservoirMan_plan
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The reach collection")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="outflow from reservoir", unit="L")
    public Attribute.Double Simrunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="initial storage in the reservoir [l]", unit="L", defaultValue="0.0")
    public Attribute.Double res_init_l;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="storage in the reservoir", unit="L")
    public Attribute.Double Res_Storage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RD1 storage in the reservoir", unit="L")
    public Attribute.Double Res_Storage_RD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RD2 storage in the reservoir", unit="L")
    public Attribute.Double Res_Storage_RD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RG1 storage in the reservoir", unit="L")
    public Attribute.Double Res_Storage_RG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RG2 storage in the reservoir", unit="L")
    public Attribute.Double Res_Storage_RG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD1 inflow to reach", unit="L")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD2 inflow to reach", unit="L")
    public Attribute.Double inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG1 inflow to reach", unit="L")
    public Attribute.Double inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG2 inflow to reach", unit="L")
    public Attribute.Double inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="additional inflow to reach", unit="L", defaultValue="0")
    public Attribute.Double inAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="release from reservoir", unit="L")
    public Attribute.Double outflow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Linear Calibration parameter of poolbased outflow", unit="-", defaultValue="1.0")
    public Attribute.Double cal_pool_out;

    public void init() {
    }

    public void run() {
        Attribute.Entity reach = this.entities.getCurrent();
        if (reach.existsAttribute("nrPools")) {
            double run_res_storage = reach.getDouble("res_storage");
            double run_outflow = 0.0;
            int month = this.time.get(2) + 1;
            int nrPools = reach.getInt("nrPools");
            double RD1act = this.inRD1.getValue();
            double RD2act = this.inRD2.getValue();
            double RG1act = this.inRG1.getValue();
            double RG2act = this.inRG2.getValue();
            this.inRD1.setValue(0.0);
            this.inRD2.setValue(0.0);
            this.inRG1.setValue(0.0);
            this.inRG2.setValue(0.0);
            double run_res_storage_RD1 = reach.getDouble("res_storage_RD1") + RD1act;
            double run_res_storage_RD2 = reach.getDouble("res_storage_RD2") + RD2act;
            double run_res_storage_RG1 = reach.getDouble("res_storage_RG1") + RG1act;
            double run_res_storage_RG2 = reach.getDouble("res_storage_RG2") + RG2act;
            double run_res_storageInput = RD1act + RD2act + RG1act + RG2act;
            double run_res_prop_RD1 = run_res_storage_RD1 / (run_res_storage += run_res_storageInput);
            double run_res_prop_RD2 = run_res_storage_RD2 / run_res_storage;
            double run_res_prop_RG1 = run_res_storage_RG1 / run_res_storage;
            double run_res_prop_RG2 = run_res_storage_RG2 / run_res_storage;
            for (int i = nrPools; i > 0; --i) {
                String end = "V_end" + i;
                Double end_l = reach.getDouble(end) * 1000.0;
                String Q_Mon_Pool = "Q" + month + i;
                if (end_l > run_res_storage) {
                    run_outflow = 86400.0 * this.cal_pool_out.getValue() * reach.getDouble(Q_Mon_Pool);
                    run_outflow = Math.min(run_outflow, run_res_storage);
                    continue;
                }
                if (!(run_res_storage > end_l) || i != nrPools) continue;
                run_outflow = Math.max(86400.0 * this.cal_pool_out.getValue() * reach.getDouble("Q" + month + nrPools), run_res_storageInput);
                run_outflow = Math.min(run_outflow, run_res_storage);
            }
            double run_RD1_outflow = run_outflow * run_res_prop_RD1;
            double run_RD2_outflow = run_outflow * run_res_prop_RD2;
            double run_RG1_outflow = run_outflow * run_res_prop_RG1;
            double run_RG2_outflow = run_outflow * run_res_prop_RG2;
            reach.setDouble("res_storage", run_res_storage - run_outflow);
            reach.setDouble("res_storage_RD1", run_res_storage_RD1 - run_RD1_outflow);
            reach.setDouble("res_storage_RD2", run_res_storage_RD2 - run_RD2_outflow);
            reach.setDouble("res_storage_RG1", run_res_storage_RG1 - run_RG1_outflow);
            reach.setDouble("res_storage_RG2", run_res_storage_RG2 - run_RG2_outflow);
            this.Res_Storage_RD1.setValue(run_res_storage_RD1 - run_RD1_outflow);
            this.Res_Storage_RD2.setValue(run_res_storage_RD2 - run_RD2_outflow);
            this.Res_Storage_RG1.setValue(run_res_storage_RG1 - run_RG1_outflow);
            this.Res_Storage_RG2.setValue(run_res_storage_RG2 - run_RG2_outflow);
            this.Res_Storage.setValue(run_res_storage - run_outflow);
            this.outflow.setValue(run_outflow);
            this.inRD1.setValue(run_RD1_outflow);
            this.inRD2.setValue(run_RD2_outflow);
            this.inRG1.setValue(run_RG1_outflow);
            this.inRG2.setValue(run_RG2_outflow);
        } else {
            this.inRD1.setValue(this.inRD1.getValue());
            this.inRD2.setValue(this.inRD2.getValue());
            this.inRG1.setValue(this.inRG1.getValue());
            this.inRG2.setValue(this.inRG2.getValue());
        }
    }
}

