/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.refET;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import org.unijena.j2k.refET.CalcVariables;

@JAMSComponentDescription(title="CalcDailyETP_PenmanMonteith", author="Peter Krause", description="Calculates potential ETP after Penman-Monteith", version="1.0_0", date="2011-05-30")
public class CalcRefET
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d or h]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable wind", unit="m/s")
    public Attribute.Double wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable minimum temperature", unit="\u00b0C")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable maximum temperature", unit="\u00b0C")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable relative humidity", unit="%")
    public Attribute.Double rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable net radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double netRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state extraterrestric radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double extRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable solar radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute elevation", unit="m")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area", unit="m\u00b2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="reference potential ETP [mm]", unit="mm d^-1")
    public Attribute.Double refET;

    public void init() throws Attribute.Entity.NoSuchAttributeException, IOException {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        double CP = 0.001031;
        double albedo = 0.23;
        double rc = 70.0;
        double clearSkyTrans = 0.75;
        double extRad = this.extRad.getValue();
        double solRad = this.solRad.getValue();
        double tmin = this.tmin.getValue();
        double tmean = this.tmean.getValue();
        double tmax = this.tmax.getValue();
        double rhum = this.rhum.getValue();
        double wind = this.wind.getValue();
        double elevation = this.elevation.getValue();
        double area = this.area.getValue();
        double latHeat = CalcVariables.calc_latentHeatOfVaporization(tmean);
        double airPressure = CalcVariables.calcAirPressure(elevation);
        double atmDens = CalcVariables.calcAtmosphericDensity(tmean, airPressure);
        double esT = CalcVariables.calcSaturationVapourPressure(tmean);
        double ea = CalcVariables.calcActualVapourPressure(esT, rhum);
        double vapPresDef = esT - ea;
        double slopSPC = CalcVariables.calc_slopeOfSaturationPressureCurve(tmean);
        double psyConst = CalcVariables.calc_psyConst(airPressure, latHeat);
        double ra = CalcVariables.calcAerodynamicResistance(wind);
        double nRad = this.netRad.getValue();
        double kt = 0.0;
        if (this.tempRes.getValue().equals("d")) {
            kt = 86400.0;
        } else if (this.tempRes.getValue().equals("h")) {
            kt = 3600.0;
        }
        double pETP = 1.0 / latHeat * (slopSPC * (nRad - 0.0) + kt * (vapPresDef * atmDens * 0.001031) / ra) / (slopSPC + psyConst * (1.0 + 70.0 / ra));
        pETP *= area;
        if (pETP < 0.0) {
            pETP = 0.0;
        }
        this.refET.setValue(pETP);
        this.netRad.setValue(nRad);
    }

    public void cleanup() throws IOException {
    }

    private double calc_groundHeatFlux(double netRad) {
        double g = 0.1 * netRad;
        return g;
    }

    private double calc_raAllen(double veg_height, double windspeed) {
        double w = Math.log((2.0 - 0.6666666666666666 * veg_height) / (0.123 * veg_height));
        double r = Math.log((2.0 - 0.6666666666666666 * veg_height) / (0.0123 * veg_height));
        double v = Math.pow(0.41, 2.0) * windspeed;
        double ra = w * r / v;
        return ra;
    }

    private static double calc_raSchulla(double eff_height, double wind_speed) {
        double ra = eff_height < 10.0 ? 4.72 * Math.pow(Math.log(2.0 / (0.125 * eff_height)), 2.0) / (1.0 + 0.54 * wind_speed) : 64.0 / (1.0 + 0.54 * wind_speed);
        return ra;
    }

    private double calc_rs(double LAI, double rsc, double rss) {
        double A = Math.pow(0.7, LAI);
        double rs = 1.0 / ((1.0 - A) / rsc + A / rss);
        return rs;
    }
}

